/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.insights;

import com.android.tools.idea.insights.AppInsightsIssue;
import com.android.tools.idea.insights.Frame;
import com.android.tools.idea.insights.analysis.Cause;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J\u0015\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000bH\u00c2\u0003JG\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010 \u001a\u00020\fJ\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lcom/android/tools/idea/insights/AppInsight;", "", "line", "", "issue", "Lcom/android/tools/idea/insights/AppInsightsIssue;", "stackFrame", "Lcom/android/tools/idea/insights/Frame;", "cause", "Lcom/android/tools/idea/insights/analysis/Cause;", "markAsSelectedCallback", "Lkotlin/Function1;", "", "(ILcom/android/tools/idea/insights/AppInsightsIssue;Lcom/android/tools/idea/insights/Frame;Lcom/android/tools/idea/insights/analysis/Cause;Lkotlin/jvm/functions/Function1;)V", "getCause", "()Lcom/android/tools/idea/insights/analysis/Cause;", "getIssue", "()Lcom/android/tools/idea/insights/AppInsightsIssue;", "getLine", "()I", "getStackFrame", "()Lcom/android/tools/idea/insights/Frame;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "markAsSelected", "toString", "", "intellij.android.app-quality-insights.api"})
public final class AppInsight {
    private final int line;
    @NotNull
    private final AppInsightsIssue issue;
    @NotNull
    private final Frame stackFrame;
    @NotNull
    private final Cause cause;
    @NotNull
    private final Function1<AppInsightsIssue, Unit> markAsSelectedCallback;

    public AppInsight(int line2, @NotNull AppInsightsIssue issue2, @NotNull Frame stackFrame, @NotNull Cause cause, @NotNull Function1<? super AppInsightsIssue, Unit> markAsSelectedCallback) {
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)stackFrame, (String)"stackFrame");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter(markAsSelectedCallback, (String)"markAsSelectedCallback");
        this.line = line2;
        this.issue = issue2;
        this.stackFrame = stackFrame;
        this.cause = cause;
        this.markAsSelectedCallback = markAsSelectedCallback;
    }

    public final int getLine() {
        return this.line;
    }

    @NotNull
    public final AppInsightsIssue getIssue() {
        return this.issue;
    }

    @NotNull
    public final Frame getStackFrame() {
        return this.stackFrame;
    }

    @NotNull
    public final Cause getCause() {
        return this.cause;
    }

    public final void markAsSelected() {
        Logger.getInstance(AppInsight.class).info("Mark issue as selected " + this.issue);
        this.markAsSelectedCallback.invoke((Object)this.issue);
    }

    public final int component1() {
        return this.line;
    }

    @NotNull
    public final AppInsightsIssue component2() {
        return this.issue;
    }

    @NotNull
    public final Frame component3() {
        return this.stackFrame;
    }

    @NotNull
    public final Cause component4() {
        return this.cause;
    }

    private final Function1<AppInsightsIssue, Unit> component5() {
        return this.markAsSelectedCallback;
    }

    @NotNull
    public final AppInsight copy(int line2, @NotNull AppInsightsIssue issue2, @NotNull Frame stackFrame, @NotNull Cause cause, @NotNull Function1<? super AppInsightsIssue, Unit> markAsSelectedCallback) {
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)stackFrame, (String)"stackFrame");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter(markAsSelectedCallback, (String)"markAsSelectedCallback");
        return new AppInsight(line2, issue2, stackFrame, cause, markAsSelectedCallback);
    }

    public static /* synthetic */ AppInsight copy$default(AppInsight appInsight, int n, AppInsightsIssue appInsightsIssue, Frame frame, Cause cause, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = appInsight.line;
        }
        if ((n2 & 2) != 0) {
            appInsightsIssue = appInsight.issue;
        }
        if ((n2 & 4) != 0) {
            frame = appInsight.stackFrame;
        }
        if ((n2 & 8) != 0) {
            cause = appInsight.cause;
        }
        if ((n2 & 0x10) != 0) {
            function1 = appInsight.markAsSelectedCallback;
        }
        return appInsight.copy(n, appInsightsIssue, frame, cause, function1);
    }

    @NotNull
    public String toString() {
        return "AppInsight(line=" + this.line + ", issue=" + this.issue + ", stackFrame=" + this.stackFrame + ", cause=" + this.cause + ", markAsSelectedCallback=" + this.markAsSelectedCallback + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.line);
        result2 = result2 * 31 + this.issue.hashCode();
        result2 = result2 * 31 + this.stackFrame.hashCode();
        result2 = result2 * 31 + this.cause.hashCode();
        result2 = result2 * 31 + this.markAsSelectedCallback.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AppInsight)) {
            return false;
        }
        AppInsight appInsight = (AppInsight)other;
        if (this.line != appInsight.line) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.issue, (Object)appInsight.issue)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.stackFrame, (Object)appInsight.stackFrame)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.cause, (Object)appInsight.cause)) {
            return false;
        }
        return Intrinsics.areEqual(this.markAsSelectedCallback, appInsight.markAsSelectedCallback);
    }
}

