/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.imports;

import com.android.tools.idea.imports.GMavenArtifactIndex;
import com.android.tools.idea.imports.GMavenIndexRepository;
import com.android.tools.idea.imports.KtxMapEntry;
import com.android.tools.idea.imports.LookupData;
import com.android.tools.idea.imports.MalformedIndexException;
import com.android.tools.idea.imports.MavenClassRegistry;
import com.android.tools.idea.imports.MavenClassRegistryBase;
import com.google.gson.stream.JsonReader;
import com.intellij.openapi.diagnostic.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0006H\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\rH\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/imports/MavenClassRegistry;", "Lcom/android/tools/idea/imports/MavenClassRegistryBase;", "indexRepository", "Lcom/android/tools/idea/imports/GMavenIndexRepository;", "(Lcom/android/tools/idea/imports/GMavenIndexRepository;)V", "lookup", "Lcom/android/tools/idea/imports/LookupData;", "getLookup", "()Lcom/android/tools/idea/imports/LookupData;", "findKtxLibrary", "", "artifact", "findLibraryData", "", "Lcom/android/tools/idea/imports/MavenClassRegistryBase$Library;", "className", "useAndroidX", "", "generateLookup", "getCoordinates", "Lcom/android/tools/idea/imports/MavenClassRegistryBase$Coordinate;", "readFqcns", "Lorg/jetbrains/kotlin/name/FqName;", "reader", "Lcom/google/gson/stream/JsonReader;", "readGMavenIndex", "Lcom/android/tools/idea/imports/GMavenArtifactIndex;", "readIndexArray", "readIndicesFromJsonFile", "inputStream", "Ljava/io/InputStream;", "readKtxTargets", "INDEX_KEY", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nMavenClassRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenClassRegistry.kt\ncom/android/tools/idea/imports/MavenClassRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,277:1\n766#2:278\n857#2,2:279\n1#3:281\n10#4:282\n1262#5,3:283\n*S KotlinDebug\n*F\n+ 1 MavenClassRegistry.kt\ncom/android/tools/idea/imports/MavenClassRegistry\n*L\n54#1:278\n54#1:279,2\n72#1:282\n108#1:283,3\n*E\n"})
public final class MavenClassRegistry
extends MavenClassRegistryBase {
    @NotNull
    private final GMavenIndexRepository indexRepository;
    @NotNull
    private final LookupData lookup;

    public MavenClassRegistry(@NotNull GMavenIndexRepository indexRepository) {
        Intrinsics.checkNotNullParameter((Object)indexRepository, (String)"indexRepository");
        this.indexRepository = indexRepository;
        this.lookup = this.generateLookup();
    }

    @NotNull
    public final LookupData getLookup() {
        return this.lookup;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<MavenClassRegistryBase.Library> findLibraryData(@NotNull String className, boolean useAndroidX2) {
        void $this$filterTo$iv$iv;
        String string;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        if (!useAndroidX2) {
            return CollectionsKt.emptyList();
        }
        int index2 = StringsKt.lastIndexOf$default((CharSequence)className, (char)'.', (int)0, (boolean)false, (int)6, null);
        String string2 = className.substring(index2 + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        String shortName = string2;
        if (index2 == -1) {
            string = "";
        } else {
            String string3 = className.substring(0, index2);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        String packageName2 = string;
        List<MavenClassRegistryBase.Library> list2 = this.lookup.getClassNameMap().get(shortName);
        if (list2 == null) {
            return CollectionsKt.emptyList();
        }
        List<MavenClassRegistryBase.Library> foundArtifacts = list2;
        if (((CharSequence)packageName2).length() == 0) {
            return foundArtifacts;
        }
        Iterable $this$filter$iv = foundArtifacts;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MavenClassRegistryBase.Library it = (MavenClassRegistryBase.Library)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getPackageName(), (Object)packageName2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public String findKtxLibrary(@NotNull String artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        return this.lookup.getKtxMap().get(artifact);
    }

    @Override
    @NotNull
    public Collection<MavenClassRegistryBase.Coordinate> getCoordinates() {
        return this.lookup.getCoordinateList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LookupData generateLookup() {
        Object object;
        InputStream data = this.indexRepository.loadIndexFromDisk();
        try {
            object = data;
            Throwable throwable = null;
            try {
                Object it = (InputStream)object;
                boolean bl = false;
                it = this.readIndicesFromJsonFile((InputStream)it);
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = it;
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger2 = Logger.getInstance(MavenClassRegistry.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
            logger2.warn("Problem reading GMaven index file: " + e.getMessage());
            object = LookupData.Companion.getEMPTY();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LookupData readIndicesFromJsonFile(InputStream inputStream) throws IOException {
        LookupData lookupData;
        Closeable closeable = (Closeable)new JsonReader((Reader)new InputStreamReader(inputStream));
        Throwable throwable = null;
        try {
            JsonReader reader2 = (JsonReader)closeable;
            boolean bl = false;
            LookupData map2 = null;
            reader2.beginObject();
            while (reader2.hasNext()) {
                if (Intrinsics.areEqual((Object)reader2.nextName(), (Object)"Index")) {
                    map2 = this.readIndexArray(reader2);
                    continue;
                }
                reader2.skipValue();
            }
            reader2.endObject();
            LookupData lookupData2 = map2;
            if (lookupData2 == null) {
                lookupData2 = LookupData.Companion.getEMPTY();
            }
            lookupData = lookupData2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return lookupData;
    }

    /*
     * WARNING - void declaration
     */
    private final LookupData readIndexArray(JsonReader reader2) throws IOException {
        Map fqcnMap = new LinkedHashMap();
        Map ktxMap = new LinkedHashMap();
        List coordinateList = new ArrayList();
        reader2.beginArray();
        while (reader2.hasNext()) {
            void $this$fold$iv;
            GMavenArtifactIndex indexData = this.readGMavenIndex(reader2);
            Sequence sequence = MapsKt.asSequence(indexData.toMavenClassRegistryMap());
            boolean $i$f$fold = false;
            Map accumulator$iv = fqcnMap;
            for (Object element$iv : $this$fold$iv) {
                void entry;
                Map.Entry entry2 = (Map.Entry)element$iv;
                Map acc = accumulator$iv;
                boolean bl = false;
                acc.merge(entry.getKey(), CollectionsKt.listOf(entry.getValue()), readIndexArray.1.1.INSTANCE);
                accumulator$iv = acc;
            }
            if (indexData.toKtxMapEntry() != null) {
                KtxMapEntry it;
                boolean bl = false;
                ktxMap.put(it.getTargetLibrary(), it.getKtxLibrary());
            }
            coordinateList.add(new MavenClassRegistryBase.Coordinate(indexData.getGroupId(), indexData.getArtifactId(), indexData.getVersion()));
        }
        reader2.endArray();
        return new LookupData(fqcnMap, ktxMap, coordinateList);
    }

    private final GMavenArtifactIndex readGMavenIndex(JsonReader reader2) throws IOException {
        reader2.beginObject();
        String groupId = null;
        String artifactId = null;
        String version2 = null;
        Collection<String> ktxTargets = null;
        Collection<FqName> fqcns = null;
        while (reader2.hasNext()) {
            String string = reader2.nextName();
            if (Intrinsics.areEqual((Object)string, (Object)INDEX_KEY.GROUP_ID.getKey())) {
                groupId = reader2.nextString();
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)INDEX_KEY.ARTIFACT_ID.getKey())) {
                artifactId = reader2.nextString();
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)INDEX_KEY.VERSION.getKey())) {
                version2 = reader2.nextString();
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)INDEX_KEY.KTX_TARGETS.getKey())) {
                ktxTargets = this.readKtxTargets(reader2);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)INDEX_KEY.FQCNS.getKey())) {
                fqcns = this.readFqcns(reader2);
                continue;
            }
            reader2.skipValue();
        }
        String string = groupId;
        if (string == null) {
            throw new MalformedIndexException("Group ID is missing(" + reader2 + ").");
        }
        String string2 = artifactId;
        if (string2 == null) {
            throw new MalformedIndexException("Artifact ID is missing(" + reader2 + ").");
        }
        String string3 = version2;
        if (string3 == null) {
            throw new MalformedIndexException("Version is missing(" + reader2 + ").");
        }
        Collection<String> collection2 = ktxTargets;
        if (collection2 == null) {
            throw new MalformedIndexException("Ktx targets are missing(" + reader2 + ").");
        }
        Collection<FqName> collection3 = fqcns;
        if (collection3 == null) {
            throw new MalformedIndexException("Fully qualified class names are missing(" + reader2 + ").");
        }
        GMavenArtifactIndex gMavenIndex = new GMavenArtifactIndex(string, string2, string3, collection2, collection3);
        reader2.endObject();
        return gMavenIndex;
    }

    private final Collection<FqName> readFqcns(JsonReader reader2) throws IOException {
        List fqcns = new ArrayList();
        reader2.beginArray();
        while (reader2.hasNext()) {
            fqcns.add(new FqName(reader2.nextString()));
        }
        reader2.endArray();
        return fqcns;
    }

    private final Collection<String> readKtxTargets(JsonReader reader2) throws IOException {
        List decoratedLibraries = new ArrayList();
        reader2.beginArray();
        while (reader2.hasNext()) {
            String string = reader2.nextString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reader.nextString()");
            decoratedLibraries.add(string);
        }
        reader2.endArray();
        return decoratedLibraries;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/imports/MavenClassRegistry$INDEX_KEY;", "", "key", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getKey", "()Ljava/lang/String;", "GROUP_ID", "ARTIFACT_ID", "VERSION", "KTX_TARGETS", "FQCNS", "intellij.android.core"})
    public static final class INDEX_KEY
    extends Enum<INDEX_KEY> {
        @NotNull
        private final String key;
        public static final /* enum */ INDEX_KEY GROUP_ID = new INDEX_KEY("groupId");
        public static final /* enum */ INDEX_KEY ARTIFACT_ID = new INDEX_KEY("artifactId");
        public static final /* enum */ INDEX_KEY VERSION = new INDEX_KEY("version");
        public static final /* enum */ INDEX_KEY KTX_TARGETS = new INDEX_KEY("ktxTargets");
        public static final /* enum */ INDEX_KEY FQCNS = new INDEX_KEY("fqcns");
        private static final /* synthetic */ INDEX_KEY[] $VALUES;

        private INDEX_KEY(String key) {
            this.key = key;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        public static INDEX_KEY[] values() {
            return (INDEX_KEY[])$VALUES.clone();
        }

        public static INDEX_KEY valueOf(String value2) {
            return Enum.valueOf(INDEX_KEY.class, value2);
        }

        static {
            $VALUES = iNDEX_KEYArray = new INDEX_KEY[]{INDEX_KEY.GROUP_ID, INDEX_KEY.ARTIFACT_ID, INDEX_KEY.VERSION, INDEX_KEY.KTX_TARGETS, INDEX_KEY.FQCNS};
        }
    }
}

