/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.imports;

import com.android.annotations.concurrency.Slow;
import com.android.io.CancellableFileIo;
import com.android.tools.idea.imports.GMavenIndexRepositoryKt;
import com.android.tools.idea.imports.GzipUtilsKt;
import com.android.tools.idea.imports.MavenClassRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u000201B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0006\u0010\u0014\u001a\u00020\u000bJ\u0014\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u001cH\u0002J$\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0003H\u0003J\u0010\u0010$\u001a\u00020%2\u0006\u0010 \u001a\u00020\u0003H\u0003J\u0010\u0010&\u001a\u00020%2\u0006\u0010 \u001a\u00020\u0003H\u0003J \u0010'\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u00032\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\"H\u0003J\u0018\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0005H\u0002J\u0018\u0010/\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/android/tools/idea/imports/GMavenIndexRepository;", "Lcom/intellij/openapi/Disposable;", "baseUrl", "", "cacheDir", "Ljava/nio/file/Path;", "refreshInterval", "Ljava/time/Duration;", "(Ljava/lang/String;Ljava/nio/file/Path;Ljava/time/Duration;)V", "lastComputedMavenClassRegistry", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/android/tools/idea/imports/MavenClassRegistry;", "relativeCachePath", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "dispose", "", "getETagFile", "file", "getMavenClassRegistry", "isRetryableError", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "loadETag", "loadIndexFromDisk", "Ljava/io/InputStream;", "readDefaultData", "readUrlData", "Lcom/android/tools/idea/imports/GMavenIndexRepository$ValueWithETag;", "url", "timeoutMillis", "", "eTag", "refresh", "Lcom/android/tools/idea/imports/GMavenIndexRepository$RefreshStatus;", "refreshDiskCache", "refreshWithRetryStrategy", "retryDelayMillis", "", "remainingAttempts", "saveCache", "data", "", "cacheFile", "saveETag", "RefreshStatus", "ValueWithETag", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nGMavenIndexRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GMavenIndexRepository.kt\ncom/android/tools/idea/imports/GMavenIndexRepository\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,315:1\n8#2:316\n8#2:317\n8#2:318\n8#2:319\n8#2:320\n*S KotlinDebug\n*F\n+ 1 GMavenIndexRepository.kt\ncom/android/tools/idea/imports/GMavenIndexRepository\n*L\n117#1:316\n185#1:317\n191#1:318\n195#1:319\n271#1:320\n*E\n"})
public final class GMavenIndexRepository
implements Disposable {
    @NotNull
    private final String baseUrl;
    @NotNull
    private final Path cacheDir;
    @NotNull
    private final Duration refreshInterval;
    @NotNull
    private final String relativeCachePath;
    @NotNull
    private AtomicReference<MavenClassRegistry> lastComputedMavenClassRegistry;
    @NotNull
    private final ScheduledExecutorService scheduler;

    public GMavenIndexRepository(@NotNull String baseUrl, @NotNull Path cacheDir, @NotNull Duration refreshInterval) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
        Intrinsics.checkNotNullParameter((Object)refreshInterval, (String)"refreshInterval");
        this.baseUrl = baseUrl;
        this.cacheDir = cacheDir;
        this.refreshInterval = refreshInterval;
        this.relativeCachePath = StringsKt.endsWith$default((String)"v0.1/classes-v0.1.json.gz", (String)".gz", (boolean)false, (int)2, null) ? StringsKt.dropLast((String)"v0.1/classes-v0.1.json.gz", (int)3) : "v0.1/classes-v0.1.json.gz";
        this.lastComputedMavenClassRegistry = new AtomicReference();
        ScheduledExecutorService scheduledExecutorService = AppExecutorUtil.createBoundedScheduledExecutorService((String)"MavenClassRegistry Refresher", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"createBoundedScheduledEx\u2026try Refresher\",\n    1\n  )");
        this.scheduler = scheduledExecutorService;
        Runnable task2 = new Runnable(this){
            final /* synthetic */ GMavenIndexRepository this$0;
            {
                this.this$0 = $receiver;
            }

            public final void run() {
                GMavenIndexRepository.access$refreshWithRetryStrategy(this.this$0, GMavenIndexRepository.access$getBaseUrl$p(this.this$0) + "/v0.1/classes-v0.1.json.gz", GMavenIndexRepositoryKt.access$getNETWORK_RETRY_INITIAL_DELAY_MILLIS$p(), 4);
            }
        };
        this.scheduler.scheduleWithFixedDelay(task2, 0L, this.refreshInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    @NotNull
    public final MavenClassRegistry getMavenClassRegistry() {
        MavenClassRegistry mavenClassRegistry = this.lastComputedMavenClassRegistry.get();
        if (mavenClassRegistry == null) {
            MavenClassRegistry mavenClassRegistry2;
            MavenClassRegistry $this$getMavenClassRegistry_u24lambda_u240 = mavenClassRegistry2 = new MavenClassRegistry(this);
            boolean bl = false;
            this.lastComputedMavenClassRegistry.set($this$getMavenClassRegistry_u24lambda_u240);
            mavenClassRegistry = mavenClassRegistry2;
        }
        return mavenClassRegistry;
    }

    @Slow
    private final void refreshWithRetryStrategy(String url, long retryDelayMillis, int remainingAttempts) {
        RefreshStatus status2 = this.refresh(url);
        if (status2 == RefreshStatus.RETRY && remainingAttempts > 1) {
            String scheduledTime = GMavenIndexRepositoryKt.access$getDATE_FORMAT$p().format(System.currentTimeMillis() + retryDelayMillis);
            GMavenIndexRepository $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(GMavenIndexRepository.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
            logger2.info("Scheduled to retry refreshing " + this.getClass().getName() + " after " + scheduledTime + ".");
            Runnable retry2 = new Runnable(retryDelayMillis, this, url, remainingAttempts){
                final /* synthetic */ long $retryDelayMillis;
                final /* synthetic */ GMavenIndexRepository this$0;
                final /* synthetic */ String $url;
                final /* synthetic */ int $remainingAttempts;
                {
                    this.$retryDelayMillis = $retryDelayMillis;
                    this.this$0 = $receiver;
                    this.$url = $url;
                    this.$remainingAttempts = $remainingAttempts;
                }

                public final void run() {
                    long nextRetryDelayMillis = (long)((double)this.$retryDelayMillis * 2.0);
                    GMavenIndexRepository.access$refreshWithRetryStrategy(this.this$0, this.$url, nextRetryDelayMillis, this.$remainingAttempts - 1);
                }
            };
            this.scheduler.schedule(retry2, retryDelayMillis, TimeUnit.MILLISECONDS);
        }
    }

    @Slow
    private final RefreshStatus refresh(String url) {
        RefreshStatus status2 = this.refreshDiskCache(url);
        if (status2 == RefreshStatus.UPDATED) {
            this.lastComputedMavenClassRegistry.getAndUpdate(new UnaryOperator(this){
                final /* synthetic */ GMavenIndexRepository this$0;
                {
                    this.this$0 = $receiver;
                }

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final MavenClassRegistry apply(@Nullable MavenClassRegistry it) {
                    MavenClassRegistry mavenClassRegistry;
                    if (it == null) {
                        mavenClassRegistry = null;
                    } else {
                        void var2_2;
                        MavenClassRegistry mavenClassRegistry2 = new MavenClassRegistry(this.this$0);
                        GMavenIndexRepository $this$thisLogger$iv = this.this$0;
                        boolean $i$f$thisLogger = false;
                        Logger logger2 = Logger.getInstance(GMavenIndexRepository.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
                        logger2.info("Updated in-memory Maven class registry.");
                        mavenClassRegistry = var2_2;
                    }
                    return mavenClassRegistry;
                }
            });
        }
        return status2;
    }

    @NotNull
    public final InputStream loadIndexFromDisk() {
        Path file2 = this.cacheDir.resolve(this.relativeCachePath);
        try {
            InputStream inputStream = CancellableFileIo.newInputStream((Path)file2, (OpenOption[])new OpenOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(file)");
            return inputStream;
        }
        catch (NoSuchFileException noSuchFileException) {
            return this.readDefaultData();
        }
    }

    @Slow
    private final RefreshStatus refreshDiskCache(String url) {
        try {
            Path cacheFile = this.cacheDir.resolve(this.relativeCachePath);
            Intrinsics.checkNotNullExpressionValue((Object)cacheFile, (String)"cacheFile");
            String eTagForCacheFile = PathKt.exists((Path)cacheFile) ? this.loadETag(this.getETagFile(cacheFile)) : null;
            ValueWithETag valueWithETag = this.readUrlData(url, 3000, eTagForCacheFile);
            if (valueWithETag == null) {
                GMavenIndexRepository $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger2 = Logger.getInstance(GMavenIndexRepository.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
                logger2.info("Kept the old disk cache with an old ETag header: " + eTagForCacheFile + ".");
                return RefreshStatus.UNCHANGED;
            }
            this.saveCache(valueWithETag.getData(), cacheFile);
            this.saveETag(this.getETagFile(cacheFile), valueWithETag.getETag());
            GMavenIndexRepository $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger3 = Logger.getInstance(GMavenIndexRepository.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(T::class.java)");
            logger3.info("Refreshed disk cache successfully with a new ETag header: " + valueWithETag.getETag() + ".");
            return RefreshStatus.UPDATED;
        }
        catch (Exception e) {
            GMavenIndexRepository $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger4 = Logger.getInstance(GMavenIndexRepository.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"getInstance(T::class.java)");
            logger4.info("Failed to refresh local disk cache:\n" + e);
            return this.isRetryableError(e) ? RefreshStatus.RETRY : RefreshStatus.ERROR;
        }
    }

    private final boolean isRetryableError(Exception e) {
        if (!(e instanceof IOException)) {
            return false;
        }
        if (e instanceof SocketTimeoutException || e instanceof UnknownHostException) {
            return true;
        }
        HttpRequests.HttpStatusException httpStatusException = e instanceof HttpRequests.HttpStatusException ? (HttpRequests.HttpStatusException)e : null;
        if (httpStatusException == null) {
            return false;
        }
        int responseCode = httpStatusException.getStatusCode();
        return responseCode >= 400;
    }

    @Slow
    private final ValueWithETag readUrlData(String url, int timeoutMillis, String eTag) {
        return (ValueWithETag)HttpRequests.request((String)new URL(url).toExternalForm()).connectTimeout(timeoutMillis).readTimeout(timeoutMillis).tuner(new HttpRequests.ConnectionTuner(eTag){
            final /* synthetic */ String $eTag;
            {
                this.$eTag = $eTag;
            }

            public final void tune(@NotNull URLConnection connection2) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
                    String string = this.$eTag;
                    if (string == null) break block0;
                    String it = string;
                    boolean bl = false;
                    connection2.setRequestProperty("If-None-Match", it);
                }
            }
        }).connect(new HttpRequests.RequestProcessor(this, url){
            final /* synthetic */ GMavenIndexRepository this$0;
            final /* synthetic */ String $url;
            {
                this.this$0 = $receiver;
                this.$url = $url;
            }

            @Nullable
            public final ValueWithETag process(@NotNull HttpRequests.Request request2) {
                Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
                String eTagField = request2.getConnection().getHeaderField("ETag");
                URLConnection uRLConnection = request2.getConnection();
                Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                int responseCode = ((HttpURLConnection)uRLConnection).getResponseCode();
                if (responseCode == 304) {
                    GMavenIndexRepository $this$thisLogger$iv = this.this$0;
                    boolean $i$f$thisLogger = false;
                    Logger logger2 = Logger.getInstance(GMavenIndexRepository.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
                    logger2.info("HTTP not modified since the last request for URL: " + this.$url + " (etag: " + eTagField + ").");
                    return null;
                }
                byte[] bytes2 = request2.readBytes(null);
                Intrinsics.checkNotNullExpressionValue((Object)bytes2, (String)"bytes");
                Intrinsics.checkNotNullExpressionValue((Object)eTagField, (String)"eTagField");
                return new ValueWithETag(bytes2, eTagField);
            }
        });
    }

    private final InputStream readDefaultData() {
        InputStream inputStream = GMavenIndexRepository.class.getClassLoader().getResourceAsStream("gmavenIndex/classes-offline.json");
        if (inputStream == null) {
            throw new Error("Unexpected error when reading resource file: classes-offline.json.");
        }
        return inputStream;
    }

    private final void saveCache(byte[] data, Path cacheFile) {
        Path path2 = cacheFile.getParent();
        Intrinsics.checkNotNull((Object)path2);
        Files.createDirectories(path2, new FileAttribute[0]);
        Path tempFile = Files.createTempFile(cacheFile.getParent(), String.valueOf(cacheFile.getFileName()), ".tmp", new FileAttribute[0]);
        try {
            byte[] it = GzipUtilsKt.ungzip(data);
            boolean bl = false;
            Files.write(tempFile, it, new OpenOption[0]);
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE};
            Files.move(tempFile, cacheFile, copyOptionArray);
        }
        catch (Exception e) {
            Files.deleteIfExists(tempFile);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String loadETag(Path file2) {
        String string;
        try {
            Properties properties2;
            Properties $this$loadETag_u24lambda_u243 = properties2 = new Properties();
            boolean bl = false;
            Closeable closeable = CancellableFileIo.newInputStream((Path)file2, (OpenOption[])new OpenOption[0]);
            Throwable throwable = null;
            try {
                InputStream inputStream = (InputStream)closeable;
                boolean bl2 = false;
                $this$loadETag_u24lambda_u243.load(inputStream);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Properties properties3 = properties2;
            string = properties3.getProperty("etag");
        }
        catch (Exception e) {
            GMavenIndexRepository $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(GMavenIndexRepository.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
            logger2.info("Error when loading ETag value:\n" + e);
            string = null;
        }
        return string;
    }

    private final void saveETag(Path file2, String eTag) {
        Properties properties2;
        Properties $this$saveETag_u24lambda_u244 = properties2 = new Properties();
        boolean bl = false;
        $this$saveETag_u24lambda_u244.setProperty("etag", eTag);
        $this$saveETag_u24lambda_u244.store(PathKt.outputStream$default((Path)file2, (boolean)false, (int)1, null), "## Metadata for gmaven index cache. Do not modify.");
    }

    private final Path getETagFile(Path file2) {
        Path path2 = file2.resolveSibling(file2.getFileName() + ".properties");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file.resolveSibling(\"${file.fileName}.properties\")");
        return path2;
    }

    public void dispose() {
        this.scheduler.shutdown();
    }

    public static final /* synthetic */ void access$refreshWithRetryStrategy(GMavenIndexRepository $this, String url, long retryDelayMillis, int remainingAttempts) {
        $this.refreshWithRetryStrategy(url, retryDelayMillis, remainingAttempts);
    }

    public static final /* synthetic */ String access$getBaseUrl$p(GMavenIndexRepository $this) {
        return $this.baseUrl;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/imports/GMavenIndexRepository$RefreshStatus;", "", "(Ljava/lang/String;I)V", "UPDATED", "UNCHANGED", "RETRY", "ERROR", "intellij.android.core"})
    private static final class RefreshStatus
    extends Enum<RefreshStatus> {
        public static final /* enum */ RefreshStatus UPDATED = new RefreshStatus();
        public static final /* enum */ RefreshStatus UNCHANGED = new RefreshStatus();
        public static final /* enum */ RefreshStatus RETRY = new RefreshStatus();
        public static final /* enum */ RefreshStatus ERROR = new RefreshStatus();
        private static final /* synthetic */ RefreshStatus[] $VALUES;

        public static RefreshStatus[] values() {
            return (RefreshStatus[])$VALUES.clone();
        }

        public static RefreshStatus valueOf(String value2) {
            return Enum.valueOf(RefreshStatus.class, value2);
        }

        static {
            $VALUES = refreshStatusArray = new RefreshStatus[]{RefreshStatus.UPDATED, RefreshStatus.UNCHANGED, RefreshStatus.RETRY, RefreshStatus.ERROR};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/imports/GMavenIndexRepository$ValueWithETag;", "", "data", "", "eTag", "", "([BLjava/lang/String;)V", "getData", "()[B", "getETag", "()Ljava/lang/String;", "intellij.android.core"})
    private static final class ValueWithETag {
        @NotNull
        private final byte[] data;
        @NotNull
        private final String eTag;

        public ValueWithETag(@NotNull byte[] data, @NotNull String eTag) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)eTag, (String)"eTag");
            this.data = data;
            this.eTag = eTag;
        }

        @NotNull
        public final byte[] getData() {
            return this.data;
        }

        @NotNull
        public final String getETag() {
            return this.eTag;
        }
    }
}

