/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.view;

import com.android.tools.idea.fileTypes.AndroidIconProvider;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncListenerWithRoot;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.conflict.ConflictResolution;
import com.android.tools.idea.gradle.variant.conflict.ConflictSet;
import com.android.tools.idea.gradle.variant.view.AbiItem;
import com.android.tools.idea.gradle.variant.view.BuildVariantItem;
import com.android.tools.idea.gradle.variant.view.BuildVariantTableModel;
import com.android.tools.idea.gradle.variant.view.BuildVariantTableRow;
import com.android.tools.idea.gradle.variant.view.BuildVariantUpdater;
import com.android.tools.idea.projectsystem.gradle.BuildRelativeGradleProjectPath;
import com.android.tools.idea.projectsystem.gradle.BuildRelativeGradleProjectPathKt;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class BuildVariantView {
    private static final int MODULE_COLUMN_INDEX = 0;
    private static final int VARIANT_COLUMN_INDEX = 1;
    private static final int ABI_COLUMN_INDEX = 2;
    private static final Color CONFLICT_CELL_BACKGROUND = MessageType.ERROR.getPopupBackground();
    private final Project myProject;
    private JPanel myToolWindowPanel;
    private JBTable myVariantsTable;
    private JPanel myNotificationPanel;
    private final List<Conflict> myConflicts;

    @NotNull
    public static BuildVariantView getInstance(@NotNull Project project) {
        return (BuildVariantView)project.getService(BuildVariantView.class);
    }

    private BuildVariantView(@NotNull Project project) {
        this.$$$setupUI$$$();
        this.myConflicts = new ArrayList<Conflict>();
        this.myProject = project;
        ((JComponent)this.myVariantsTable.getParent().getParent()).setBorder((Border)JBUI.Borders.empty());
    }

    private void createUIComponents() {
        this.myVariantsTable = new BuildVariantTable();
        new TableSpeedSearch((JTable)this.myVariantsTable);
        this.myNotificationPanel = new NotificationPanel();
        this.myNotificationPanel.setVisible(false);
    }

    public void createToolWindowContent(@NotNull ToolWindow toolWindow) {
        ContentFactory contentFactory = ContentFactory.getInstance();
        Content content2 = contentFactory.createContent((JComponent)this.myToolWindowPanel, "", false);
        toolWindow.getContentManager().addContent(content2);
    }

    private void updateContents() {
        this.getVariantsTable().setBuildVariantTableModel(BuildVariantTableModel.create(this.myProject));
    }

    private void projectImportStarted() {
        this.getVariantsTable().setLoading();
    }

    private void projectImportFinished() {
        ConflictSet.findConflicts(this.myProject).showSelectionConflicts();
    }

    @NotNull
    private BuildVariantTable getVariantsTable() {
        return (BuildVariantTable)this.myVariantsTable;
    }

    public void updateContents(@NotNull List<Conflict> conflicts2) {
        this.myNotificationPanel.setVisible(!conflicts2.isEmpty());
        ((NotificationPanel)this.myNotificationPanel).myCurrentConflictIndex = -1;
        this.myConflicts.clear();
        this.myConflicts.addAll(conflicts2);
        this.updateContents();
    }

    public void findAndSelect(@NotNull Module module2) {
        this.findAndSelect(module2, 0);
    }

    public void findAndSelectVariantEditor(@NotNull Module module2) {
        this.findAndSelect(module2, 1);
    }

    private void findAndSelect(@NotNull Module module2, int columnIndex) {
        int rowCount = this.myVariantsTable.getRowCount();
        for (int row2 = 0; row2 < rowCount; ++row2) {
            if (!module2.equals(this.myVariantsTable.getValueAt(row2, 0))) continue;
            this.myVariantsTable.getSelectionModel().setSelectionInterval(row2, row2);
            this.myVariantsTable.getColumnModel().getSelectionModel().setSelectionInterval(columnIndex, columnIndex);
            TableUtil.scrollSelectionToVisible((JTable)this.myVariantsTable);
            this.myVariantsTable.requestFocusInWindow();
            break;
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myToolWindowPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBTable jBTable = this.myVariantsTable;
        jBTable.setCellSelectionEnabled(true);
        jBScrollPane.setViewportView((Component)jBTable);
        JPanel jPanel2 = this.myNotificationPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myToolWindowPanel;
    }

    private class BuildVariantTable
    extends JBTable {
        private boolean myLoading;
        private final ModuleTableCell myModuleCellEditor;
        private final ModuleTableCell myModuleCellRenderer;
        private final VariantsCellRenderer myVariantsCellRenderer;
        private final AbisCellRenderer myAbisCellRenderer;

        BuildVariantTable() {
            super((TableModel)BuildVariantTableModel.createEmpty());
            this.myModuleCellEditor = new ModuleTableCell();
            this.myModuleCellRenderer = new ModuleTableCell();
            this.myVariantsCellRenderer = new VariantsCellRenderer();
            this.myAbisCellRenderer = new AbisCellRenderer();
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    Component editorComponent;
                    int column2 = BuildVariantTable.this.getSelectedColumn();
                    int row2 = BuildVariantTable.this.getSelectedRow();
                    if ((column2 == 1 || column2 == 2) && row2 >= 0 && e.getKeyCode() == 113 && BuildVariantTable.this.editCellAt(row2, column2) && (editorComponent = BuildVariantTable.this.getEditorComponent()) instanceof ComboBox) {
                        editorComponent.requestFocusInWindow();
                        ((ComboBox)editorComponent).showPopup();
                    }
                }
            });
            this.setExpandableItemsEnabled(false);
            new TableSpeedSearch((JTable)((Object)this));
        }

        @Nullable
        Conflict findConflict(int row2) {
            for (Conflict conflict2 : BuildVariantView.this.myConflicts) {
                Object module2 = this.getValueAt(row2, 0);
                if (!conflict2.getSource().equals(module2)) continue;
                return conflict2;
            }
            return null;
        }

        public boolean isCellEditable(int row2, int column2) {
            return true;
        }

        private void updateLoadingStatus(boolean loading) {
            this.myLoading = loading;
            this.setPaintBusy(this.myLoading);
            String text2 = this.myLoading ? "Loading..." : "Nothing to Show";
            this.getEmptyText().setText(text2);
        }

        void setLoading() {
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.NON_MODAL, () -> {
                this.updateLoadingStatus(true);
                this.setModel(BuildVariantTableModel.createEmpty());
            });
        }

        private void setBuildVariantTableModel(@NotNull BuildVariantTableModel model2) {
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.NON_MODAL, () -> {
                this.updateLoadingStatus(false);
                this.setModel(model2);
            });
        }

        @Nullable
        private DefaultCellEditor createCellEditor(int row2, BuildVariantTableRow tableRow) {
            Object[] items2 = tableRow.buildVariantsAsArray();
            if (items2 == null) {
                return null;
            }
            BuildVariantItem selected = tableRow.variantItem();
            ComboBox editor = new ComboBox(items2);
            if (selected != null) {
                editor.setSelectedItem((Object)selected);
            }
            editor.setBorder((Border)JBUI.Borders.empty());
            editor.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    BuildVariantItem selectedVariant = (BuildVariantItem)e.getItem();
                    BuildVariantUpdater.getInstance(BuildVariantView.this.myProject).updateSelectedBuildVariant(tableRow.getModule(), selectedVariant.getBuildVariantName());
                }
            });
            final DefaultCellEditor defaultCellEditor = new DefaultCellEditor((JComboBox<?>)editor);
            editor.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        defaultCellEditor.cancelCellEditing();
                    }
                }
            });
            return defaultCellEditor;
        }

        @Nullable
        private DefaultCellEditor createAbiCellEditor(int row2, BuildVariantTableRow tableRow) {
            Object[] items2 = tableRow.abisAsArray();
            if (items2 == null) {
                return null;
            }
            AbiItem selected = tableRow.abiItem();
            ComboBox editor = new ComboBox(items2);
            if (selected != null) {
                editor.setSelectedItem((Object)selected);
            }
            editor.setBorder((Border)JBUI.Borders.empty());
            editor.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    AbiItem selectedAbi = (AbiItem)e.getItem();
                    BuildVariantUpdater.getInstance(BuildVariantView.this.myProject).updateSelectedAbi(tableRow.getModule(), selectedAbi.getAbiName());
                }
            });
            final DefaultCellEditor defaultCellEditor = new DefaultCellEditor((JComboBox<?>)editor);
            editor.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        defaultCellEditor.cancelCellEditing();
                    }
                }
            });
            return defaultCellEditor;
        }

        public TableCellRenderer getCellRenderer(int row2, int column2) {
            if (column2 == 0) {
                return this.myModuleCellRenderer;
            }
            if (column2 == 1) {
                return this.myVariantsCellRenderer;
            }
            return this.myAbisCellRenderer;
        }

        public TableCellEditor getCellEditor(int row2, int column2) {
            BuildVariantTableRow tableRow = ((BuildVariantTableModel)this.getModel()).getRows().get(row2);
            if (column2 == 1) {
                return this.createCellEditor(row2, tableRow);
            }
            if (column2 == 2) {
                return this.createAbiCellEditor(row2, tableRow);
            }
            return this.myModuleCellEditor;
        }
    }

    private class NotificationPanel
    extends JPanel {
        int myCurrentConflictIndex;

        NotificationPanel() {
            super(new BorderLayout());
            this.myCurrentConflictIndex = -1;
            Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.NOTIFICATION_BACKGROUND);
            this.setBackground(color == null ? UIUtil.getToolTipBackground() : color);
            this.setBorder((Border)JBUI.Borders.empty((int)1, (int)15));
            this.setPreferredSize(new Dimension(-1, JBUI.scale((int)24)));
            JLabel textLabel = new JLabel("Variant selection conflicts found");
            textLabel.setOpaque(false);
            this.add((Component)textLabel, "Center");
            DefaultActionGroup group2 = new DefaultActionGroup();
            ActionManager actionManager = ActionManager.getInstance();
            AnAction nextConflictAction = new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    NotificationPanel.this.navigateConflicts(true);
                }
            };
            ActionUtil.copyFrom((AnAction)nextConflictAction, (String)"NextOccurence");
            group2.add(nextConflictAction);
            AnAction prevConflictAction = new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    NotificationPanel.this.navigateConflicts(false);
                }
            };
            ActionUtil.copyFrom((AnAction)prevConflictAction, (String)"PreviousOccurence");
            group2.add(prevConflictAction);
            ActionToolbar toolbar2 = actionManager.createActionToolbar("AndroidBuildVariantViewNotifications", (ActionGroup)group2, true);
            toolbar2.setReservePlaceAutoPopupIcon(false);
            toolbar2.setMinimumButtonSize((Dimension)JBUI.size((int)23, (int)23));
            JComponent toolbarComponent = toolbar2.getComponent();
            toolbarComponent.setBorder(null);
            toolbarComponent.setOpaque(false);
            this.add((Component)toolbarComponent, "East");
        }

        private void navigateConflicts(boolean forward) {
            int conflictCount = BuildVariantView.this.myConflicts.size();
            if (conflictCount == 0) {
                return;
            }
            if (forward) {
                ++this.myCurrentConflictIndex;
                if (this.myCurrentConflictIndex >= conflictCount) {
                    this.myCurrentConflictIndex = 0;
                }
            } else {
                --this.myCurrentConflictIndex;
                if (this.myCurrentConflictIndex < 0) {
                    this.myCurrentConflictIndex = conflictCount - 1;
                }
            }
            Conflict conflict2 = BuildVariantView.this.myConflicts.get(this.myCurrentConflictIndex);
            BuildVariantView.this.findAndSelect(conflict2.getSource());
        }
    }

    static class SyncListener
    implements GradleSyncListenerWithRoot {
        SyncListener() {
        }

        @Override
        public void syncStarted(@NotNull Project project, @SystemIndependent String rootProjectPath) {
            BuildVariantView.getInstance(project).projectImportStarted();
        }

        @Override
        public void syncFailed(@NotNull Project project, @NotNull String errorMessage, @SystemIndependent String rootProjectPath) {
            BuildVariantView.getInstance(project).projectImportFinished();
        }

        @Override
        public void syncSucceeded(@NotNull Project project, @SystemIndependent String rootProjectPath) {
            BuildVariantView.getInstance(project).projectImportFinished();
        }

        @Override
        public void syncSkipped(@NotNull Project project) {
            BuildVariantView.getInstance(project).projectImportFinished();
        }
    }

    private static class ModuleTableCell
    extends AbstractTableCellEditor
    implements TableCellRenderer {
        private static final Border EMPTY_BORDER = JBUI.Borders.empty((int)1);
        @Nullable
        private Conflict myConflict;
        private JPanel myPanel;
        private JLabel myModuleNameLabel = new JLabel();
        private JPanel myButtonsPanel;
        private JButton myFixButton;
        private Object myValue;

        ModuleTableCell() {
            this.myModuleNameLabel.setOpaque(false);
            this.myFixButton = ModuleTableCell.createButton(AllIcons.Actions.QuickfixBulb);
            this.myFixButton.setToolTipText("Fix problem");
            this.myFixButton.addActionListener(e -> {
                if (this.myConflict != null) {
                    Project project = this.myConflict.getSource().getProject();
                    boolean solved = ConflictResolution.solveSelectionConflict(this.myConflict);
                    if (solved) {
                        ConflictSet conflicts2 = ConflictSet.findConflicts(project);
                        conflicts2.showSelectionConflicts();
                    }
                }
                this.stopCellEditing();
            });
            this.myButtonsPanel = new JPanel();
            this.myButtonsPanel.setOpaque(false);
            this.myButtonsPanel.add(this.myFixButton);
            this.myPanel = new JPanel(new BorderLayout()){

                @Override
                public String getToolTipText(MouseEvent e) {
                    String toolTip = ModuleTableCell.getToolTipTextIfUnderX(myModuleNameLabel, e.getX());
                    if (toolTip != null) {
                        return toolTip;
                    }
                    int x = e.getX() - myButtonsPanel.getX();
                    toolTip = ModuleTableCell.getToolTipTextIfUnderX(myFixButton, x);
                    if (toolTip != null) {
                        return toolTip;
                    }
                    return super.getToolTipText(e);
                }
            };
            this.myPanel.add((Component)this.myModuleNameLabel, "Center");
            this.myPanel.add((Component)this.myButtonsPanel, "East");
        }

        @NotNull
        private static JButton createButton(@NotNull Icon icon2) {
            JButton button = new JButton(icon2);
            button.setBorder(null);
            button.setBorderPainted(false);
            button.setContentAreaFilled(false);
            return button;
        }

        @Nullable
        private static String getToolTipTextIfUnderX(@NotNull JComponent c, int x) {
            if (c.isVisible() && x >= c.getX() && x <= c.getX() + c.getWidth()) {
                return c.getToolTipText();
            }
            return null;
        }

        public Component getTableCellEditorComponent(JTable table2, Object value2, boolean isSelected, int row2, int column2) {
            this.setUpComponent(table2, value2, true, true, row2);
            return this.myPanel;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row2, int column2) {
            this.setUpComponent(table2, value2, isSelected, hasFocus, row2);
            return this.myPanel;
        }

        private void setUpComponent(@NotNull JTable table2, @Nullable Object value2, boolean isSelected, boolean hasFocus, int row2) {
            Color background;
            Module module2;
            this.myValue = value2;
            String moduleName2 = null;
            Icon moduleIcon = null;
            boolean isAndriodGradleModule = false;
            if (value2 instanceof Module && !(module2 = (Module)value2).isDisposed()) {
                BuildRelativeGradleProjectPath gradleProjectPath = BuildRelativeGradleProjectPathKt.getBuildAndRelativeGradleProjectPath(module2);
                String modulePath = gradleProjectPath != null ? BuildRelativeGradleProjectPathKt.buildNamePrefixedGradleProjectPath(gradleProjectPath) : null;
                moduleName2 = modulePath != null ? modulePath : module2.getName();
                moduleIcon = AndroidIconProvider.getModuleIcon(module2);
                isAndriodGradleModule = GradleAndroidModel.get(module2) != null;
            }
            this.myModuleNameLabel.setFont(table2.getFont());
            this.myModuleNameLabel.setText(moduleName2 == null ? "" : moduleName2);
            this.myModuleNameLabel.setIcon(moduleIcon);
            Color color = background = isSelected ? table2.getSelectionBackground() : table2.getBackground();
            if (isAndriodGradleModule) {
                this.myConflict = ((BuildVariantTable)((Object)table2)).findConflict(row2);
                this.myModuleNameLabel.setToolTipText(this.myConflict != null ? this.myConflict.toString() : null);
                this.myFixButton.setVisible(this.myConflict != null);
                if (this.myConflict != null) {
                    background = CONFLICT_CELL_BACKGROUND;
                }
            } else {
                this.myFixButton.setVisible(false);
            }
            this.myPanel.setBackground(background);
            Border border = hasFocus ? UIUtil.getTableFocusCellHighlightBorder() : EMPTY_BORDER;
            this.myPanel.setBorder(border);
        }

        public Object getCellEditorValue() {
            return this.myValue;
        }
    }

    private static class AbisCellRenderer
    extends DefaultTableCellRenderer {
        private static final String abisCellHelpTooltipText = "For NDK modules, determines the ABI that will be used by the editor";

        private AbisCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row2, int column2) {
            Component c = super.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row2, column2);
            if (c instanceof JLabel) {
                JLabel component2 = (JLabel)c;
                Color background = isSelected ? table2.getSelectionBackground() : table2.getBackground();
                component2.setBackground(background);
                component2.setToolTipText(abisCellHelpTooltipText);
                component2.setBorder(BorderFactory.createCompoundBorder(component2.getBorder(), (Border)JBUI.Borders.empty((int)3, (int)2, (int)4, (int)2)));
                if (component2.getText().isEmpty()) {
                    component2.setText("\u2014");
                }
            }
            return c;
        }
    }

    private static class VariantsCellRenderer
    extends DefaultTableCellRenderer {
        private static final String variantsCellHelpTooltipText = "Determines the build variant that will be deployed to device and used by the editor";

        private VariantsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row2, int column2) {
            Component c = super.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row2, column2);
            if (c instanceof JLabel) {
                JLabel component2 = (JLabel)c;
                Color background = isSelected ? table2.getSelectionBackground() : table2.getBackground();
                Conflict conflictFound = ((BuildVariantTable)((Object)table2)).findConflict(row2);
                if (conflictFound != null) {
                    background = CONFLICT_CELL_BACKGROUND;
                }
                component2.setBackground(background);
                String toolTip = conflictFound != null ? conflictFound.toString() : variantsCellHelpTooltipText;
                component2.setToolTipText(toolTip);
                component2.setBorder(BorderFactory.createCompoundBorder(component2.getBorder(), (Border)JBUI.Borders.empty((int)3, (int)2, (int)4, (int)2)));
            }
            return c;
        }
    }
}

