/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.view;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.GradleSyncStateHolder;
import com.android.tools.idea.gradle.project.sync.SelectedVariantCollectorKt;
import com.android.tools.idea.gradle.project.sync.SwitchVariantRequest;
import com.android.tools.idea.gradle.project.sync.idea.AndroidGradleProjectResolver;
import com.android.tools.idea.gradle.project.sync.idea.GradleSyncExecutor;
import com.android.tools.idea.gradle.project.sync.idea.KotlinPropertiesKt;
import com.android.tools.idea.gradle.project.sync.idea.VariantSwitcher;
import com.android.tools.idea.project.AndroidNotification;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.gradleJava.compilerPlugin.AbstractAnnotationBasedCompilerPluginGradleImportHandler;
import org.jetbrains.kotlin.idea.gradleJava.configuration.GradleProjectImportHandler;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class BuildVariantUpdater {
    @NotNull
    private final Project myProject;

    @NotNull
    public static BuildVariantUpdater getInstance(@NotNull Project project) {
        return (BuildVariantUpdater)project.getService(BuildVariantUpdater.class);
    }

    BuildVariantUpdater(@NotNull Project project) {
        this.myProject = project;
    }

    public void updateSelectedBuildVariant(@NotNull Module moduleToUpdate, @NotNull String selectedBuildVariant) {
        this.updateSelectedVariant(moduleToUpdate, new SwitchVariantRequest(SelectedVariantCollectorKt.getModuleIdForSyncRequest(moduleToUpdate), selectedBuildVariant, null));
    }

    public void updateSelectedAbi(@NotNull Module moduleToUpdate, @NotNull String selectedAbiName) {
        this.updateSelectedVariant(moduleToUpdate, new SwitchVariantRequest(SelectedVariantCollectorKt.getModuleIdForSyncRequest(moduleToUpdate), null, selectedAbiName));
    }

    public void updateSelectedVariantAndAbi(@NotNull Module module2, @NotNull String selectedVariant, @NotNull String selectedAbiName) {
        this.updateSelectedVariant(module2, new SwitchVariantRequest(SelectedVariantCollectorKt.getModuleIdForSyncRequest(module2), selectedVariant, selectedAbiName));
    }

    private void updateSelectedVariant(@NotNull Module moduleToUpdate, @NotNull SwitchVariantRequest variantAndAbi) {
        DataNode<ProjectData> variantProjectDataNode;
        ExternalProjectInfo data = ProjectDataManager.getInstance().getExternalProjectData(this.myProject, GradleConstants.SYSTEM_ID, this.myProject.getBasePath());
        DataNode<ProjectData> dataNode = variantProjectDataNode = (Boolean)StudioFlags.GRADLE_SYNC_ENABLE_CACHED_VARIANTS.get() != false && data != null ? VariantSwitcher.findVariantProjectData(moduleToUpdate, variantAndAbi, data) : null;
        if (GradleSyncState.getInstance(this.myProject).isSyncNeeded().equals((Object)ThreeState.YES)) {
            BuildVariantUpdater.requestGradleSync(this.myProject, variantAndAbi);
            return;
        }
        if (data != null && variantProjectDataNode != null) {
            VariantSwitcher.findAndSetupSelectedCachedVariantData(data, variantProjectDataNode);
            BuildVariantUpdater.disableKotlinCompilerPluginImportHandlers(this.myProject);
            KotlinPropertiesKt.restoreKotlinUserDataFromDataNodes(variantProjectDataNode);
            BuildVariantUpdater.setupCachedVariant(this.myProject, variantProjectDataNode);
            return;
        }
        AndroidGradleProjectResolver.saveCurrentlySyncedVariantsForReuse(this.myProject);
        BuildVariantUpdater.requestGradleSync(this.myProject, variantAndAbi);
    }

    private static void disableKotlinCompilerPluginImportHandlers(Project project) {
        ExtensionPoint importHandlerEP = project.getExtensionArea().getExtensionPoint(GradleProjectImportHandler.Companion.getExtensionPointName());
        for (GradleProjectImportHandler importHandler : importHandlerEP.getExtensionList()) {
            if (!(importHandler instanceof AbstractAnnotationBasedCompilerPluginGradleImportHandler)) continue;
            importHandlerEP.unregisterExtension(importHandler.getClass());
        }
    }

    @NotNull
    private static GradleSyncListener getSyncListener() {
        return new GradleSyncListener(){

            @Override
            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                AndroidGradleProjectResolver.clearVariantsSavedForReuse(project);
            }

            @Override
            public void syncSucceeded(@NotNull Project project) {
                AndroidGradleProjectResolver.clearVariantsSavedForReuse(project);
            }

            @Override
            public void syncSkipped(@NotNull Project project) {
                if (project.getUserData(GradleSyncExecutor.ALWAYS_SKIP_SYNC) == null) {
                    AndroidNotification.getInstance(project).showProgressBalloon("Cannot change the current build variant at this moment", MessageType.ERROR);
                }
                AndroidGradleProjectResolver.clearVariantsSavedForReuse(project);
            }
        };
    }

    private static void requestGradleSync(@NotNull Project project, @NotNull SwitchVariantRequest requestedVariantChange) {
        GradleSyncInvoker.Request request2 = new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_VARIANT_SELECTION_CHANGED_BY_USER, requestedVariantChange);
        GradleSyncInvoker.getInstance().requestProjectSync(project, request2, BuildVariantUpdater.getSyncListener());
    }

    private static void setupCachedVariant(final @NotNull Project project, final @NotNull DataNode<ProjectData> variantData) {
        Application application = ApplicationManager.getApplication();
        Task.Backgroundable task2 = new Task.Backgroundable(project, "Setting up Project", false){

            public void run(@NotNull ProgressIndicator indicator) {
                BuildVariantUpdater.getLog().info("Starting setup of cached variant");
                VariantSwitcher.switchVariant(project, (DataNode<ProjectData>)variantData);
                GradleSyncStateHolder.getInstance(project).syncSkipped(null);
                BuildVariantUpdater.getLog().info("Finished setup of cached variant");
            }
        };
        if (application.isUnitTestMode()) {
            task2.run((ProgressIndicator)new EmptyProgressIndicator());
        } else {
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, (ProgressIndicator)new BackgroundableProcessIndicator(task2));
        }
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(BuildVariantUpdater.class);
    }
}

