/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.conflict;

import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.model.VariantAbi;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.conflict.ConflictResolutionDialog;
import com.android.tools.idea.gradle.variant.view.BuildVariantUpdater;
import com.android.tools.idea.model.AndroidModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConflictResolution {
    private ConflictResolution() {
    }

    @Nullable
    public static boolean solveSelectionConflict(@NotNull Conflict conflict2) {
        NdkModuleModel ndkModel;
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)conflict2.getSource());
        if (facet2 == null || !AndroidModel.isRequired(facet2)) {
            return true;
        }
        GradleAndroidModel source = GradleAndroidModel.get(facet2);
        if (source == null) {
            return false;
        }
        String newVariant = ConflictResolution.resolveNewVariant(conflict2);
        if (StringUtil.isEmpty((String)newVariant)) {
            return false;
        }
        NdkFacet ndkFacet = NdkFacet.getInstance(conflict2.getSource());
        NdkModuleModel ndkModuleModel = ndkModel = ndkFacet == null ? null : ndkFacet.getNdkModuleModel();
        if (ndkModel != null) {
            VariantAbi newVariantAbi = ConflictResolution.resolveNewVariantAbi(ndkFacet, ndkModel, newVariant);
            if (newVariantAbi == null) {
                return false;
            }
            BuildVariantUpdater.getInstance(facet2.getModule().getProject()).updateSelectedVariantAndAbi(ndkFacet.getModule(), newVariantAbi.getVariant(), newVariantAbi.getAbi());
        } else {
            BuildVariantUpdater.getInstance(facet2.getModule().getProject()).updateSelectedBuildVariant(facet2.getModule(), newVariant);
        }
        return true;
    }

    @Nullable
    private static String resolveNewVariant(@NotNull Conflict conflict2) {
        Collection<String> variants = conflict2.getVariants();
        if (variants.size() == 1) {
            return (String)ContainerUtil.getFirstItem(variants);
        }
        ConflictResolutionDialog dialog2 = new ConflictResolutionDialog(conflict2);
        if (!dialog2.showAndGet()) {
            return null;
        }
        return dialog2.getSelectedVariant();
    }

    @Nullable
    private static VariantAbi resolveNewVariantAbi(@NotNull NdkFacet ndkFacet, @NotNull NdkModuleModel ndkModel, @NotNull String newVariant) {
        VariantAbi selectedVariantAbi = ndkFacet.getSelectedVariantAbi();
        if (selectedVariantAbi != null) {
            String userSelectedAbi = selectedVariantAbi.getAbi();
            VariantAbi newVariantAbi = new VariantAbi(newVariant, userSelectedAbi);
            if (ndkModel.getAllVariantAbis().contains(newVariantAbi)) {
                return newVariantAbi;
            }
        }
        return ndkModel.getAllVariantAbis().stream().filter(variantAbi -> variantAbi.getVariant().equals(newVariant)).findFirst().orElse(null);
    }
}

