/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.SdkConstants;
import com.android.ide.common.gradle.Version;
import com.android.ide.common.repository.AgpVersion;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.gradle.util.GradleLocalCache;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.utils.BuildScriptUtil;
import com.android.utils.SdkUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public final class GradleUtil {
    public static final ProjectSystemId GRADLE_SYSTEM_ID = GradleConstants.SYSTEM_ID;
    @NonNls
    public static final String BUILD_DIR_DEFAULT_NAME = "build";
    @NonNls
    public static final String GRADLEW_PROPERTIES_PATH = FileUtil.join((String[])new String[]{SdkConstants.FD_GRADLE_WRAPPER, "gradle-wrapper.properties"});
    private static final Logger LOG = Logger.getInstance(GradleUtil.class);
    private static final CharMatcher ILLEGAL_GRADLE_PATH_CHARS_MATCHER = CharMatcher.anyOf((CharSequence)"\\/");

    private GradleUtil() {
    }

    @NotNull
    public static List<String> getPathSegments(@NotNull String gradlePath) {
        return Splitter.on((String)":").omitEmptyStrings().splitToList((CharSequence)gradlePath);
    }

    @Nullable
    public static VirtualFile getGradleBuildFile(@NotNull Module module2) {
        GradleModuleModel moduleModel = GradleUtil.getGradleModuleModel(module2);
        if (moduleModel != null) {
            return moduleModel.getBuildFile();
        }
        File moduleRoot = AndroidRootUtil.findModuleRootFolderPath(module2);
        return moduleRoot != null ? GradleUtil.getGradleBuildFile(moduleRoot) : null;
    }

    @Nullable
    public static File getGradleBuildFilePath(@NotNull Module module2) {
        GradleModuleModel moduleModel = GradleUtil.getGradleModuleModel(module2);
        if (moduleModel != null) {
            return moduleModel.getBuildFilePath();
        }
        File moduleRoot = AndroidRootUtil.findModuleRootFolderPath(module2);
        return moduleRoot != null ? GradleUtil.getGradleBuildFilePath(moduleRoot) : null;
    }

    @Nullable
    public static VirtualFile findGradleBuildFile(@NotNull VirtualFile parentDir) {
        return GradleUtil.findFileWithNames(parentDir, "build.gradle", "build.gradle.kts");
    }

    @Nullable
    public static VirtualFile findGradleSettingsFile(@NotNull VirtualFile parentDir) {
        return GradleUtil.findFileWithNames(parentDir, "settings.gradle", "settings.gradle.kts");
    }

    @Nullable
    private static VirtualFile findFileWithNames(@NotNull VirtualFile parentDir, String ... names) {
        for (String name2 : names) {
            VirtualFile file2 = parentDir.findChild(name2);
            if (file2 == null || file2.isDirectory()) continue;
            return file2;
        }
        return null;
    }

    @Nullable
    public static GradleModuleModel getGradleModuleModel(Module module2) {
        GradleFacet gradleFacet = GradleFacet.getInstance(module2);
        if (gradleFacet == null) {
            return null;
        }
        return gradleFacet.getGradleModuleModel();
    }

    @Nullable
    public static VirtualFile getGradleBuildFile(@NotNull File dirPath) {
        File gradleBuildFilePath = BuildScriptUtil.findGradleBuildFile((File)dirPath);
        VirtualFile result2 = VfsUtil.findFileByIoFile((File)gradleBuildFilePath, (boolean)false);
        return result2 != null && result2.isValid() ? result2 : null;
    }

    @Nullable
    public static File getGradleBuildFilePath(@NotNull File dirPath) {
        return BuildScriptUtil.findGradleBuildFile((File)dirPath);
    }

    @NotNull
    public static GradleExecutionSettings getOrCreateGradleExecutionSettings(@NotNull Project project) {
        GradleExecutionSettings executionSettings = GradleUtil.getGradleExecutionSettings(project);
        if (IdeInfo.getInstance().isAndroidStudio() && executionSettings == null) {
            File gradlePath = EmbeddedDistributionPaths.getInstance().findEmbeddedGradleDistributionPath();
            assert (gradlePath != null && gradlePath.isDirectory());
            executionSettings = new GradleExecutionSettings(gradlePath.getPath(), null, DistributionType.LOCAL, null, false);
        }
        if (executionSettings == null) {
            executionSettings = new GradleExecutionSettings(null, null, DistributionType.BUNDLED, null, false);
        }
        return executionSettings;
    }

    @Nullable
    public static GradleExecutionSettings getGradleExecutionSettings(@NotNull Project project) {
        GradleProjectSettings projectSettings = GradleUtil.getGradleProjectSettings(project);
        if (projectSettings == null) {
            File baseDirPath = Projects.getBaseDirPath((Project)project);
            String msg = String.format("Unable to obtain Gradle project settings for project '%1$s', located at '%2$s'", project.getName(), baseDirPath.getPath());
            LOG.info(msg);
            return null;
        }
        try {
            return (GradleExecutionSettings)ExternalSystemApiUtil.getExecutionSettings((Project)project, (String)projectSettings.getExternalProjectPath(), (ProjectSystemId)GRADLE_SYSTEM_ID);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Failed to obtain Gradle execution settings", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static GradleProjectSettings getGradleProjectSettings(@NotNull Project project) {
        return GradleProjectSettingsFinder.getInstance().findGradleProjectSettings(project);
    }

    public static void stopAllGradleDaemonsAndRestart() {
        DefaultGradleConnector.close();
        Application application = ApplicationManager.getApplication();
        if (application instanceof ApplicationImpl) {
            ((ApplicationImpl)application).restart(true);
        } else {
            application.restart();
        }
    }

    @NotNull
    public static String getDefaultPhysicalPathFromGradlePath(@NotNull String gradlePath) {
        List<String> segments = GradleUtil.getPathSegments(gradlePath);
        return FileUtil.join((String[])ArrayUtil.toStringArray(segments));
    }

    public static boolean isDirectChild(String childPath, String parentPath) {
        List<String> childSegments = GradleUtil.getPathSegments(childPath);
        return !childSegments.isEmpty() && childSegments.subList(0, childSegments.size() - 1).equals(GradleUtil.getPathSegments(parentPath));
    }

    @NotNull
    public static Set<String> getAllParentModulesPaths(@NotNull String gradlePath) {
        ImmutableSet.Builder result2 = ImmutableSet.builder();
        String parentPath = GradleUtil.getParentModulePath(gradlePath);
        while (!parentPath.isEmpty()) {
            result2.add((Object)parentPath);
            parentPath = GradleUtil.getParentModulePath(parentPath);
        }
        return result2.build();
    }

    @NotNull
    public static String getParentModulePath(@NotNull String gradlePath) {
        int parentPathEnd = gradlePath.lastIndexOf(":");
        if (parentPathEnd <= 0) {
            return "";
        }
        return gradlePath.substring(0, parentPathEnd);
    }

    @NotNull
    public static File getModuleDefaultPath(@NotNull VirtualFile parentDir, @NotNull String gradlePath) {
        assert (!gradlePath.isEmpty());
        String relativePath = GradleUtil.getDefaultPhysicalPathFromGradlePath(gradlePath);
        return new File(VfsUtilCore.virtualToIoFile((VirtualFile)parentDir), relativePath);
    }

    public static int isValidGradlePath(@NotNull String gradlePath) {
        return ILLEGAL_GRADLE_PATH_CHARS_MATCHER.indexIn((CharSequence)gradlePath);
    }

    public static void attemptToUseEmbeddedGradle(@NotNull Project project) {
        GradleWrapper gradleWrapper;
        if (IdeInfo.getInstance().isAndroidStudio() && (gradleWrapper = GradleWrapper.find(project)) != null) {
            GradleProjectSettings gradleSettings;
            File embeddedGradlePath;
            String gradleVersion2 = null;
            try {
                Properties properties2 = gradleWrapper.getProperties();
                String url = properties2.getProperty("distributionUrl");
                gradleVersion2 = GradleUtil.getGradleWrapperVersionOnlyIfComingForGradleDotOrg(url);
            }
            catch (IOException e) {
                LOG.warn("Failed to read file " + gradleWrapper.getPropertiesFilePath().getPath());
            }
            if (gradleVersion2 != null && GradleUtil.isCompatibleWithEmbeddedGradleVersion(gradleVersion2) && !GradleLocalCache.getInstance().containsGradleWrapperVersion(gradleVersion2, project) && (embeddedGradlePath = EmbeddedDistributionPaths.getInstance().findEmbeddedGradleDistributionPath()) != null && (gradleSettings = GradleUtil.getGradleProjectSettings(project)) != null) {
                gradleSettings.setDistributionType(DistributionType.LOCAL);
                gradleSettings.setGradleHome(embeddedGradlePath.getPath());
            }
        }
    }

    @VisibleForTesting
    @Nullable
    static String getGradleWrapperVersionOnlyIfComingForGradleDotOrg(@Nullable String url) {
        String version2;
        String expectedPrefix;
        String protocol;
        int foundIndex;
        if (url != null && (foundIndex = url.indexOf("://")) != -1 && ((protocol = url.substring(0, foundIndex)).equals("http") || protocol.equals("https")) && url.startsWith(expectedPrefix = protocol + "://services.gradle.org/distributions/gradle-") && (foundIndex = url.indexOf(45, expectedPrefix.length())) != -1 && StringUtil.isNotEmpty((String)(version2 = url.substring(expectedPrefix.length(), foundIndex)))) {
            return version2;
        }
        return null;
    }

    private static boolean isCompatibleWithEmbeddedGradleVersion(@NotNull String gradleVersion2) {
        return gradleVersion2.equals("8.0");
    }

    public static boolean hasCause(@NotNull Throwable e, @NotNull Class<?> causeClass) {
        String causeClassName = causeClass.getName();
        for (Throwable ex = e; ex != null; ex = ex.getCause()) {
            if (!causeClassName.equals(ex.getClass().getName())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static File getUserGradlePropertiesFile(@NotNull Project project) {
        String gradleHomePath;
        GradleExecutionSettings settings = GradleUtil.getGradleExecutionSettings(project);
        if (settings != null && !Strings.isNullOrEmpty((String)(gradleHomePath = settings.getServiceDirectory()))) {
            return new File(gradleHomePath, "gradle.properties");
        }
        return GradleUtil.getUserGradlePropertiesFile();
    }

    @NotNull
    private static File getUserGradlePropertiesFile() {
        String gradleUserHome = System.getProperty("gradle.user.home");
        if (Strings.isNullOrEmpty((String)gradleUserHome)) {
            gradleUserHome = System.getenv("GRADLE_USER_HOME");
        }
        if (Strings.isNullOrEmpty((String)gradleUserHome)) {
            gradleUserHome = FileUtil.join((String[])new String[]{System.getProperty("user.home"), ".gradle"});
        }
        return new File(gradleUserHome, "gradle.properties");
    }

    @NotNull
    public static String mapConfigurationName(@NotNull String configuration, @Nullable AgpVersion pluginVersion, boolean preferApi) {
        return GradleUtil.mapConfigurationName(configuration, pluginVersion != null && !pluginVersion.isAtLeastIncludingPreviews(3, 0, 0), preferApi);
    }

    @NotNull
    public static String mapConfigurationName(@NotNull String configuration, @Nullable String pluginVersion, boolean preferApi) {
        AgpVersion agpVersion = AgpVersion.tryParse((String)Objects.requireNonNullElseGet(pluginVersion, LatestKnownPluginVersionProvider.INSTANCE::get));
        return GradleUtil.mapConfigurationName(configuration, agpVersion, preferApi);
    }

    @NotNull
    private static String mapConfigurationName(@NotNull String configuration, boolean useCompatibilityNames, boolean preferApi) {
        if (useCompatibilityNames) {
            return configuration;
        }
        configuration = GradleUtil.replaceSuffixWithCase(configuration, "compile", preferApi ? "api" : "implementation");
        configuration = GradleUtil.replaceSuffixWithCase(configuration, "provided", "compileOnly");
        configuration = GradleUtil.replaceSuffixWithCase(configuration, "apk", "runtimeOnly");
        return configuration;
    }

    private static String replaceSuffixWithCase(String s, String suffix, String newSuffix) {
        if (SdkUtils.endsWithIgnoreCase((String)s, (String)suffix)) {
            int suffixBegin = s.length() - suffix.length();
            if (Character.isUpperCase(s.charAt(suffixBegin))) {
                return s.substring(0, suffixBegin) + Character.toUpperCase(newSuffix.charAt(0)) + newSuffix.substring(1);
            }
            if (suffixBegin == 0) {
                return newSuffix;
            }
            return s.substring(0, suffixBegin) + suffix;
        }
        return s;
    }

    public static Set<String> projectBuildFilesTypes(@NotNull Project project) {
        HashSet<String> result2 = new HashSet<String>();
        GradleUtil.addBuildFileType(result2, GradleUtil.getGradleBuildFilePath(Projects.getBaseDirPath((Project)project)));
        ReadAction.run(() -> {
            for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
                GradleUtil.addBuildFileType(result2, GradleUtil.getGradleBuildFilePath(module2));
            }
        });
        return result2;
    }

    private static void addBuildFileType(@NotNull HashSet<String> result2, @Nullable File buildFile) {
        if (buildFile != null) {
            String buildFileName = buildFile.getName().toLowerCase(Locale.getDefault());
            if (buildFileName.endsWith(".gradle")) {
                result2.add(".gradle");
            } else if (buildFileName.endsWith(".kts")) {
                result2.add(".kts");
            }
        }
    }

    @Nullable
    public static String getLastKnownAndroidGradlePluginVersion(@NotNull Project project) {
        for (Module module2 : ProjectFacetManager.getInstance((Project)project).getModulesWithFacet(GradleFacet.getFacetTypeId())) {
            GradleFacet gradleFacet = GradleFacet.getInstance(module2);
            if (gradleFacet == null) continue;
            GradleFacetConfiguration configuration = (GradleFacetConfiguration)gradleFacet.getConfiguration();
            String version2 = configuration.LAST_KNOWN_AGP_VERSION;
            if (version2 == null) continue;
            return version2;
        }
        return null;
    }

    @Nullable
    public static String getLastSuccessfulAndroidGradlePluginVersion(@NotNull Project project) {
        for (Module module2 : ProjectFacetManager.getInstance((Project)project).getModulesWithFacet(GradleFacet.getFacetTypeId())) {
            GradleFacet gradleFacet = GradleFacet.getInstance(module2);
            if (gradleFacet == null) continue;
            GradleFacetConfiguration configuration = (GradleFacetConfiguration)gradleFacet.getConfiguration();
            String version2 = configuration.LAST_SUCCESSFUL_SYNC_AGP_VERSION;
            if (version2 == null) continue;
            return version2;
        }
        return null;
    }

    @NotNull
    public static String getDependencyDisplayName(@NotNull String artifactAddress) {
        GradleCoordinate coordinates = GradleCoordinate.parseCoordinateString((String)artifactAddress);
        if (coordinates != null) {
            Version version2;
            int index2;
            String groupId;
            String groupSuffix;
            Object name2 = coordinates.getArtifactId();
            if (!((String)name2).contains("-") && !(groupSuffix = (groupId = coordinates.getGroupId()).substring((index2 = groupId.lastIndexOf(46)) + 1)).equals(name2)) {
                name2 = groupSuffix + ":" + (String)name2;
            }
            if ((version2 = coordinates.getLowerBoundVersion()) != null && !"unspecified".equals(version2.toString())) {
                name2 = (String)name2 + ":" + version2;
            }
            return name2;
        }
        return StringUtil.trimLeading((String)artifactAddress, (char)':');
    }
}

