/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.model.IdeAndroidProject;
import com.android.tools.idea.gradle.model.IdeAndroidProjectType;
import com.android.tools.idea.gradle.model.IdeBaseArtifactCore;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.gradle.configuration.KotlinGradleSourceSetData;

public class GradleProjectSystemUtil {
    public static boolean isAaptGeneratedSourcesFolder(@NotNull File folder, @NotNull File buildFolder) {
        File generatedFolder = new File(buildFolder, "generated");
        File generatedSourceR = FileUtils.join((File)generatedFolder, (String[])new String[]{"source", "r"});
        File rClassSources = new File(generatedFolder, "not_namespaced_r_class_sources");
        return FileUtil.isAncestor((File)generatedSourceR, (File)folder, (boolean)false) || FileUtil.isAncestor((File)rClassSources, (File)folder, (boolean)false);
    }

    @VisibleForTesting
    public static boolean isDataBindingGeneratedBaseClassesFolder(@NotNull File folder, @NotNull File buildFolder) {
        File generatedFolder = new File(buildFolder, "generated");
        File dataBindingSources = new File(generatedFolder, "data_binding_base_class_source_out");
        return FileUtil.isAncestor((File)dataBindingSources, (File)folder, (boolean)false);
    }

    public static boolean isSafeArgGeneratedSourcesFolder(@NotNull File folder, @NotNull File buildFolder) {
        if (!((Boolean)StudioFlags.NAV_SAFE_ARGS_SUPPORT.get()).booleanValue()) {
            return false;
        }
        File generatedFolder = new File(buildFolder, "generated");
        File safeArgClassSources = FileUtils.join((File)generatedFolder, (String[])new String[]{"source", "navigation-args"});
        return FileUtil.isAncestor((File)safeArgClassSources, (File)folder, (boolean)false);
    }

    public static Collection<File> getGeneratedSourceFoldersToUse(@NotNull IdeBaseArtifactCore artifact, @NotNull IdeAndroidProject androidProject) {
        File buildFolder = androidProject.getBuildFolder();
        return artifact.getGeneratedSourceFolders().stream().filter(folder -> !GradleProjectSystemUtil.isAaptGeneratedSourcesFolder(folder, buildFolder)).filter(folder -> !GradleProjectSystemUtil.isDataBindingGeneratedBaseClassesFolder(folder, buildFolder)).filter(folder -> !GradleProjectSystemUtil.isSafeArgGeneratedSourcesFolder(folder, buildFolder)).collect(Collectors.toList());
    }

    @NotNull
    public static String createFullTaskName(@NotNull String gradleProjectPath, @NotNull String taskName) {
        if (gradleProjectPath.endsWith(":")) {
            return gradleProjectPath + taskName;
        }
        return gradleProjectPath + ":" + taskName;
    }

    public static boolean useCompatibilityConfigurationNames(@NotNull Project project) {
        return GradleProjectSystemUtil.useCompatibilityConfigurationNames(GradleProjectSystemUtil.getAndroidGradleModelVersionInUse(project));
    }

    public static boolean useCompatibilityConfigurationNames(@Nullable AgpVersion agpVersion) {
        return agpVersion != null && agpVersion.getMajor() < 3;
    }

    @Nullable
    public static String getKotlinVersionInUse(@NotNull Project project, @NotNull String gradleProjectPath) {
        DataNode projectData = ExternalSystemApiUtil.findProjectNode((Project)project, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (String)gradleProjectPath);
        if (projectData == null) {
            return null;
        }
        String[] kotlinVersion = new String[]{null};
        boolean[] foundVersion = new boolean[]{false};
        projectData.visit(node -> {
            KotlinGradleSourceSetData data;
            String kotlinPluginVersion;
            if (node.getKey().equals((Object)KotlinGradleSourceSetData.Companion.getKEY()) && (kotlinPluginVersion = (data = (KotlinGradleSourceSetData)node.getData()).getKotlinPluginVersion()) != null) {
                if (!foundVersion[0]) {
                    kotlinVersion[0] = data.getKotlinPluginVersion();
                    foundVersion[0] = true;
                } else if (!kotlinPluginVersion.equals(kotlinVersion[0])) {
                    kotlinVersion[0] = null;
                }
            }
        });
        return kotlinVersion[0];
    }

    @Nullable
    public static AgpVersion getAndroidGradleModelVersionInUse(@NotNull Project project) {
        HashSet foundInLibraries = Sets.newHashSet();
        HashSet foundInApps = Sets.newHashSet();
        for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
            GradleAndroidModel androidModel = GradleAndroidModel.get(module2);
            if (androidModel == null) continue;
            IdeAndroidProject androidProject = androidModel.getAndroidProject();
            String modelVersion = androidProject.getAgpVersion();
            if (androidModel.getAndroidProject().getProjectType() == IdeAndroidProjectType.PROJECT_TYPE_APP) {
                foundInApps.add(modelVersion);
                continue;
            }
            foundInLibraries.add(modelVersion);
        }
        String found = null;
        if (foundInApps.size() == 1) {
            found = (String)Iterables.getOnlyElement((Iterable)foundInApps);
        } else if (foundInApps.isEmpty() && foundInLibraries.size() == 1) {
            found = (String)Iterables.getOnlyElement((Iterable)foundInLibraries);
        }
        return found != null ? AgpVersion.tryParse((String)found) : null;
    }

    @Nullable
    public static AgpVersion getAndroidGradleModelVersionInUse(@NotNull Module module2) {
        GradleAndroidModel androidModel = GradleAndroidModel.get(module2);
        if (androidModel != null) {
            IdeAndroidProject androidProject = androidModel.getAndroidProject();
            return AgpVersion.tryParse((String)androidProject.getAgpVersion());
        }
        return null;
    }

    @NotNull
    public static List<Module> getModulesToBuild(@NotNull Module module2) {
        return Stream.concat(Stream.of(module2), ProjectSystemUtil.getModuleSystem(module2).getDynamicFeatureModules().stream()).collect(Collectors.toList());
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(GradleProjectSystemUtil.class);
    }

    @Nullable
    public static GradleAndroidModel findAndroidModelInModule(@NotNull Project project, @NotNull VirtualFile file2, boolean honorExclusion) {
        Module module2 = ProjectFileIndex.getInstance((Project)project).getModuleForFile(file2, honorExclusion);
        if (module2 == null) {
            return null;
        }
        if (module2.isDisposed()) {
            GradleProjectSystemUtil.getLogger().warn("Attempted to get an Android Facet from a disposed module");
            return null;
        }
        return GradleAndroidModel.get(module2);
    }

    @Nullable
    public static GradleAndroidModel findAndroidModelInModule(@NotNull Project project, @NotNull VirtualFile file2) {
        return GradleProjectSystemUtil.findAndroidModelInModule(project, file2, true);
    }

    @NotNull
    public static List<Module> getAppHolderModulesSupportingBundleTask(@NotNull Project project) {
        return ProjectStructure.getInstance(project).getAppHolderModules().stream().filter(GradleProjectSystemUtil::supportsBundleTask).collect(Collectors.toList());
    }

    public static boolean supportsBundleTask(@NotNull Module module2) {
        GradleAndroidModel androidModule = GradleAndroidModel.get(module2);
        if (androidModule == null) {
            return false;
        }
        return !StringUtil.isEmpty((String)androidModule.getSelectedVariant().getMainArtifact().getBuildInformation().getBundleTaskName());
    }
}

