/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.IdeInfo;
import com.google.common.collect.Lists;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTrackerSettings;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager;
import org.jetbrains.kotlin.idea.core.script.settings.KotlinScriptingSettings;

public final class AndroidStudioPreferences {
    private static final List<String> PROJECT_PREFERENCES_TO_REMOVE = Lists.newArrayList((Object[])new String[]{"org.intellij.lang.xpath.xslt.associations.impl.FileAssociationsConfigurable", "com.intellij.uiDesigner.GuiDesignerConfigurable", "org.jetbrains.plugins.groovy.gant.GantConfigurable", "org.jetbrains.plugins.groovy.compiler.GroovyCompilerConfigurable", "org.jetbrains.idea.maven.utils.MavenSettings", "com.intellij.compiler.options.CompilerConfigurable", "org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerConfigurableTab"});

    public static void cleanUpPreferences(@NotNull Project project) {
        if (!IdeInfo.getInstance().isAndroidStudio()) {
            return;
        }
        CompilerWorkspaceConfiguration.getInstance((Project)project).MAKE_PROJECT_ON_SAVE = false;
        ExtensionPoint projectConfigurable = Configurable.PROJECT_CONFIGURABLE.getPoint((AreaInstance)project);
        ExternalSystemProjectTrackerSettings.getInstance((Project)project).setAutoReloadType(ExternalSystemProjectTrackerSettings.AutoReloadType.NONE);
        ScriptDefinitionsManager.Companion.getInstance(project).getAllDefinitions().forEach(scriptDefinition -> {
            KotlinScriptingSettings settings = KotlinScriptingSettings.Companion.getInstance(project);
            if (settings.isScriptDefinitionEnabled(scriptDefinition) && settings.autoReloadConfigurations(scriptDefinition)) {
                settings.setAutoReloadConfigurations(scriptDefinition, false);
            }
        });
        ArrayList<ConfigurableEP> nonStudioExtensions = new ArrayList<ConfigurableEP>();
        for (ConfigurableEP extension : projectConfigurable.getExtensionList()) {
            if (!PROJECT_PREFERENCES_TO_REMOVE.contains(extension.instanceClass)) continue;
            nonStudioExtensions.add(extension);
        }
        projectConfigurable.unregisterExtensions((s, adapter2) -> !nonStudioExtensions.contains(adapter2.createInstance((ComponentManager)project)), false);
    }
}

