/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.dependencies.android;

import com.android.tools.idea.gradle.structure.configurables.ui.PsCheckBoxList;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeEventDispatcher;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeListener;
import com.android.tools.idea.gradle.structure.model.android.PsProductFlavor;
import com.intellij.openapi.Disposable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProductFlavorsPanel
extends JPanel {
    @NotNull
    private final PsCheckBoxList<PsProductFlavor> myProductFlavorsList;
    @NotNull
    private final SelectionChangeEventDispatcher<List<PsProductFlavor>> myEventDispatcher = new SelectionChangeEventDispatcher();

    ProductFlavorsPanel(@NotNull List<PsProductFlavor> productFlavors) {
        super(new BorderLayout());
        this.myProductFlavorsList = new PsCheckBoxList<PsProductFlavor>(productFlavors);
        this.myProductFlavorsList.setSelectionChangeListener(this.myEventDispatcher::selectionChanged);
        this.myProductFlavorsList.setItemsSelected(true);
        new ListSpeedSearch(this.myProductFlavorsList);
        JScrollPane scrollPane2 = ScrollPaneFactory.createScrollPane(this.myProductFlavorsList);
        scrollPane2.setBorder(IdeBorderFactory.createBorder((int)12));
        this.add((Component)scrollPane2, "Center");
    }

    @NotNull
    List<PsProductFlavor> getSelectedProductFlavors() {
        return this.myProductFlavorsList.getSelectedItems();
    }

    void add(@NotNull SelectionChangeListener<List<PsProductFlavor>> listener2, @NotNull Disposable parentDisposable) {
        this.myEventDispatcher.addListener(listener2, parentDisposable);
    }

    @Nullable
    JComponent getPreferredFocusedComponent() {
        return this.myProductFlavorsList;
    }
}

