/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon;

import com.android.annotations.concurrency.UiThread;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u0018J!\u0010\u0019\u001a\u00020\u00182\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u001b\"\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\u0018J!\u0010\u001d\u001a\u00020\u00182\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u001b\"\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u00058G\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00058DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0006R\u0012\u0010\b\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0001X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsDaemon;", "Lcom/intellij/openapi/Disposable;", "parentDisposable", "(Lcom/intellij/openapi/Disposable;)V", "isRunning", "", "()Z", "isStopped", "mainQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "getMainQueue", "()Lcom/intellij/util/ui/update/MergingUpdateQueue;", "getParentDisposable", "()Lcom/intellij/openapi/Disposable;", "resultsUpdaterQueue", "getResultsUpdaterQueue", "stopped", "Ljava/util/concurrent/atomic/AtomicBoolean;", "createQueue", "name", "", "modalityStateComponent", "Ljavax/swing/JComponent;", "dispose", "", "reset", "queues", "", "([Lcom/intellij/util/ui/update/MergingUpdateQueue;)V", "stop", "intellij.android.projectSystem.gradle.psd"})
public abstract class PsDaemon
implements Disposable {
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final AtomicBoolean stopped;

    protected PsDaemon(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.parentDisposable = parentDisposable;
        this.stopped = new AtomicBoolean(false);
        Disposer.register((Disposable)this.parentDisposable, (Disposable)this);
    }

    @NotNull
    protected final Disposable getParentDisposable() {
        return this.parentDisposable;
    }

    @NotNull
    protected abstract MergingUpdateQueue getMainQueue();

    @NotNull
    protected abstract MergingUpdateQueue getResultsUpdaterQueue();

    protected final boolean isStopped() {
        return this.stopped.get();
    }

    @UiThread
    public final boolean isRunning() {
        return !this.getMainQueue().isEmpty() || this.getMainQueue().isFlushing() || !this.getResultsUpdaterQueue().isEmpty();
    }

    @NotNull
    protected final MergingUpdateQueue createQueue(@NotNull String name2, @Nullable JComponent modalityStateComponent) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return new MergingUpdateQueue(name2, 300, false, modalityStateComponent, (Disposable)this, null, modalityStateComponent != null ? Alarm.ThreadToUse.SWING_THREAD : Alarm.ThreadToUse.POOLED_THREAD);
    }

    public final void reset() {
        MergingUpdateQueue[] mergingUpdateQueueArray = new MergingUpdateQueue[]{this.getMainQueue(), this.getResultsUpdaterQueue()};
        this.reset(mergingUpdateQueueArray);
        this.getMainQueue().queue(new Update(this){
            final /* synthetic */ PsDaemon this$0;
            {
                this.this$0 = $receiver;
                super((Object)"reset");
            }

            public void run() {
                PsDaemon.access$getStopped$p(this.this$0).set(false);
            }
        });
    }

    private final void reset(MergingUpdateQueue ... queues) {
        for (MergingUpdateQueue queue : queues) {
            queue.activate();
        }
    }

    public final void stop() {
        this.stopped.set(true);
        MergingUpdateQueue[] mergingUpdateQueueArray = new MergingUpdateQueue[]{this.getMainQueue(), this.getResultsUpdaterQueue()};
        this.stop(mergingUpdateQueueArray);
    }

    private final void stop(MergingUpdateQueue ... queues) {
        for (MergingUpdateQueue queue : queues) {
            queue.cancelAllUpdates();
            queue.deactivate();
        }
    }

    public void dispose() {
        this.stop();
    }

    public static final /* synthetic */ AtomicBoolean access$getStopped$p(PsDaemon $this) {
        return $this.stopped;
    }
}

