/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.UiThread;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.structure.daemon.AvailableLibraryUpdateStorage;
import com.android.tools.idea.gradle.structure.daemon.PsAnalyzerDaemonKt;
import com.android.tools.idea.gradle.structure.daemon.PsDaemon;
import com.android.tools.idea.gradle.structure.daemon.PsLibraryUpdateCheckerDaemon;
import com.android.tools.idea.gradle.structure.daemon.PsSdkIndexCheckerDaemon;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsModelAnalyzer;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsDeclaredLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsGeneralIssue;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueCollection;
import com.android.tools.idea.gradle.structure.model.PsIssueType;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.android.tools.idea.gradle.structure.model.meta.DslText;
import com.android.tools.idea.gradle.structure.model.meta.ModelPropertyCore;
import com.android.tools.idea.gradle.structure.model.meta.ParsedValue;
import com.android.tools.idea.gradle.structure.navigation.PsLibraryDependencyNavigationPath;
import com.android.tools.idea.gradle.structure.quickfix.PsLibraryDependencyVersionQuickFixPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003?@ABE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u001e\u0010\n\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r0\u000b\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020)H\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-H\u0003J\b\u0010.\u001a\u00020!H\u0003J\u0010\u0010/\u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0003J\u001e\u00100\u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u00032\u000e\b\u0001\u00101\u001a\b\u0012\u0004\u0012\u00020!02J\u001e\u00103\u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u00032\u000e\b\u0001\u00101\u001a\b\u0012\u0004\u0012\u00020!02J\u0010\u00104\u001a\u00020!2\u0006\u0010(\u001a\u00020\u000eH\u0007J\b\u00105\u001a\u00020!H\u0007J\b\u00106\u001a\u00020!H\u0003J\b\u00107\u001a\u00020!H\u0003J$\u00108\u001a\u00020!2\u0006\u00109\u001a\u00020:2\n\b\u0002\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010%\u001a\u00020&H\u0002J\u0014\u0010=\u001a\b\u0012\u0004\u0012\u00020$0>2\u0006\u0010(\u001a\u00020)R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R!\u0010\u0014\u001a\u0015\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u0015\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001aX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR&\u0010\n\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u001d\u001a\u0015\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u0015\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u001aX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001cR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon;", "Lcom/android/tools/idea/gradle/structure/daemon/PsDaemon;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/android/tools/idea/gradle/structure/model/PsProject;", "libraryUpdateCheckerDaemon", "Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon;", "sdkIndexCheckerDaemon", "Lcom/android/tools/idea/gradle/structure/daemon/PsSdkIndexCheckerDaemon;", "modelAnalyzers", "", "Ljava/lang/Class;", "Lcom/android/tools/idea/gradle/structure/daemon/analysis/PsModelAnalyzer;", "Lcom/android/tools/idea/gradle/structure/model/PsModule;", "(Lcom/intellij/openapi/Disposable;Lcom/android/tools/idea/gradle/structure/model/PsProject;Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon;Lcom/android/tools/idea/gradle/structure/daemon/PsSdkIndexCheckerDaemon;Ljava/util/Map;)V", "issues", "Lcom/android/tools/idea/gradle/structure/model/PsIssueCollection;", "getIssues", "()Lcom/android/tools/idea/gradle/structure/model/PsIssueCollection;", "issuesUpdatedEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon$IssuesUpdatedListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "mainQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "getMainQueue", "()Lcom/intellij/util/ui/update/MergingUpdateQueue;", "onRunningEventDispatcher", "resultsUpdaterQueue", "getResultsUpdaterQueue", "addAll", "", "newIssues", "", "Lcom/android/tools/idea/gradle/structure/model/PsIssue;", "now", "", "doAnalyzeStructure", "model", "Lcom/android/tools/idea/gradle/structure/model/PsModel;", "getAvailableUpdatesFor", "Lcom/android/tools/idea/gradle/structure/model/PsGeneralIssue;", "dependency", "Lcom/android/tools/idea/gradle/structure/model/PsDeclaredLibraryDependency;", "notifyRunning", "notifyUpdated", "onIssuesChange", "listener", "Lkotlin/Function0;", "onRunningChange", "queueCheck", "recreateIssues", "recreateSdkIndexIssues", "recreateUpdatesAsIssues", "removeIssues", "type", "Lcom/android/tools/idea/gradle/structure/model/PsIssueType;", "byPath", "Lcom/android/tools/idea/gradle/structure/model/PsPath;", "validate", "Lkotlin/sequences/Sequence;", "AnalyzeModuleStructure", "IssuesComputed", "IssuesUpdatedListener", "intellij.android.projectSystem.gradle.psd"})
@SourceDebugExtension(value={"SMAP\nPsAnalyzerDaemon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsAnalyzerDaemon.kt\ncom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,308:1\n1360#2:309\n1446#2,2:310\n1603#2,9:312\n1851#2:321\n1852#2:323\n1612#2:324\n1448#2,3:325\n1851#2,2:328\n1360#2:330\n1446#2,2:331\n1603#2,9:333\n1851#2:342\n1852#2:344\n1612#2:345\n1448#2,3:346\n1#3:322\n1#3:343\n*S KotlinDebug\n*F\n+ 1 PsAnalyzerDaemon.kt\ncom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon\n*L\n87#1:309\n87#1:310,2\n87#1:312,9\n87#1:321\n87#1:323\n87#1:324\n87#1:325,3\n171#1:328,2\n221#1:330\n221#1:331,2\n222#1:333,9\n222#1:342\n222#1:344\n222#1:345\n221#1:346,3\n87#1:322\n222#1:343\n*E\n"})
public final class PsAnalyzerDaemon
extends PsDaemon {
    @NotNull
    private final PsProject project;
    @NotNull
    private final PsLibraryUpdateCheckerDaemon libraryUpdateCheckerDaemon;
    @NotNull
    private final PsSdkIndexCheckerDaemon sdkIndexCheckerDaemon;
    @NotNull
    private final Map<Class<?>, PsModelAnalyzer<? extends PsModule>> modelAnalyzers;
    @NotNull
    private final MergingUpdateQueue mainQueue;
    @NotNull
    private final MergingUpdateQueue resultsUpdaterQueue;
    @NotNull
    private final PsIssueCollection issues;
    @NotNull
    private final EventDispatcher<IssuesUpdatedListener> onRunningEventDispatcher;
    @NotNull
    private final EventDispatcher<IssuesUpdatedListener> issuesUpdatedEventDispatcher;

    public PsAnalyzerDaemon(@NotNull Disposable parentDisposable, @NotNull PsProject project, @NotNull PsLibraryUpdateCheckerDaemon libraryUpdateCheckerDaemon, @NotNull PsSdkIndexCheckerDaemon sdkIndexCheckerDaemon, @NotNull Map<Class<?>, ? extends PsModelAnalyzer<? extends PsModule>> modelAnalyzers) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)libraryUpdateCheckerDaemon, (String)"libraryUpdateCheckerDaemon");
        Intrinsics.checkNotNullParameter((Object)sdkIndexCheckerDaemon, (String)"sdkIndexCheckerDaemon");
        Intrinsics.checkNotNullParameter(modelAnalyzers, (String)"modelAnalyzers");
        super(parentDisposable);
        this.project = project;
        this.libraryUpdateCheckerDaemon = libraryUpdateCheckerDaemon;
        this.sdkIndexCheckerDaemon = sdkIndexCheckerDaemon;
        this.modelAnalyzers = modelAnalyzers;
        this.mainQueue = this.createQueue("Project Structure Daemon Analyzer", null);
        this.resultsUpdaterQueue = this.createQueue("Project Structure Analysis Results Updater", MergingUpdateQueue.ANY_COMPONENT);
        this.issues = new PsIssueCollection();
        EventDispatcher eventDispatcher = EventDispatcher.create(IssuesUpdatedListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(IssuesUpdatedListener::class.java)");
        this.onRunningEventDispatcher = eventDispatcher;
        EventDispatcher eventDispatcher2 = EventDispatcher.create(IssuesUpdatedListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher2, (String)"create(IssuesUpdatedListener::class.java)");
        this.issuesUpdatedEventDispatcher = eventDispatcher2;
        this.libraryUpdateCheckerDaemon.add((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.recreateUpdatesAsIssues();
            }
        }), this);
        this.sdkIndexCheckerDaemon.add((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.recreateSdkIndexIssues();
            }
        }), this);
    }

    @Override
    @NotNull
    protected MergingUpdateQueue getMainQueue() {
        return this.mainQueue;
    }

    @Override
    @NotNull
    protected MergingUpdateQueue getResultsUpdaterQueue() {
        return this.resultsUpdaterQueue;
    }

    @NotNull
    public final PsIssueCollection getIssues() {
        return this.issues;
    }

    @UiThread
    public final void recreateIssues() {
        this.libraryUpdateCheckerDaemon.queueUpdateCheck();
        this.sdkIndexCheckerDaemon.queueCheck();
    }

    /*
     * WARNING - void declaration
     */
    @UiThread
    private final void recreateUpdatesAsIssues() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        PsIssueType psIssueType = PsIssueType.LIBRARY_UPDATES_AVAILABLE;
        Intrinsics.checkNotNullExpressionValue((Object)psIssueType, (String)"LIBRARY_UPDATES_AVAILABLE");
        PsAnalyzerDaemon.removeIssues$default(this, psIssueType, null, true, 2, null);
        Iterable iterable = this.project.getModules();
        PsAnalyzerDaemon psAnalyzerDaemon = this;
        boolean $i$f$flatMap = false;
        void var3_4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            PsModule module2 = (PsModule)element$iv$iv;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = module2.getDependencies().getLibraries();
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                PsGeneralIssue it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                PsDeclaredLibraryDependency it = (PsDeclaredLibraryDependency)element$iv$iv2;
                boolean bl3 = false;
                if (this.getAvailableUpdatesFor(it) == null) continue;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        psAnalyzerDaemon.addAll((List)destination$iv$iv, false);
        this.notifyRunning();
    }

    @UiThread
    private final PsGeneralIssue getAvailableUpdatesFor(PsDeclaredLibraryDependency dependency) {
        List list2;
        AvailableLibraryUpdateStorage results2 = this.libraryUpdateCheckerDaemon.getAvailableLibraryUpdateStorage();
        PsArtifactDependencySpec spec = dependency.getSpec();
        GradleVersion gradleVersion2 = results2.findUpdatedVersionFor(spec);
        if (gradleVersion2 == null) {
            return null;
        }
        GradleVersion versionToUpdateTo = gradleVersion2;
        String text2 = "Newer version available: <b>" + versionToUpdateTo + "<b>";
        PsLibraryDependencyNavigationPath mainPath = dependency.getPath();
        ParsedValue versionValue = ((ModelPropertyCore)dependency.getVersionProperty().bind(Unit.INSTANCE)).getParsedValue().getValue();
        boolean valueIsReference = versionValue instanceof ParsedValue.Set.Parsed && ((ParsedValue.Set.Parsed)versionValue).getDslText() instanceof DslText.Reference;
        PsPath psPath = mainPath;
        PsIssueType psIssueType = PsIssueType.LIBRARY_UPDATES_AVAILABLE;
        Intrinsics.checkNotNullExpressionValue((Object)psIssueType, (String)"LIBRARY_UPDATES_AVAILABLE");
        if (!valueIsReference) {
            PsLibraryDependency psLibraryDependency = dependency;
            String string = versionToUpdateTo.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"versionToUpdateTo.toString()");
            list2 = CollectionsKt.listOf((Object)new PsLibraryDependencyVersionQuickFixPath(psLibraryDependency, string, null, 4, null));
        } else {
            Object[] objectArray = new PsLibraryDependencyVersionQuickFixPath[2];
            PsLibraryDependency psLibraryDependency = dependency;
            String string = versionToUpdateTo.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"versionToUpdateTo.toString()");
            objectArray[0] = new PsLibraryDependencyVersionQuickFixPath(psLibraryDependency, string, true);
            PsLibraryDependency psLibraryDependency2 = dependency;
            String string2 = versionToUpdateTo.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"versionToUpdateTo.toString()");
            objectArray[1] = new PsLibraryDependencyVersionQuickFixPath(psLibraryDependency2, string2, false);
            list2 = CollectionsKt.listOf((Object[])objectArray);
        }
        return new PsGeneralIssue(text2, "", psPath, psIssueType, PsIssue.Severity.UPDATE, list2);
    }

    public final void onIssuesChange(@NotNull Disposable parentDisposable, @UiThread @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.issuesUpdatedEventDispatcher.addListener((EventListener)new IssuesUpdatedListener(listener2){
            final /* synthetic */ Function0<Unit> $listener;
            {
                this.$listener = $listener;
            }

            public void issuesUpdated() {
                this.$listener.invoke();
            }
        }, parentDisposable);
    }

    public final void onRunningChange(@NotNull Disposable parentDisposable, @UiThread @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.onRunningEventDispatcher.addListener((EventListener)new IssuesUpdatedListener(listener2){
            final /* synthetic */ Function0<Unit> $listener;
            {
                this.$listener = $listener;
            }

            public void issuesUpdated() {
                this.$listener.invoke();
            }
        }, parentDisposable);
    }

    @UiThread
    public final void queueCheck(@NotNull PsModule model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        PsIssueType psIssueType = PsIssueType.PROJECT_ANALYSIS;
        Intrinsics.checkNotNullExpressionValue((Object)psIssueType, (String)"PROJECT_ANALYSIS");
        this.removeIssues(psIssueType, model2.getPath(), false);
        this.getMainQueue().queue((Update)new AnalyzeModuleStructure(model2));
        this.notifyRunning();
    }

    @NotNull
    public final Sequence<PsIssue> validate(@NotNull PsModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Sequence sequence = this.modelAnalyzers.get(model2.getClass());
        Sequence sequence2 = sequence instanceof PsModelAnalyzer ? sequence : null;
        if (sequence2 == null || (sequence2 = sequence2.analyze((PsModule)model2)) == null) {
            sequence2 = SequencesKt.sequenceOf((Object[])new PsIssue[0]);
        }
        return sequence2;
    }

    private final void doAnalyzeStructure(PsModel model2) {
        PsModelAnalyzer<PsModel> analyzer;
        PsModelAnalyzer<PsModel> psModelAnalyzer = this.modelAnalyzers.get(model2.getClass());
        PsModelAnalyzer<PsModel> psModelAnalyzer2 = analyzer = psModelAnalyzer instanceof PsModelAnalyzer ? psModelAnalyzer : null;
        if (analyzer == null) {
            PsAnalyzerDaemonKt.access$getLOG$p().info("Failed to find analyzer for model of type " + model2.getClass().getName());
            return;
        }
        if (!this.isStopped()) {
            boolean bl = analyzer.getSupportedModelType().isInstance(model2);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.any(), (Function0)((Function0)new Function0<Unit>(this, analyzer, model2){
                final /* synthetic */ PsAnalyzerDaemon this$0;
                final /* synthetic */ PsModelAnalyzer<PsModel> $analyzer;
                final /* synthetic */ PsModel $model;
                {
                    this.this$0 = $receiver;
                    this.$analyzer = $analyzer;
                    this.$model = $model;
                    super(0);
                }

                public final void invoke() {
                    List list2;
                    if (!this.this$0.isStopped() && !this.$analyzer.getDisposed()) {
                        PsModel psModel = this.$analyzer.getSupportedModelType().cast(this.$model);
                        Intrinsics.checkNotNullExpressionValue((Object)psModel, (String)"analyzer.supportedModelType.cast(model)");
                        list2 = SequencesKt.toList(this.$analyzer.analyze(psModel));
                    } else {
                        list2 = CollectionsKt.emptyList();
                    }
                    List newIssues = list2;
                    this.this$0.addAll(newIssues, false);
                }
            }));
        }
        this.getResultsUpdaterQueue().queue((Update)new IssuesComputed());
    }

    private final void removeIssues(PsIssueType type, PsPath byPath, boolean now) {
        this.issues.remove(type, byPath);
        this.notifyUpdated(now);
    }

    static /* synthetic */ void removeIssues$default(PsAnalyzerDaemon psAnalyzerDaemon, PsIssueType psIssueType, PsPath psPath, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            psPath = null;
        }
        psAnalyzerDaemon.removeIssues(psIssueType, psPath, bl);
    }

    /*
     * WARNING - void declaration
     */
    @UiThread
    public final void addAll(@NotNull List<? extends PsIssue> newIssues, boolean now) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter(newIssues, (String)"newIssues");
        Iterable iterable = newIssues;
        PsIssueCollection psIssueCollection = this.issues;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsIssue p0 = (PsIssue)element$iv;
            boolean bl = false;
            psIssueCollection.add(p0);
        }
        this.notifyUpdated(now);
    }

    @AnyThread
    private final void notifyUpdated(boolean now) {
        if (now) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            ((IssuesUpdatedListener)this.issuesUpdatedEventDispatcher.getMulticaster()).issuesUpdated();
        } else {
            this.getResultsUpdaterQueue().queue((Update)new IssuesComputed());
        }
    }

    @UiThread
    private final void notifyRunning() {
        ((IssuesUpdatedListener)this.onRunningEventDispatcher.getMulticaster()).issuesUpdated();
    }

    /*
     * WARNING - void declaration
     */
    @UiThread
    private final void recreateSdkIndexIssues() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        PsIssueType psIssueType = PsIssueType.PLAY_SDK_INDEX_ISSUE;
        Intrinsics.checkNotNullExpressionValue((Object)psIssueType, (String)"PLAY_SDK_INDEX_ISSUE");
        PsAnalyzerDaemon.removeIssues$default(this, psIssueType, null, true, 2, null);
        int numErrors = 0;
        int numWarnings = 0;
        int numInfo = 0;
        int numUpdates = 0;
        int numOther = 0;
        Iterable iterable = this.project.getModules();
        PsAnalyzerDaemon psAnalyzerDaemon = this;
        boolean $i$f$flatMap = false;
        void var8_9 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            PsModule module2 = (PsModule)element$iv$iv;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = module2.getDependencies().getLibraries();
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                PsGeneralIssue psGeneralIssue;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                PsDeclaredLibraryDependency it = (PsDeclaredLibraryDependency)element$iv$iv2;
                boolean bl3 = false;
                if (PsAnalyzerDaemonKt.getSdkIndexIssueFor(it.getSpec(), it.getPath(), it.getParent().getRootDir()) != null) {
                    PsGeneralIssue psGeneralIssue2;
                    PsGeneralIssue issue2 = psGeneralIssue2;
                    boolean bl4 = false;
                    switch (WhenMappings.$EnumSwitchMapping$0[issue2.getSeverity().ordinal()]) {
                        case 1: {
                            ++numErrors;
                            break;
                        }
                        case 2: {
                            ++numWarnings;
                            break;
                        }
                        case 3: {
                            ++numInfo;
                            break;
                        }
                        case 4: {
                            ++numUpdates;
                            break;
                        }
                        default: {
                            ++numOther;
                        }
                    }
                    psGeneralIssue = psGeneralIssue2;
                } else {
                    psGeneralIssue = null;
                }
                if (psGeneralIssue == null) continue;
                PsGeneralIssue it$iv$iv = psGeneralIssue;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        psAnalyzerDaemon.addAll((List)destination$iv$iv, false);
        PsAnalyzerDaemonKt.access$getLOG$p().debug("Issues recreated: " + numErrors + " errors, " + numWarnings + " warnings, " + numInfo + " information, " + numUpdates + " updates, " + numOther + " other");
        this.notifyRunning();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon$AnalyzeModuleStructure;", "Lcom/intellij/util/ui/update/Update;", "myModel", "Lcom/android/tools/idea/gradle/structure/model/PsModule;", "(Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon;Lcom/android/tools/idea/gradle/structure/model/PsModule;)V", "run", "", "intellij.android.projectSystem.gradle.psd"})
    private final class AnalyzeModuleStructure
    extends Update {
        @NotNull
        private final PsModule myModel;

        public AnalyzeModuleStructure(PsModule myModel) {
            Intrinsics.checkNotNullParameter((Object)myModel, (String)"myModel");
            super((Object)myModel);
            this.myModel = myModel;
        }

        public void run() {
            try {
                if (!this.isDisposed() && !PsAnalyzerDaemon.this.isStopped()) {
                    PsAnalyzerDaemon.this.doAnalyzeStructure(this.myModel);
                }
            }
            catch (Throwable e) {
                PsAnalyzerDaemonKt.access$getLOG$p().error("Failed to analyze " + this.myModel, e);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon$IssuesComputed;", "Lcom/intellij/util/ui/update/Update;", "(Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon;)V", "run", "", "intellij.android.projectSystem.gradle.psd"})
    private final class IssuesComputed
    extends Update {
        public IssuesComputed() {
            super(IssuesComputed.class);
        }

        @UiThread
        public void run() {
            ((IssuesUpdatedListener)PsAnalyzerDaemon.this.issuesUpdatedEventDispatcher.getMulticaster()).issuesUpdated();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsAnalyzerDaemon$IssuesUpdatedListener;", "Ljava/util/EventListener;", "issuesUpdated", "", "intellij.android.projectSystem.gradle.psd"})
    private static interface IssuesUpdatedListener
    extends EventListener {
        public void issuesUpdated();
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PsIssue.Severity.values().length];
            try {
                nArray[PsIssue.Severity.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsIssue.Severity.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsIssue.Severity.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsIssue.Severity.UPDATE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

