/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui.treeview;

import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractBaseTreeBuilder;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsModelNode;
import com.google.common.base.Strings;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.TreeVisitor;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeBuilderSpeedSearch
extends SpeedSearchSupply {
    @NonNls
    private static final String ENTERED_PREFIX_PROPERTY_NAME = "enteredPrefix";
    @NotNull
    private final AbstractBaseTreeBuilder myTreeBuilder;
    @NotNull
    private final JTree myTree;
    @NotNull
    private final PropertyChangeSupport myChangeSupport = new PropertyChangeSupport((Object)this);
    @NotNull
    private final SpeedSearchComparator myComparator = new SpeedSearchComparator(false);
    private String myRecentEnteredPrefix;
    private SearchPopup mySearchPopup;
    private JLayeredPane myPopupLayeredPane;

    public static void installTo(@NotNull AbstractBaseTreeBuilder treeBuilder) {
        new TreeBuilderSpeedSearch(treeBuilder);
    }

    private TreeBuilderSpeedSearch(@NotNull AbstractBaseTreeBuilder treeBuilder) {
        this.myTreeBuilder = treeBuilder;
        this.myTree = this.myTreeBuilder.getUi().getTree();
        this.myTree.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent event2) {
                TreeBuilderSpeedSearch.this.manageSearchPopup(null);
            }

            @Override
            public void componentMoved(ComponentEvent event2) {
                TreeBuilderSpeedSearch.this.moveSearchPopup();
            }

            @Override
            public void componentResized(ComponentEvent event2) {
                TreeBuilderSpeedSearch.this.moveSearchPopup();
            }
        });
        this.myTree.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TreeBuilderSpeedSearch.this.manageSearchPopup(null);
            }
        });
        this.myTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                TreeBuilderSpeedSearch.this.processKeyEvent(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                TreeBuilderSpeedSearch.this.processKeyEvent(e);
            }
        });
        this.installSupplyTo(this.myTree);
    }

    private void manageSearchPopup(@Nullable SearchPopup searchPopup) {
        if (this.mySearchPopup != null) {
            this.myPopupLayeredPane.remove(this.mySearchPopup);
            UiUtil.revalidateAndRepaint(this.myPopupLayeredPane);
            this.myPopupLayeredPane = null;
        }
        this.mySearchPopup = !this.myTree.isShowing() ? null : searchPopup;
        if (this.mySearchPopup == null || !this.myTree.isDisplayable()) {
            return;
        }
        JRootPane rootPane = this.myTree.getRootPane();
        this.myPopupLayeredPane = rootPane != null ? rootPane.getLayeredPane() : null;
        if (this.myPopupLayeredPane == null) {
            return;
        }
        this.myPopupLayeredPane.add((Component)this.mySearchPopup, JLayeredPane.POPUP_LAYER);
        this.moveSearchPopup();
    }

    private void moveSearchPopup() {
        if (this.mySearchPopup == null || this.myPopupLayeredPane == null) {
            return;
        }
        Window window2 = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.myTree);
        Point windowLocation = window2 instanceof JDialog ? ((JDialog)window2).getContentPane().getLocationOnScreen() : (window2 instanceof JFrame ? ((JFrame)window2).getContentPane().getLocationOnScreen() : window2.getLocationOnScreen());
        Rectangle visibleRect = this.getComponentVisibleRect();
        Dimension searchPopupPreferredSize = this.mySearchPopup.getPreferredSize();
        Point popUpLayeredPaneLocation = this.myPopupLayeredPane.getLocationOnScreen();
        Point locationOnScreen = this.getComponentLocationOnScreen();
        int y = visibleRect.y + locationOnScreen.y - popUpLayeredPaneLocation.y - searchPopupPreferredSize.height;
        y = Math.max(y, windowLocation.y - popUpLayeredPaneLocation.y);
        this.mySearchPopup.setLocation(locationOnScreen.x - popUpLayeredPaneLocation.x + visibleRect.x, y);
        this.mySearchPopup.setSize(searchPopupPreferredSize);
        this.mySearchPopup.setVisible(true);
        this.mySearchPopup.validate();
    }

    protected Rectangle getComponentVisibleRect() {
        return this.myTree.getVisibleRect();
    }

    protected Point getComponentLocationOnScreen() {
        return this.myTree.getLocationOnScreen();
    }

    protected void processKeyEvent(@NotNull KeyEvent e) {
        if (e.isAltDown() || e.isShiftDown()) {
            return;
        }
        if (this.mySearchPopup != null) {
            this.mySearchPopup.processKeyEvent(e);
            return;
        }
        if (e.getID() == 400) {
            if (!UIUtil.isReallyTypedEvent((KeyEvent)e)) {
                return;
            }
            char c = e.getKeyChar();
            if (Character.isLetterOrDigit(c) || c == '_' || c == '*' || c == '/' || c == ':' || c == '.' || c == '#' || c == '$') {
                this.manageSearchPopup(new SearchPopup(String.valueOf(c)));
                e.consume();
            }
        }
    }

    @Nullable
    public String getEnteredPrefix() {
        return this.mySearchPopup != null ? this.mySearchPopup.mySearchField.getText() : null;
    }

    @Nullable
    public Iterable<TextRange> matchingFragments(@NotNull String text2) {
        String recentSearchText = this.myComparator.getRecentSearchText();
        return StringUtil.isNotEmpty((String)recentSearchText) ? this.myComparator.matchingFragments(recentSearchText, text2) : null;
    }

    public void refreshSelection() {
        if (this.mySearchPopup != null) {
            this.mySearchPopup.refreshSelection();
        }
    }

    public boolean isPopupActive() {
        return this.mySearchPopup != null && this.mySearchPopup.isVisible();
    }

    public void addChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myChangeSupport.addPropertyChangeListener(listener2);
    }

    public void removeChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myChangeSupport.removePropertyChangeListener(listener2);
    }

    private void fireStateChanged() {
        String enteredPrefix = this.getEnteredPrefix();
        this.myChangeSupport.firePropertyChange(ENTERED_PREFIX_PROPERTY_NAME, this.myRecentEnteredPrefix, enteredPrefix);
        this.myRecentEnteredPrefix = enteredPrefix;
    }

    public void findAndSelectElement(@NotNull String searchQuery) {
        final String pattern = searchQuery.trim();
        this.myTree.clearSelection();
        if (searchQuery.isEmpty()) {
            return;
        }
        ActionCallback initialized = this.myTreeBuilder.getInitialized();
        initialized.doWhenDone(() -> {
            Object foreground;
            final ArrayList nodes2 = new ArrayList();
            this.myTreeBuilder.accept(AbstractPsModelNode.class, (TreeVisitor)new TreeVisitor<AbstractPsModelNode>(){

                public boolean visit(@NotNull AbstractPsModelNode node) {
                    if (TreeBuilderSpeedSearch.this.isMatchingElement(node, pattern)) {
                        nodes2.add(node);
                    }
                    return false;
                }
            });
            Object object = foreground = nodes2.isEmpty() ? JBColor.red : UIUtil.getToolTipForeground();
            if (this.mySearchPopup != null) {
                this.mySearchPopup.mySearchField.setForeground((Color)foreground);
            }
            if (nodes2.isEmpty()) {
                return;
            }
            Runnable onDone = () -> {
                this.myTreeBuilder.expandParents(nodes2);
                this.myTreeBuilder.scrollToFirstSelectedRow();
            };
            this.myTreeBuilder.getUi().userSelect(nodes2.toArray(), () -> {
                AbstractTreeUi ui = this.myTreeBuilder.getUi();
                if (ui != null) {
                    ui.executeUserRunnable(onDone);
                } else {
                    onDone.run();
                }
            }, false, false);
        });
    }

    @NotNull
    private List<AbstractPsModelNode> findNodes(@NotNull String searchQuery) {
        final String pattern = searchQuery.trim();
        final ArrayList<AbstractPsModelNode> nodes2 = new ArrayList<AbstractPsModelNode>();
        ActionCallback initialized = this.myTreeBuilder.getInitialized();
        initialized.doWhenDone(() -> this.myTreeBuilder.accept(AbstractPsModelNode.class, (TreeVisitor)new TreeVisitor<AbstractPsModelNode>(){

            public boolean visit(@NotNull AbstractPsModelNode node) {
                if (TreeBuilderSpeedSearch.this.isMatchingElement(node, pattern)) {
                    nodes2.add(node);
                }
                return false;
            }
        }));
        return nodes2;
    }

    private boolean isMatchingElement(@NotNull AbstractPsModelNode node, @Nullable String pattern) {
        String text2 = node.getName();
        return text2 != null && this.compare(text2, pattern);
    }

    private boolean compare(@NotNull String text2, @Nullable String pattern) {
        return pattern != null && this.myComparator.matchingFragments(pattern, text2) != null;
    }

    private class SearchPopup
    extends JPanel {
        @NotNull
        private final SearchField mySearchField;

        SearchPopup(String initialString) {
            super(new BorderLayout());
            JBColor background = new JBColor(UIUtil.getToolTipBackground().brighter(), (Color)Gray._111);
            this.mySearchField = new SearchField();
            this.mySearchField.setBorder(null);
            this.mySearchField.setBackground((Color)background);
            this.mySearchField.setForeground(UIUtil.getToolTipForeground());
            this.mySearchField.setDocument(new PlainDocument(){

                @Override
                public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                    String oldText;
                    try {
                        oldText = this.getText(0, this.getLength());
                    }
                    catch (BadLocationException e1) {
                        oldText = "";
                    }
                    String newText = oldText.substring(0, offs) + str + oldText.substring(offs);
                    super.insertString(offs, str, a);
                    if (TreeBuilderSpeedSearch.this.findNodes(newText).isEmpty()) {
                        SearchPopup.this.mySearchField.setForeground((Color)JBColor.RED);
                    } else {
                        SearchPopup.this.mySearchField.setForeground(UIUtil.getToolTipForeground());
                    }
                }
            });
            this.mySearchField.setText(Strings.nullToEmpty((String)initialString));
            JLabel searchLabel = new JLabel(" Search for: ");
            searchLabel.setFont(searchLabel.getFont().deriveFont(1));
            searchLabel.setForeground(UIUtil.getToolTipForeground());
            this.setBorder(BorderFactory.createLineBorder((Color)JBColor.GRAY, 1));
            this.setBackground((Color)background);
            this.add((Component)searchLabel, "West");
            this.add((Component)this.mySearchField, "East");
            this.refreshSelection();
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            this.mySearchField.processKeyEvent(e);
            if (e.isConsumed()) {
                this.refreshSelection();
            }
        }

        void refreshSelection() {
            if (TreeBuilderSpeedSearch.this.mySearchPopup != null) {
                TreeBuilderSpeedSearch.this.mySearchPopup.setSize(TreeBuilderSpeedSearch.this.mySearchPopup.getPreferredSize());
                TreeBuilderSpeedSearch.this.mySearchPopup.validate();
            }
            TreeBuilderSpeedSearch.this.findAndSelectElement(this.mySearchField.getText());
            TreeBuilderSpeedSearch.this.fireStateChanged();
        }
    }

    private class SearchField
    extends JTextField {
        SearchField() {
            this.setFocusable(false);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            preferredSize.width = this.getFontMetrics(this.getFont()).stringWidth(this.getText()) + 10;
            return preferredSize;
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (keyCode == 8 && this.getDocument().getLength() == 0) {
                e.consume();
                return;
            }
            if (keyCode == 10 || keyCode == 27 || keyCode == 33 || keyCode == 34 || keyCode == 37 || keyCode == 39) {
                TreeBuilderSpeedSearch.this.manageSearchPopup(null);
                if (keyCode == 27) {
                    e.consume();
                }
                return;
            }
            super.processKeyEvent(e);
            if (keyCode == 8) {
                e.consume();
            }
        }
    }
}

