/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui.treeview;

import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractBaseTreeStructure;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsNode;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.IndexComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBaseTreeBuilder
extends AbstractTreeBuilder {
    public AbstractBaseTreeBuilder(@NotNull JTree tree2, @NotNull DefaultTreeModel treeModel, @NotNull AbstractBaseTreeStructure treeStructure) {
        super(tree2, treeModel, (AbstractTreeStructure)treeStructure, (Comparator)IndexComparator.INSTANCE);
    }

    public boolean isToEnsureSelectionOnFocusGained() {
        return false;
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        if (nodeDescriptor instanceof AbstractPsNode) {
            return ((AbstractPsNode)nodeDescriptor).isAutoExpandNode();
        }
        return super.isAutoExpandNode(nodeDescriptor);
    }

    protected boolean isSmartExpand() {
        return true;
    }

    public void expandAllNodes() {
        JTree tree2 = this.getTree();
        if (tree2 != null) {
            this.clearSelection();
            TreeUtil.expandAll((JTree)tree2);
            this.onAllNodesExpanded();
        }
    }

    protected void onAllNodesExpanded() {
    }

    public void collapseAllNodes() {
        JTree tree2 = this.getTree();
        if (tree2 != null) {
            TreeUtil.collapseAll((JTree)tree2, (int)1);
            tree2.clearSelection();
        }
    }

    public void clearSelection() {
        JTree tree2 = this.getTree();
        if (tree2 != null) {
            tree2.clearSelection();
        }
    }

    public void expandParents(@NotNull List<? extends SimpleNode> nodes2) {
        ArrayList<SimpleNode> toExpand = new ArrayList<SimpleNode>();
        for (SimpleNode simpleNode : nodes2) {
            SimpleNode parent2 = simpleNode.getParent();
            if (parent2 == null) continue;
            toExpand.add(parent2);
        }
        this.expand(toExpand.toArray(), null);
    }

    public void scrollToFirstSelectedRow() {
        int[] selectionRows;
        JTree tree2 = this.getTree();
        if (tree2 != null && (selectionRows = tree2.getSelectionRows()) != null && selectionRows.length > 0) {
            if (selectionRows.length > 1) {
                Arrays.sort(selectionRows);
            }
            int firstRow = selectionRows[0];
            TreeUtil.showRowCentered((JTree)tree2, (int)firstRow, (boolean)false, (boolean)true);
        }
    }
}

