/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui;

import com.android.tools.idea.gradle.structure.configurables.ui.ToolWindowHeader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.AnchoredButton;
import com.intellij.toolWindow.StripeButtonUi;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.plaf.ButtonUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ToolWindowPanel
extends JPanel
implements Disposable {
    @NotNull
    private final ToolWindowHeader myHeader;
    @NotNull
    private final EventDispatcher<RestoreListener> myEventDispatcher = EventDispatcher.create(RestoreListener.class);
    private JPanel myMinimizedPanel;
    private AnchoredToolWindowButton myAnchoredButton;

    protected ToolWindowPanel(@NotNull String title, @NotNull Icon icon2, @Nullable ToolWindowAnchor anchor) {
        super(new BorderLayout());
        this.myHeader = ToolWindowHeader.createAndAdd(title, icon2, this, anchor);
        if (anchor != null) {
            this.myAnchoredButton = new AnchoredToolWindowButton(this.myHeader, anchor);
            this.myAnchoredButton.addActionListener(e -> {
                this.myAnchoredButton.setSelected(false);
                ((RestoreListener)this.myEventDispatcher.getMulticaster()).restored();
            });
            this.myMinimizedPanel = new MinimizedContainerPanel(this.myAnchoredButton);
        }
    }

    public void addRestoreListener(@NotNull RestoreListener listener2) {
        this.myEventDispatcher.addListener((EventListener)listener2, (Disposable)this);
    }

    @Nullable
    public JPanel getMinimizedPanel() {
        return this.myMinimizedPanel;
    }

    @NotNull
    public ToolWindowHeader getHeader() {
        return this.myHeader;
    }

    @Nullable
    public ToolWindowAnchor getAnchor() {
        return this.myAnchoredButton != null ? this.myAnchoredButton.getAnchor() : null;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myHeader);
    }

    public static interface RestoreListener
    extends EventListener {
        public void restored();
    }

    private static class AnchoredToolWindowButton
    extends AnchoredButton {
        @NotNull
        private final ToolWindowAnchor myAnchor;

        AnchoredToolWindowButton(@NotNull ToolWindowHeader header, @NotNull ToolWindowAnchor anchor) {
            super(header.getTitle(), header.getIcon());
            this.myAnchor = anchor;
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setFocusable(false);
            this.setRolloverEnabled(true);
            this.setOpaque(false);
        }

        public void updateUI() {
            this.setUI((ButtonUI)new StripeButtonUi());
            this.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        }

        public int getMnemonic2() {
            return 0;
        }

        @NotNull
        public ToolWindowAnchor getAnchor() {
            return this.myAnchor;
        }
    }

    private static class MinimizedContainerPanel
    extends JPanel {
        @NotNull
        private final AnchoredToolWindowButton myAnchoredButton;

        MinimizedContainerPanel(@NotNull AnchoredToolWindowButton anchoredButton) {
            this.myAnchoredButton = anchoredButton;
            this.configureBorder();
            this.add((Component)((Object)this.myAnchoredButton));
        }

        private void configureBorder() {
            int borderStyle;
            ToolWindowAnchor anchor = this.myAnchoredButton.getAnchor();
            if (anchor == ToolWindowAnchor.LEFT) {
                borderStyle = 4;
            } else if (anchor == ToolWindowAnchor.RIGHT) {
                borderStyle = 1;
            } else if (anchor == ToolWindowAnchor.BOTTOM) {
                borderStyle = 2;
            } else {
                return;
            }
            this.setBorder(IdeBorderFactory.createBorder((int)borderStyle));
        }

        @Override
        public void doLayout() {
            Dimension size = this.myAnchoredButton.getPreferredSize();
            if (this.myAnchoredButton.getAnchor() == ToolWindowAnchor.BOTTOM) {
                this.myAnchoredButton.setBounds(0, 1, size.width, 25);
            } else {
                this.myAnchoredButton.setBounds(0, 0, this.getWidth(), size.height);
            }
        }
    }
}

