/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui;

import com.android.tools.idea.gradle.util.ui.Header;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.ChildFocusWatcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolWindowHeader
extends Header
implements Disposable {
    @NotNull
    private final Icon myIcon;
    @Nullable
    private final ToolWindowAnchor myAnchor;
    private JComponent myPreferredFocusedComponent;
    private AnAction myMinimizeAction;
    private ChildFocusWatcher myFocusWatcher;
    private final EventDispatcher<MinimizeListener> myEventDispatcher = EventDispatcher.create(MinimizeListener.class);

    @NotNull
    public static ToolWindowHeader createAndAdd(@NotNull String title, @NotNull Icon icon2, final @NotNull JComponent parent2, @Nullable ToolWindowAnchor anchor) {
        LayoutManager layout = parent2.getLayout();
        assert (layout instanceof BorderLayout);
        final ToolWindowHeader header = new ToolWindowHeader(title, icon2, anchor){

            @Override
            public boolean isActive() {
                KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                Component focusOwner = focusManager.getFocusOwner();
                return focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, parent2);
            }
        };
        parent2.add((Component)header, "North");
        MyFocusWatcher focusWatcher = new MyFocusWatcher(parent2){

            @Override
            void onFocusChange(FocusEvent event2) {
                header.repaint();
            }
        };
        header.setFocusWatcher(focusWatcher);
        return header;
    }

    private ToolWindowHeader(@NotNull String title, @NotNull Icon icon2, @Nullable ToolWindowAnchor anchor) {
        super(title);
        this.myIcon = icon2;
        this.myAnchor = anchor;
        if (this.myAnchor != null) {
            this.myMinimizeAction = new DumbAwareAction("Hide", "", AllIcons.General.HideToolWindow){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    ((MinimizeListener)ToolWindowHeader.this.myEventDispatcher.getMulticaster()).minimized();
                }
            };
            this.setAdditionalActions(Lists.newArrayList((Object[])new AnAction[]{this.myMinimizeAction}));
        }
        this.addActivationListener(() -> {
            if (this.myPreferredFocusedComponent != null) {
                this.myPreferredFocusedComponent.requestFocusInWindow();
            }
        }, this);
    }

    @Override
    public void setAdditionalActions(@NotNull List<AnAction> actions2) {
        ArrayList allActions = actions2;
        if (this.myMinimizeAction != null && !actions2.contains(this.myMinimizeAction)) {
            allActions = Lists.newArrayList(actions2);
            allActions.add(this.myMinimizeAction);
        }
        super.setAdditionalActions(allActions);
    }

    private void setFocusWatcher(@NotNull ChildFocusWatcher focusWatcher) {
        this.myFocusWatcher = focusWatcher;
    }

    public void setPreferredFocusedComponent(@Nullable JComponent preferredFocusedComponent) {
        this.myPreferredFocusedComponent = preferredFocusedComponent;
    }

    public void dispose() {
        if (this.myFocusWatcher != null) {
            Disposer.dispose((Disposable)this.myFocusWatcher);
        }
    }

    @NotNull
    Icon getIcon() {
        return this.myIcon;
    }

    @Nullable
    public ToolWindowAnchor getAnchor() {
        return this.myAnchor;
    }

    public void addMinimizeListener(@NotNull MinimizeListener listener2) {
        this.myEventDispatcher.addListener((EventListener)listener2, (Disposable)this);
    }

    public static interface MinimizeListener
    extends EventListener {
        public void minimized();
    }

    private static abstract class MyFocusWatcher
    extends ChildFocusWatcher {
        MyFocusWatcher(@NotNull JComponent parent2) {
            super(parent2);
        }

        protected void onFocusGained(FocusEvent event2) {
            this.onFocusChange(event2);
        }

        protected void onFocusLost(FocusEvent event2) {
            this.onFocusChange(event2);
        }

        abstract void onFocusChange(FocusEvent var1);
    }
}

