/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui;

import com.android.ide.common.gradle.Version;
import com.android.tools.idea.gradle.repositories.search.ArtifactRepositorySearchService;
import com.android.tools.idea.gradle.repositories.search.FoundArtifact;
import com.android.tools.idea.gradle.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.repositories.search.SearchResult;
import com.android.tools.idea.gradle.structure.configurables.ui.ArtifactRepositorySearchForm;
import com.android.tools.idea.gradle.structure.configurables.ui.ArtifactRepositorySearchFormKt;
import com.android.tools.idea.gradle.structure.configurables.ui.ArtifactRepositorySearchFormUi;
import com.android.tools.idea.gradle.structure.configurables.ui.ArtifactSearchQuery;
import com.android.tools.idea.gradle.structure.configurables.ui.AvailableVersionsPanel;
import com.android.tools.idea.gradle.structure.configurables.ui.FutureUtilsKt;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeEventDispatcher;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeListener;
import com.android.tools.idea.gradle.structure.model.PsVariablesScope;
import com.android.tools.idea.gradle.structure.model.meta.ParsedValue;
import com.intellij.openapi.Disposable;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.StatusText;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u00013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010&\u001a\u00020'2\u0012\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0)2\u0006\u0010*\u001a\u00020+J\b\u0010,\u001a\u00020'H\u0002J\b\u0010-\u001a\u00020\bH\u0002J\u0016\u0010.\u001a\u00020'2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u000bH\u0002J\b\u00101\u001a\u00020'H\u0002J\b\u00102\u001a\u00020'H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u001c\u001a\f\u0012\b\u0012\u00060\u001aj\u0002`\u001b0\u00192\u0010\u0010\u0018\u001a\f\u0012\b\u0012\u00060\u001aj\u0002`\u001b0\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/android/tools/idea/gradle/structure/configurables/ui/ArtifactRepositorySearchForm;", "Lcom/android/tools/idea/gradle/structure/configurables/ui/ArtifactRepositorySearchFormUi;", "variables", "Lcom/android/tools/idea/gradle/structure/model/PsVariablesScope;", "repositorySearch", "Lcom/android/tools/idea/gradle/repositories/search/ArtifactRepositorySearchService;", "(Lcom/android/tools/idea/gradle/structure/model/PsVariablesScope;Lcom/android/tools/idea/gradle/repositories/search/ArtifactRepositorySearchService;)V", "currentSearchQuery", "Lcom/android/tools/idea/gradle/structure/configurables/ui/ArtifactSearchQuery;", "eventDispatcher", "Lcom/android/tools/idea/gradle/structure/configurables/ui/SelectionChangeEventDispatcher;", "Lcom/android/tools/idea/gradle/structure/model/meta/ParsedValue;", "", "panel", "Ljavax/swing/JPanel;", "getPanel", "()Ljavax/swing/JPanel;", "preferredFocusedComponent", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "()Ljavax/swing/JComponent;", "resultsTable", "Lcom/intellij/ui/table/TableView;", "Lcom/android/tools/idea/gradle/repositories/search/FoundArtifact;", "<set-?>", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "searchErrors", "getSearchErrors", "()Ljava/util/List;", "selectedArtifact", "getSelectedArtifact", "()Lcom/android/tools/idea/gradle/repositories/search/FoundArtifact;", "getVariables", "()Lcom/android/tools/idea/gradle/structure/model/PsVariablesScope;", "versionsPanel", "Lcom/android/tools/idea/gradle/structure/configurables/ui/AvailableVersionsPanel;", "add", "", "listener", "Lcom/android/tools/idea/gradle/structure/configurables/ui/SelectionChangeListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "clearResults", "getQuery", "notifyVersionSelectionChanged", "version", "Lcom/android/ide/common/gradle/Version;", "performSearch", "showSearchStopped", "ResultsTableModel", "intellij.android.projectSystem.gradle.psd"})
@SourceDebugExtension(value={"SMAP\nArtifactRepositorySearchForm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArtifactRepositorySearchForm.kt\ncom/android/tools/idea/gradle/structure/configurables/ui/ArtifactRepositorySearchForm\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,328:1\n1#2:329\n*E\n"})
public final class ArtifactRepositorySearchForm
extends ArtifactRepositorySearchFormUi {
    @NotNull
    private final PsVariablesScope variables;
    @NotNull
    private final ArtifactRepositorySearchService repositorySearch;
    @NotNull
    private final TableView<FoundArtifact> resultsTable;
    @NotNull
    private final AvailableVersionsPanel versionsPanel;
    @NotNull
    private final SelectionChangeEventDispatcher<ParsedValue<String>> eventDispatcher;
    @NotNull
    private List<? extends Exception> searchErrors;
    @Nullable
    private ArtifactSearchQuery currentSearchQuery;

    public ArtifactRepositorySearchForm(@NotNull PsVariablesScope variables, @NotNull ArtifactRepositorySearchService repositorySearch) {
        StatusText statusText;
        Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
        Intrinsics.checkNotNullParameter((Object)repositorySearch, (String)"repositorySearch");
        this.variables = variables;
        this.repositorySearch = repositorySearch;
        this.eventDispatcher = new SelectionChangeEventDispatcher();
        this.searchErrors = CollectionsKt.emptyList();
        DocumentAdapter inputChangedListener2 = new DocumentAdapter(this){
            final /* synthetic */ ArtifactRepositorySearchForm this$0;
            {
                this.this$0 = $receiver;
            }

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ArtifactRepositorySearchForm.access$clearResults(this.this$0);
                ArtifactRepositorySearchForm.access$showSearchStopped(this.this$0);
            }
        };
        this.myArtifactQueryTextField.getDocument().addDocumentListener((DocumentListener)inputChangedListener2);
        ActionListener actionListener2 = new ActionListener(this){
            final /* synthetic */ ArtifactRepositorySearchForm this$0;
            {
                this.this$0 = $receiver;
            }

            public final void actionPerformed(ActionEvent it) {
                if (this.this$0.mySearchButton.isEnabled()) {
                    ArtifactRepositorySearchForm.access$performSearch(this.this$0);
                }
            }
        };
        this.mySearchButton.addActionListener(actionListener2);
        this.myArtifactQueryTextField.addActionListener(actionListener2);
        StatusText $this$_init__u24lambda_u240 = statusText = this.myArtifactQueryTextField.getEmptyText();
        boolean bl = false;
        $this$_init__u24lambda_u240.clear();
        $this$_init__u24lambda_u240.appendText("Example: ", SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
        $this$_init__u24lambda_u240.appendText("guava", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        $this$_init__u24lambda_u240.appendText(" or ", SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
        $this$_init__u24lambda_u240.appendText("com.google.*:*", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        $this$_init__u24lambda_u240.appendText(" or ", SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
        $this$_init__u24lambda_u240.appendText("guava*", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        this.resultsTable = new TableView((ListTableModel)new ResultsTableModel());
        this.resultsTable.setSelectionMode(0);
        this.resultsTable.setAutoCreateRowSorter(true);
        this.resultsTable.setShowGrid(false);
        this.resultsTable.getTableHeader().setReorderingAllowed(false);
        this.versionsPanel = new AvailableVersionsPanel(new Consumer(){

            public final void accept(@NotNull ParsedValue<Version> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.notifyVersionSelectionChanged(it);
            }
        });
        this.resultsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public final void valueChanged(ListSelectionEvent it) {
                FoundArtifact artifact = this.getSelectedArtifact();
                ArtifactSearchQuery searchQuery = currentSearchQuery;
                if (searchQuery != null && artifact != null) {
                    versionsPanel.setVersions(ArtifactRepositorySearchFormKt.prepareArtifactVersionChoices(searchQuery, artifact, this.getVariables()));
                } else {
                    this.notifyVersionSelectionChanged(ParsedValue.NotSet.INSTANCE);
                }
            }
        });
        OnePixelSplitter splitter = new OnePixelSplitter(false, 0.7f);
        splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Component)this.resultsTable)));
        splitter.setSecondComponent((JComponent)this.versionsPanel);
        this.myResultsPanel.add((Component)splitter, "Center");
        new TableSpeedSearch((JTable)this.resultsTable);
    }

    @NotNull
    public final PsVariablesScope getVariables() {
        return this.variables;
    }

    private final FoundArtifact getSelectedArtifact() {
        Collection collection2 = this.resultsTable.getSelection();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"resultsTable.selection");
        return (FoundArtifact)CollectionsKt.singleOrNull((Iterable)collection2);
    }

    @NotNull
    public final JPanel getPanel() {
        JPanel jPanel = this.myPanel;
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"myPanel");
        return jPanel;
    }

    @NotNull
    public final JComponent getPreferredFocusedComponent() {
        JBTextField jBTextField = this.myArtifactQueryTextField;
        Intrinsics.checkNotNullExpressionValue((Object)jBTextField, (String)"myArtifactQueryTextField");
        return (JComponent)jBTextField;
    }

    @NotNull
    public final List<Exception> getSearchErrors() {
        return this.searchErrors;
    }

    private final ArtifactSearchQuery getQuery() {
        String string = this.myArtifactQueryTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myArtifactQueryTextField.text");
        return ArtifactRepositorySearchFormKt.parseArtifactSearchQuery(string);
    }

    private final void notifyVersionSelectionChanged(ParsedValue<Version> version2) {
        Object object;
        block8: {
            block7: {
                ParsedValue<String> parsedValue;
                object = this.getSelectedArtifact();
                if (object == null) break block7;
                FoundArtifact selectedArtifact = object;
                boolean bl = false;
                ParsedValue<Version> parsedValue2 = version2;
                if (Intrinsics.areEqual(parsedValue2, (Object)ParsedValue.NotSet.INSTANCE)) {
                    parsedValue = ParsedValue.NotSet.INSTANCE;
                } else if (parsedValue2 instanceof ParsedValue.Set.Parsed) {
                    parsedValue = ArtifactRepositorySearchFormKt.versionToLibrary(selectedArtifact, (ParsedValue.Set.Parsed)version2);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                object = parsedValue;
                if (parsedValue != null) break block8;
            }
            object = ParsedValue.NotSet.INSTANCE;
        }
        Object selectedLibrary = object;
        this.eventDispatcher.selectionChanged((ParsedValue<String>)selectedLibrary);
    }

    private final void performSearch() {
        ArtifactSearchQuery artifactSearchQuery;
        this.mySearchButton.setEnabled(false);
        this.versionsPanel.setEmptyText("Searching...");
        this.resultsTable.getEmptyText().setText("Searching...");
        this.resultsTable.setPaintBusy(true);
        this.clearResults();
        ArtifactSearchQuery it = artifactSearchQuery = this.getQuery();
        boolean bl = false;
        this.currentSearchQuery = it;
        ArtifactSearchQuery searchQuery = artifactSearchQuery;
        SearchRequest request2 = new SearchRequest(ArtifactRepositorySearchFormKt.access$toSearchQeury(searchQuery), 50, 0);
        FutureUtilsKt.continueOnEdt(this.repositorySearch.search(request2), (Function1)new Function1<SearchResult, Unit>(this, searchQuery){
            final /* synthetic */ ArtifactRepositorySearchForm this$0;
            final /* synthetic */ ArtifactSearchQuery $searchQuery;
            {
                this.this$0 = $receiver;
                this.$searchQuery = $searchQuery;
                super(1);
            }

            public final void invoke(@NotNull SearchResult results2) {
                Intrinsics.checkNotNullParameter((Object)results2, (String)"results");
                Object object = CollectionsKt.sorted((Iterable)results2.getArtifacts());
                List it = object;
                boolean bl = false;
                Object object2 = !it.isEmpty() ? object : null;
                if (object2 == null) {
                    object = this.this$0;
                    ArtifactSearchQuery artifactSearchQuery = this.$searchQuery;
                    Object it2 = object;
                    boolean bl2 = false;
                    if (artifactSearchQuery.getGradleCoordinates() != null) {
                        String string;
                        String string2 = artifactSearchQuery.getGradleCoordinates().getGroupId();
                        if (string2 == null) {
                            string2 = "";
                        }
                        if ((string = artifactSearchQuery.getGradleCoordinates().getArtifactId()) == null) {
                            string = "";
                        }
                        Version version2 = artifactSearchQuery.getGradleCoordinates().getLowerBoundVersion();
                        Intrinsics.checkNotNull((Object)version2);
                        object2 = CollectionsKt.listOf((Object)new FoundArtifact("(none)", string2, string, version2));
                    } else {
                        object2 = CollectionsKt.emptyList();
                    }
                }
                List foundArtifacts = object2;
                ArtifactRepositorySearchForm.access$getResultsTable$p(this.this$0).getListTableModel().setItems(foundArtifacts);
                ArtifactRepositorySearchForm.access$getResultsTable$p(this.this$0).updateColumnSizes();
                if (!((Collection)foundArtifacts).isEmpty()) {
                    ArtifactRepositorySearchForm.access$getResultsTable$p(this.this$0).changeSelection(0, 0, false, false);
                }
                ArtifactRepositorySearchForm.access$getResultsTable$p(this.this$0).requestFocusInWindow();
                List<Exception> errors2 = results2.getErrors();
                if (!((Collection)errors2).isEmpty()) {
                    ArtifactRepositorySearchForm.access$setSearchErrors$p(this.this$0, errors2);
                }
                ArtifactRepositorySearchForm.access$showSearchStopped(this.this$0);
            }
        });
    }

    private final void clearResults() {
        this.currentSearchQuery = null;
        this.resultsTable.getListTableModel().setItems(CollectionsKt.emptyList());
        this.searchErrors = CollectionsKt.emptyList();
        this.versionsPanel.clear();
    }

    private final void showSearchStopped() {
        ArtifactSearchQuery it = this.getQuery();
        JButton jButton = this.mySearchButton;
        boolean bl = false;
        String string = it.getArtifactName();
        String string2 = it.getGroupId();
        boolean bl2 = (string != null ? string.length() : 0) + (string2 != null ? string2.length() : 0) >= 3;
        jButton.setEnabled(bl2);
        this.resultsTable.setPaintBusy(false);
        this.resultsTable.getEmptyText().setText("Nothing to show");
        this.versionsPanel.setEmptyText("Nothing to show");
    }

    public final void add(@NotNull SelectionChangeListener<ParsedValue<String>> listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.eventDispatcher.addListener(listener2, parentDisposable);
    }

    public static final /* synthetic */ TableView access$getResultsTable$p(ArtifactRepositorySearchForm $this) {
        return $this.resultsTable;
    }

    public static final /* synthetic */ void access$setSearchErrors$p(ArtifactRepositorySearchForm $this, List list2) {
        $this.searchErrors = list2;
    }

    public static final /* synthetic */ void access$showSearchStopped(ArtifactRepositorySearchForm $this) {
        $this.showSearchStopped();
    }

    public static final /* synthetic */ void access$clearResults(ArtifactRepositorySearchForm $this) {
        $this.clearResults();
    }

    public static final /* synthetic */ void access$performSearch(ArtifactRepositorySearchForm $this) {
        $this.performSearch();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/gradle/structure/configurables/ui/ArtifactRepositorySearchForm$ResultsTableModel;", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/android/tools/idea/gradle/repositories/search/FoundArtifact;", "()V", "createAndSetColumnInfos", "", "intellij.android.projectSystem.gradle.psd"})
    private static final class ResultsTableModel
    extends ListTableModel<FoundArtifact> {
        public ResultsTableModel() {
            super(new ColumnInfo[0]);
            this.createAndSetColumnInfos();
            this.setSortable(true);
        }

        private final void createAndSetColumnInfos() {
            createAndSetColumnInfos.column.1[] nullArray = new createAndSetColumnInfos.column.1[]{ResultsTableModel.createAndSetColumnInfos$column("Group ID", "abcdefghijklmno", (Function1<? super FoundArtifact, String>)((Function1)createAndSetColumnInfos.1.INSTANCE)), ResultsTableModel.createAndSetColumnInfos$column("Artifact Name", "abcdefg", (Function1<? super FoundArtifact, String>)((Function1)createAndSetColumnInfos.2.INSTANCE)), ResultsTableModel.createAndSetColumnInfos$column$default("Repository", null, createAndSetColumnInfos.3.INSTANCE, 2, null)};
            this.setColumnInfos(nullArray);
        }

        private static final createAndSetColumnInfos.column.1 createAndSetColumnInfos$column(String title, String preferredWidthTextSample, Function1<? super FoundArtifact, String> valueOf) {
            return new ColumnInfo<FoundArtifact, String>(title, valueOf, preferredWidthTextSample){
                final /* synthetic */ Function1<FoundArtifact, String> $valueOf;
                final /* synthetic */ String $preferredWidthTextSample;
                {
                    this.$valueOf = $valueOf;
                    this.$preferredWidthTextSample = $preferredWidthTextSample;
                    super($title);
                }

                @Nullable
                public String valueOf(@NotNull FoundArtifact found) {
                    Intrinsics.checkNotNullParameter((Object)found, (String)"found");
                    return (String)this.$valueOf.invoke((Object)found);
                }

                @NonNls
                @Nullable
                public String getPreferredStringValue() {
                    return this.$preferredWidthTextSample;
                }
            };
        }

        static /* synthetic */ createAndSetColumnInfos.column.1 createAndSetColumnInfos$column$default(String string, String string2, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            return ResultsTableModel.createAndSetColumnInfos$column(string, string2, (Function1<? super FoundArtifact, String>)function1);
        }
    }
}

