/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.suggestions;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.issues.IssueRenderer;
import com.android.tools.idea.gradle.structure.configurables.suggestions.SuggestionGroupViewer;
import com.android.tools.idea.gradle.structure.configurables.suggestions.SuggestionViewer;
import com.android.tools.idea.gradle.structure.configurables.suggestions.SuggestionsViewer;
import com.android.tools.idea.gradle.structure.configurables.suggestions.SuggestionsViewerUi;
import com.android.tools.idea.gradle.structure.configurables.ui.MergingUpdateQueueUtilsKt;
import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.intellij.openapi.Disposable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\b\u0010\u001a\u001a\u00020\u0015H\u0016J,\u0010\u001b\u001a\u00020\u00152\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00170\u001c2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/gradle/structure/configurables/suggestions/SuggestionsViewer;", "Lcom/android/tools/idea/gradle/structure/configurables/suggestions/SuggestionsViewerUi;", "Lcom/intellij/openapi/Disposable;", "context", "Lcom/android/tools/idea/gradle/structure/configurables/PsContext;", "renderer", "Lcom/android/tools/idea/gradle/structure/configurables/issues/IssueRenderer;", "(Lcom/android/tools/idea/gradle/structure/configurables/PsContext;Lcom/android/tools/idea/gradle/structure/configurables/issues/IssueRenderer;)V", "groups", "", "Lcom/android/tools/idea/gradle/structure/configurables/suggestions/SuggestionGroupViewer;", "lastDisplayedIssues", "", "Lcom/android/tools/idea/gradle/structure/model/PsIssue;", "panel", "Ljavax/swing/JPanel;", "getPanel", "()Ljavax/swing/JPanel;", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "display", "", "issues", "", "scope", "Lcom/android/tools/idea/gradle/structure/model/PsPath;", "dispose", "renderIssues", "Ljava/util/SortedMap;", "Lcom/android/tools/idea/gradle/structure/model/PsIssue$Severity;", "intellij.android.projectSystem.gradle.psd"})
@SourceDebugExtension(value={"SMAP\nSuggestionsViewer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuggestionsViewer.kt\ncom/android/tools/idea/gradle/structure/configurables/suggestions/SuggestionsViewer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,92:1\n1477#2:93\n1502#2,3:94\n1505#2,3:104\n359#3,7:97\n*S KotlinDebug\n*F\n+ 1 SuggestionsViewer.kt\ncom/android/tools/idea/gradle/structure/configurables/suggestions/SuggestionsViewer\n*L\n44#1:93\n44#1:94,3\n44#1:104,3\n44#1:97,7\n*E\n"})
public final class SuggestionsViewer
extends SuggestionsViewerUi
implements Disposable {
    @NotNull
    private final PsContext context;
    @NotNull
    private final IssueRenderer renderer;
    @NotNull
    private final MergingUpdateQueue updateQueue;
    @NotNull
    private final List<SuggestionGroupViewer> groups;
    @Nullable
    private Set<? extends PsIssue> lastDisplayedIssues;

    public SuggestionsViewer(@NotNull PsContext context2, @NotNull IssueRenderer renderer2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
        this.context = context2;
        this.renderer = renderer2;
        this.updateQueue = MergingUpdateQueueUtilsKt.createMergingUpdateQueue("SuggestionsViewer update queue", this, this.getPanel());
        this.groups = new ArrayList();
    }

    @NotNull
    public final JPanel getPanel() {
        JPanel jPanel = this.myMainPanel;
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"myMainPanel");
        return jPanel;
    }

    public final void display(@NotNull List<? extends PsIssue> issues, @Nullable PsPath scope2) {
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        Set newIssue = CollectionsKt.toSet((Iterable)issues);
        if (Intrinsics.areEqual(this.lastDisplayedIssues, (Object)newIssue)) {
            return;
        }
        if (this.getPanel().isShowing()) {
            this.updateQueue.cancelAllUpdates();
            SuggestionsViewer.display$render(newIssue, this, scope2);
        } else {
            MergingUpdateQueueUtilsKt.enqueueTagged(this.updateQueue, this, (Function0<Unit>)((Function0)new Function0<Unit>((Set<? extends PsIssue>)newIssue, this, scope2){
                final /* synthetic */ Set<PsIssue> $newIssue;
                final /* synthetic */ SuggestionsViewer this$0;
                final /* synthetic */ PsPath $scope;
                {
                    this.$newIssue = $newIssue;
                    this.this$0 = $receiver;
                    this.$scope = $scope;
                    super(0);
                }

                public final void invoke() {
                    SuggestionsViewer.access$display$render(this.$newIssue, this.this$0, this.$scope);
                }
            }));
        }
    }

    private final void renderIssues(SortedMap<PsIssue.Severity, List<PsIssue>> issues, PsPath scope2) {
        int groupIndex;
        this.myEmptyIssuesLabel.setVisible(issues.isEmpty());
        for (IndexedValue indexedValue : CollectionsKt.reversed((Iterable)CollectionsKt.withIndex((Iterable)this.groups))) {
            groupIndex = indexedValue.component1();
            SuggestionGroupViewer group2 = (SuggestionGroupViewer)indexedValue.component2();
            if (issues.keySet().contains((Object)group2.getSeverity())) continue;
            this.myMainPanel.remove(group2.getPanel());
            this.groups.remove(groupIndex);
        }
        Iterator<Object> iterator2 = issues.keySet().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            groupIndex = n++;
            PsIssue.Severity severity = (PsIssue.Severity)((Object)iterator2.next());
            if (groupIndex >= this.groups.size() || this.groups.get(groupIndex).getSeverity() != severity) {
                Intrinsics.checkNotNullExpressionValue((Object)((Object)severity), (String)"severity");
                SuggestionGroupViewer groupViewerUi = new SuggestionGroupViewer(severity);
                this.groups.add(groupIndex, groupViewerUi);
                this.myMainPanel.add((Component)groupViewerUi.getPanel(), groupIndex);
                continue;
            }
            SuggestionGroupViewer group3 = this.groups.get(groupIndex);
            group3.getView().removeAll();
            this.myMainPanel.add((Component)group3.getPanel(), groupIndex);
        }
        for (SuggestionGroupViewer group4 : this.groups) {
            List list2 = (List)issues.get((Object)group4.getSeverity());
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            List groupIssues = list2;
            Iterator iterator3 = groupIssues.iterator();
            int n2 = 0;
            while (iterator3.hasNext()) {
                int rowIndex = n2++;
                PsIssue issue2 = (PsIssue)iterator3.next();
                group4.getView().add(new SuggestionViewer(this.context, this.renderer, issue2, scope2, rowIndex == groupIssues.size() - 1).getComponent());
            }
        }
    }

    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    private static final void display$render(Set<? extends PsIssue> newIssue, SuggestionsViewer this$0, PsPath $scope) {
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = newIssue;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            PsIssue it = (PsIssue)element$iv$iv;
            boolean bl = false;
            PsIssue.Severity key$iv$iv = it.getSeverity();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Comparator comparator2 = Comparator.comparingInt(display.render.issuesBySeverity.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"comparingInt { it.priority }");
        SortedMap issuesBySeverity2 = MapsKt.toSortedMap((Map)destination$iv$iv, comparator2);
        this$0.renderIssues(issuesBySeverity2, $scope);
        UiUtil.revalidateAndRepaint(this$0.getPanel());
    }

    public static final /* synthetic */ void access$display$render(Set newIssue, SuggestionsViewer this$0, PsPath $scope) {
        SuggestionsViewer.display$render(newIssue, this$0, $scope);
    }
}

