/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.dependencies.module;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.dependencies.AbstractMainDependenciesPanel;
import com.android.tools.idea.gradle.structure.configurables.dependencies.module.DeclaredDependenciesPanel;
import com.android.tools.idea.gradle.structure.configurables.dependencies.module.ResolvedDependenciesPanel;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeListener;
import com.android.tools.idea.gradle.structure.configurables.ui.ToolWindowHeader;
import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.model.PsBaseDependency;
import com.android.tools.idea.gradle.structure.model.PsDeclaredDependency;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsResolvedDependency;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MainPanel
extends AbstractMainDependenciesPanel {
    @NotNull
    private final JBSplitter myVerticalSplitter;
    @NotNull
    private final DeclaredDependenciesPanel myDeclaredDependenciesPanel;
    @NotNull
    private final ResolvedDependenciesPanel myResolvedDependenciesPanel;
    @NotNull
    private final JPanel myAltPanel;
    private int myQueuedSelectionCounter = 0;

    public MainPanel(@NotNull PsModule module2, @NotNull PsContext context2) {
        super(context2);
        this.myDeclaredDependenciesPanel = new DeclaredDependenciesPanel(module2, context2);
        this.myDeclaredDependenciesPanel.setHistory(this.getHistory());
        this.myResolvedDependenciesPanel = new ResolvedDependenciesPanel(module2, context2, this.myDeclaredDependenciesPanel);
        this.myVerticalSplitter = this.createMainVerticalSplitter();
        this.myVerticalSplitter.setFirstComponent((JComponent)this.myDeclaredDependenciesPanel);
        this.myVerticalSplitter.setSecondComponent((JComponent)this.myResolvedDependenciesPanel);
        this.add((Component)this.myVerticalSplitter, "Center");
        this.myDeclaredDependenciesPanel.updateTableColumnSizes();
        this.myDeclaredDependenciesPanel.add(new SelectionChangeListener<PsBaseDependency>(){

            @Override
            public void selectionChanged(@Nullable PsBaseDependency newSelection) {
                if (MainPanel.this.myQueuedSelectionCounter == 0) {
                    ++MainPanel.this.myQueuedSelectionCounter;
                    MainPanel.this.myResolvedDependenciesPanel.setSelection(null).doWhenProcessed(() -> --MainPanel.this.myQueuedSelectionCounter);
                }
            }
        });
        this.myResolvedDependenciesPanel.add(new SelectionChangeListener<PsBaseDependency>(){

            @Override
            public void selectionChanged(@Nullable PsBaseDependency newSelection) {
                if (newSelection instanceof PsResolvedDependency) {
                    PsResolvedDependency resolvedDependency = (PsResolvedDependency)newSelection;
                    List<PsDeclaredDependency> declaredDependencies = resolvedDependency.getDeclaredDependencies();
                    if (MainPanel.this.myQueuedSelectionCounter == 0) {
                        ++MainPanel.this.myQueuedSelectionCounter;
                        if (!declaredDependencies.isEmpty()) {
                            MainPanel.this.myDeclaredDependenciesPanel.setSelection((Collection<? extends PsBaseDependency>)declaredDependencies).doWhenProcessed(() -> --MainPanel.this.myQueuedSelectionCounter);
                        } else {
                            MainPanel.this.myDeclaredDependenciesPanel.setSelection((Collection<? extends PsBaseDependency>)null).doWhenProcessed(() -> --MainPanel.this.myQueuedSelectionCounter);
                        }
                    }
                }
            }
        });
        JPanel minimizedContainerPanel = this.myResolvedDependenciesPanel.getMinimizedPanel();
        assert (minimizedContainerPanel != null);
        this.myAltPanel = new JPanel(new BorderLayout());
        this.myAltPanel.add((Component)minimizedContainerPanel, "East");
        ToolWindowHeader header = this.myResolvedDependenciesPanel.getHeader();
        header.addMinimizeListener(this::minimizeResolvedDependenciesPanel);
        this.myResolvedDependenciesPanel.addRestoreListener(this::restoreResolvedDependenciesPanel);
    }

    private void restoreResolvedDependenciesPanel() {
        this.remove(this.myAltPanel);
        this.myAltPanel.remove(this.myDeclaredDependenciesPanel);
        this.myVerticalSplitter.setFirstComponent((JComponent)this.myDeclaredDependenciesPanel);
        this.add((Component)this.myVerticalSplitter, "Center");
        UiUtil.revalidateAndRepaint(this);
        this.saveMinimizedState(false);
    }

    private void minimizeResolvedDependenciesPanel() {
        this.remove((Component)this.myVerticalSplitter);
        this.myVerticalSplitter.setFirstComponent(null);
        this.myAltPanel.add((Component)this.myDeclaredDependenciesPanel, "Center");
        this.add((Component)this.myAltPanel, "Center");
        UiUtil.revalidateAndRepaint(this);
        this.saveMinimizedState(true);
    }

    private void saveMinimizedState(boolean minimize) {
        this.getContext().getUiSettings().RESOLVED_DEPENDENCIES_MINIMIZE = minimize;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        boolean minimize = this.getContext().getUiSettings().RESOLVED_DEPENDENCIES_MINIMIZE;
        if (minimize) {
            this.minimizeResolvedDependenciesPanel();
        } else {
            this.restoreResolvedDependenciesPanel();
        }
    }

    @Override
    public void setHistory(History history) {
        super.setHistory(history);
        this.myDeclaredDependenciesPanel.setHistory(history);
    }

    public void putPath(@NotNull Place place, @NotNull String dependency) {
        this.myDeclaredDependenciesPanel.putPath(place, dependency);
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        return this.myDeclaredDependenciesPanel.navigateTo(place, requestFocus);
    }

    public void queryPlace(@NotNull Place place) {
        this.myDeclaredDependenciesPanel.queryPlace(place);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDeclaredDependenciesPanel);
        Disposer.dispose((Disposable)this.myResolvedDependenciesPanel);
    }
}

