/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.roots;

import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class AndroidGeneratedSourcesFilter
extends GeneratedSourcesFilter {
    public boolean isGeneratedSource(@NotNull VirtualFile file2, @NotNull Project project) {
        GradleProjectInfo projectInfo = GradleProjectInfo.getInstance(project);
        GradleAndroidModel androidModel = GradleProjectSystemUtil.findAndroidModelInModule(project, file2);
        return AndroidGeneratedSourcesFilter.isGeneratedSource(file2, project, projectInfo, androidModel);
    }

    @VisibleForTesting
    public static boolean isGeneratedSource(@NotNull VirtualFile file2, @NotNull Project project, GradleProjectInfo projectInfo, GradleAndroidModel androidModel) {
        if (androidModel != null) {
            return VfsUtilCore.isAncestor((File)androidModel.getAndroidProject().getBuildFolder(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)file2), (boolean)false);
        }
        VirtualFile rootFolder = project.getBaseDir();
        if (rootFolder == null) {
            return false;
        }
        VirtualFile buildFolder = rootFolder.findChild("build");
        boolean isBuiltWithGradle = projectInfo.isBuildWithGradle();
        return buildFolder != null && isBuiltWithGradle && VfsUtilCore.isAncestor((VirtualFile)buildFolder, (VirtualFile)file2, (boolean)false);
    }
}

