/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.repositories.search;

import com.android.ide.common.gradle.Version;
import com.android.tools.idea.gradle.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.repositories.search.FoundArtifact;
import com.android.tools.idea.gradle.repositories.search.LocalMavenRepository;
import com.android.tools.idea.gradle.repositories.search.LocalMavenRepositoryKt;
import com.android.tools.idea.gradle.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.repositories.search.SearchResult;
import com.google.wireless.android.sdk.stats.PSDEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Url;
import java.io.File;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0013\u0010\u0017\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/gradle/repositories/search/LocalMavenRepository;", "Lcom/android/tools/idea/gradle/repositories/search/ArtifactRepository;", "rootLocation", "Ljava/io/File;", "name", "", "(Ljava/io/File;Ljava/lang/String;)V", "isRemote", "", "()Z", "getName", "()Ljava/lang/String;", "getRootLocation", "()Ljava/io/File;", "rootLocationPath", "Ljava/nio/file/Path;", "component1", "component2", "copy", "doSearch", "Lcom/android/tools/idea/gradle/repositories/search/SearchResult;", "request", "Lcom/android/tools/idea/gradle/repositories/search/SearchRequest;", "equals", "other", "", "hashCode", "", "toString", "Companion", "Match", "intellij.android.projectSystem.gradle.repositorySearch"})
public final class LocalMavenRepository
extends ArtifactRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File rootLocation;
    @NotNull
    private final String name;
    @NotNull
    private final Path rootLocationPath;
    private final boolean isRemote;

    public LocalMavenRepository(@NotNull File rootLocation, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)rootLocation, (String)"rootLocation");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        super(PSDEvent.PSDRepositoryUsage.PSDRepository.PROJECT_STRUCTURE_DIALOG_REPOSITORY_LOCAL);
        this.rootLocation = rootLocation;
        this.name = name2;
        Path path2 = this.rootLocation.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"rootLocation.toPath()");
        this.rootLocationPath = path2;
    }

    @NotNull
    public final File getRootLocation() {
        return this.rootLocation;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isRemote() {
        return this.isRemote;
    }

    @Override
    @NotNull
    protected SearchResult doSearch(@NotNull SearchRequest request2) {
        String string;
        String groupIdPredicate2;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        List foundArtifacts = new ArrayList();
        String string2 = request2.getQuery().getGroupId();
        if (string2 == null || (string2 = LocalMavenRepositoryKt.access$toWildcardMatchingPredicate(string2)) == null) {
            string2 = groupIdPredicate2 = (Function1)doSearch.groupIdPredicate.1.INSTANCE;
        }
        if ((string = request2.getQuery().getArtifactName()) == null || (string = LocalMavenRepositoryKt.access$toWildcardMatchingPredicate(string)) == null) {
            string = doSearch.artifactNamePredicate.1.INSTANCE;
        }
        String artifactNamePredicate2 = string;
        try {
            Files.walkFileTree(this.rootLocationPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this, (Function1<? super String, Boolean>)groupIdPredicate2, (Function1<? super String, Boolean>)artifactNamePredicate2, (List<FoundArtifact>)foundArtifacts){
                final /* synthetic */ LocalMavenRepository this$0;
                final /* synthetic */ Function1<String, Boolean> $groupIdPredicate;
                final /* synthetic */ Function1<String, Boolean> $artifactNamePredicate;
                final /* synthetic */ List<FoundArtifact> $foundArtifacts;
                {
                    this.this$0 = $receiver;
                    this.$groupIdPredicate = $groupIdPredicate;
                    this.$artifactNamePredicate = $artifactNamePredicate;
                    this.$foundArtifacts = $foundArtifacts;
                }

                /*
                 * Unable to fully structure code
                 */
                @NotNull
                public FileVisitResult preVisitDirectory(@NotNull Path dir, @NotNull BasicFileAttributes attrs) {
                    block6: {
                        block8: {
                            block7: {
                                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                                v0 = dir.toFile();
                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"dir.toFile()");
                                visitedDirFile = v0;
                                repositoryRelativeDirectory = FilesKt.relativeTo((File)visitedDirFile, (File)this.this$0.getRootLocation());
                                if (repositoryRelativeDirectory.getParentFile() == null) {
                                    return FileVisitResult.CONTINUE;
                                }
                                v1 = repositoryRelativeDirectory.getParentFile().getPath();
                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"repositoryRelativeDirectory.parentFile.path");
                                groupIdProbe = StringsKt.replace$default((String)v1, (char)File.separatorChar, (char)'.', (boolean)false, (int)4, null);
                                artifactNameProbe = visitedDirFile.getName();
                                if (!((Boolean)this.$groupIdPredicate.invoke((Object)groupIdProbe)).booleanValue()) break block6;
                                Intrinsics.checkNotNullExpressionValue((Object)artifactNameProbe, (String)"artifactNameProbe");
                                if (!((Boolean)this.$artifactNamePredicate.invoke((Object)artifactNameProbe)).booleanValue()) break block6;
                                var8_7 = visitedDirFile.listFiles();
                                if (var8_7 == null) break block7;
                                var9_8 = var8_7;
                                $i$f$mapNotNull = false;
                                var11_10 = $this$mapNotNull$iv;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$mapNotNullTo = false;
                                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                $i$f$forEach = false;
                                var17_16 = ((void)$this$forEach$iv$iv$iv).length;
                                for (var16_15 = 0; var16_15 < var17_16; ++var16_15) {
                                    element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[var16_15];
                                    $i$a$-forEach-ArraysKt___ArraysKt$mapNotNullTo$1$iv$iv = false;
                                    it = element$iv$iv;
                                    $i$a$-mapNotNull-LocalMavenRepository$doSearch$1$preVisitDirectory$versions$1 = false;
                                    versionProbe = it.getName();
                                    expectedPomFileName = artifactNameProbe + "-" + versionProbe + ".pom";
                                    if (!it.isDirectory()) ** GOTO lbl-1000
                                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                    if (FilesKt.resolve((File)it, (String)expectedPomFileName).isFile()) {
                                        Intrinsics.checkNotNullExpressionValue((Object)versionProbe, (String)"versionProbe");
                                        v2 = Version.Companion.parse(versionProbe);
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        v2 = null;
                                    }
                                    if (v2 == null) continue;
                                    it$iv$iv = v2;
                                    $i$a$-let-ArraysKt___ArraysKt$mapNotNullTo$1$1$iv$iv = false;
                                    destination$iv$iv.add(it$iv$iv);
                                }
                                v3 = (List)destination$iv$iv;
                                break block8;
                            }
                            v3 = v4 = null;
                        }
                        if (v3 == null) {
                            v4 = CollectionsKt.emptyList();
                        }
                        if (((Collection)(versions = v4)).isEmpty() == false) {
                            this.$foundArtifacts.add(new FoundArtifact(this.this$0.getName(), groupIdProbe, artifactNameProbe, versions));
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Throwable e) {
            String msg = "Failed to search local repository " + this.rootLocationPath;
            Logger.getInstance(LocalMavenRepository.class).warn(msg, e);
        }
        Comparator comparator2 = new Comparator(){

            public final int compare(T a, T b) {
                FoundArtifact it = (FoundArtifact)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getGroupId());
                it = (FoundArtifact)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getGroupId())));
            }
        };
        return new SearchResult(CollectionsKt.sortedWith((Iterable)foundArtifacts, (Comparator)new Comparator(comparator2){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    FoundArtifact it = (FoundArtifact)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (FoundArtifact)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
                return n;
            }
        }));
    }

    @NotNull
    public final File component1() {
        return this.rootLocation;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final LocalMavenRepository copy(@NotNull File rootLocation, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)rootLocation, (String)"rootLocation");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return new LocalMavenRepository(rootLocation, name2);
    }

    public static /* synthetic */ LocalMavenRepository copy$default(LocalMavenRepository localMavenRepository, File file2, String string, int n, Object object) {
        if ((n & 1) != 0) {
            file2 = localMavenRepository.rootLocation;
        }
        if ((n & 2) != 0) {
            string = localMavenRepository.name;
        }
        return localMavenRepository.copy(file2, string);
    }

    @NotNull
    public String toString() {
        return "LocalMavenRepository(rootLocation=" + this.rootLocation + ", name=" + this.name + ")";
    }

    public int hashCode() {
        int result2 = this.rootLocation.hashCode();
        result2 = result2 * 31 + this.name.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LocalMavenRepository)) {
            return false;
        }
        LocalMavenRepository localMavenRepository = (LocalMavenRepository)other;
        if (!Intrinsics.areEqual((Object)this.rootLocation, (Object)localMavenRepository.rootLocation)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.name, (Object)localMavenRepository.name);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/gradle/repositories/search/LocalMavenRepository$Companion;", "", "()V", "maybeCreateLocalMavenRepository", "Lcom/android/tools/idea/gradle/repositories/search/LocalMavenRepository;", "mavenRepositoryUrl", "", "mavenRepositoryName", "intellij.android.projectSystem.gradle.repositorySearch"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final LocalMavenRepository maybeCreateLocalMavenRepository(@NotNull String mavenRepositoryUrl, @NotNull String mavenRepositoryName) {
            Intrinsics.checkNotNullParameter((Object)mavenRepositoryUrl, (String)"mavenRepositoryUrl");
            Intrinsics.checkNotNullParameter((Object)mavenRepositoryName, (String)"mavenRepositoryName");
            Url url = LocalMavenRepositoryKt.access$parseToLocalFile(mavenRepositoryUrl, false);
            if (url == null && (url = LocalMavenRepositoryKt.access$parseToLocalFile(mavenRepositoryUrl, true)) == null) {
                return null;
            }
            Url parsedRepositoryUrl = url;
            String string = parsedRepositoryUrl.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parsedRepositoryUrl.path");
            String repositoryPath = string;
            File repositoryRootFile = new File(repositoryPath);
            if (repositoryRootFile.isAbsolute()) {
                return new LocalMavenRepository(repositoryRootFile, mavenRepositoryName);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\t\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\nJ\u000e\u0010\u000b\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\fJ\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/gradle/repositories/search/LocalMavenRepository$Match;", "", "artifactName", "", "groupId", "(Ljava/lang/String;Ljava/lang/String;)V", "getArtifactName$intellij_android_projectSystem_gradle_repositorySearch", "()Ljava/lang/String;", "getGroupId$intellij_android_projectSystem_gradle_repositorySearch", "component1", "component1$intellij_android_projectSystem_gradle_repositorySearch", "component2", "component2$intellij_android_projectSystem_gradle_repositorySearch", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.projectSystem.gradle.repositorySearch"})
    private static final class Match {
        @NotNull
        private final String artifactName;
        @NotNull
        private final String groupId;

        public Match(@NotNull String artifactName, @NotNull String groupId) {
            Intrinsics.checkNotNullParameter((Object)artifactName, (String)"artifactName");
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            this.artifactName = artifactName;
            this.groupId = groupId;
        }

        @NotNull
        public final String getArtifactName$intellij_android_projectSystem_gradle_repositorySearch() {
            return this.artifactName;
        }

        @NotNull
        public final String getGroupId$intellij_android_projectSystem_gradle_repositorySearch() {
            return this.groupId;
        }

        @NotNull
        public final String component1$intellij_android_projectSystem_gradle_repositorySearch() {
            return this.artifactName;
        }

        @NotNull
        public final String component2$intellij_android_projectSystem_gradle_repositorySearch() {
            return this.groupId;
        }

        @NotNull
        public final Match copy(@NotNull String artifactName, @NotNull String groupId) {
            Intrinsics.checkNotNullParameter((Object)artifactName, (String)"artifactName");
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            return new Match(artifactName, groupId);
        }

        public static /* synthetic */ Match copy$default(Match match2, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = match2.artifactName;
            }
            if ((n & 2) != 0) {
                string2 = match2.groupId;
            }
            return match2.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Match(artifactName=" + this.artifactName + ", groupId=" + this.groupId + ")";
        }

        public int hashCode() {
            int result2 = this.artifactName.hashCode();
            result2 = result2 * 31 + this.groupId.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Match)) {
                return false;
            }
            Match match2 = (Match)other;
            if (!Intrinsics.areEqual((Object)this.artifactName, (Object)match2.artifactName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.groupId, (Object)match2.groupId);
        }
    }
}

