/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.refactoring;

import com.android.tools.idea.gradle.dsl.api.GradleModelProvider;
import com.android.tools.idea.gradle.dsl.api.GradleVersionCatalogView;
import com.android.tools.idea.gradle.refactoring.VersionCatalogGoToDeclarationHandlerKt;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.toml.lang.psi.TomlArray;
import org.toml.lang.psi.TomlFile;
import org.toml.lang.psi.TomlKey;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlLiteral;
import org.toml.lang.psi.TomlTable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010\t\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0002J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u0004J\u001a\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\bH\u0002J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/gradle/refactoring/VersionCatalogGoToDeclarationHandler;", "Lcom/intellij/codeInsight/navigation/actions/GotoDeclarationHandlerBase;", "()V", "findCatalogKey", "Lcom/intellij/psi/PsiElement;", "tomlFile", "Lorg/toml/lang/psi/TomlFile;", "path", "", "findVersionCatalog", "element", "reference", "project", "Lcom/intellij/openapi/project/Project;", "getGotoDeclarationTarget", "sourceElement", "editor", "Lcom/intellij/openapi/editor/Editor;", "getWholeKey", "keysMatch", "", "s1", "s2", "normalize", "", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nVersionCatalogGoToDeclarationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionCatalogGoToDeclarationHandler.kt\ncom/android/tools/idea/gradle/refactoring/VersionCatalogGoToDeclarationHandler\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,226:1\n125#2:227\n1#3:228\n*S KotlinDebug\n*F\n+ 1 VersionCatalogGoToDeclarationHandler.kt\ncom/android/tools/idea/gradle/refactoring/VersionCatalogGoToDeclarationHandler\n*L\n72#1:227\n*E\n"})
public final class VersionCatalogGoToDeclarationHandler
extends GotoDeclarationHandlerBase {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public PsiElement getGotoDeclarationTarget(@Nullable PsiElement sourceElement, @Nullable Editor editor) {
        if (sourceElement == null) {
            return null;
        }
        PsiElement psiElement = sourceElement.getParent();
        if (psiElement == null) {
            return null;
        }
        PsiElement parent2 = psiElement;
        PsiElement psiElement2 = parent2.getParent();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement grandParent = psiElement2;
        if (grandParent instanceof KtDotQualifiedExpression) {
            String key = ((KtDotQualifiedExpression)grandParent).getText();
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            String string = StringsKt.substringBefore$default((String)key, (String)".", null, (int)2, null);
            Project project = sourceElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"sourceElement.project");
            TomlFile catalog = this.findVersionCatalog(string, project);
            if (catalog != null) {
                String string2 = ((KtDotQualifiedExpression)grandParent).getContainingFile().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"grandParent.containingFile.name");
                if (StringsKt.endsWith$default((String)string2, (String)".kts", (boolean)false, (int)2, null)) {
                    void $this$getParentOfType$iv;
                    PsiElement target2 = this.findCatalogKey(catalog, StringsKt.substringAfter$default((String)key, (String)".", null, (int)2, null));
                    if (target2 != null) {
                        return target2;
                    }
                    PsiElement psiElement3 = grandParent;
                    boolean strict$iv = true;
                    boolean $i$f$getParentOfType = false;
                    KtValueArgument ktValueArgument = (KtValueArgument)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtValueArgument.class, (boolean)strict$iv);
                    if (ktValueArgument == null) {
                        return null;
                    }
                    KtValueArgument argument = ktValueArgument;
                    String fullKey = argument.getText();
                    if (!Intrinsics.areEqual((Object)fullKey, (Object)key)) {
                        Intrinsics.checkNotNullExpressionValue((Object)fullKey, (String)"fullKey");
                        return this.findCatalogKey(catalog, StringsKt.substringAfter$default((String)fullKey, (String)".", null, (int)2, null));
                    }
                }
            }
            return null;
        }
        if (parent2 instanceof GrReferenceExpression) {
            String string = ((GrReferenceExpression)parent2).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parent.text");
            String string3 = StringsKt.substringBefore$default((String)string, (String)".", null, (int)2, null);
            Project project = ((GrReferenceExpression)parent2).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"parent.project");
            TomlFile catalog = this.findVersionCatalog(string3, project);
            if (catalog != null) {
                String string4 = grandParent.getContainingFile().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"grandParent.containingFile.name");
                if (StringsKt.endsWith$default((String)string4, (String)".gradle", (boolean)false, (int)2, null)) {
                    String key = ((GrReferenceExpression)parent2).getText();
                    if (key != null) {
                        PsiElement psiElement4;
                        PsiElement target2 = this.findCatalogKey(catalog, StringsKt.substringAfter$default((String)key, (String)".", null, (int)2, null));
                        if (target2 != null) {
                            PsiElement it = target2;
                            boolean bl = false;
                            return it;
                        }
                        String wholeKey = this.getWholeKey(sourceElement);
                        if (wholeKey != null && (psiElement4 = this.findCatalogKey(catalog, StringsKt.substringAfter$default((String)wholeKey, (String)".", null, (int)2, null))) != null) {
                            PsiElement it = psiElement4;
                            boolean bl = false;
                            return it;
                        }
                    }
                    return null;
                }
            }
        }
        if (parent2 instanceof TomlLiteral) {
            if (grandParent instanceof TomlArray) {
                PsiFile psiFile = ((TomlLiteral)parent2).getContainingFile();
                TomlFile tomlFile = psiFile instanceof TomlFile ? (TomlFile)psiFile : null;
                if (tomlFile == null) {
                    return null;
                }
                TomlFile file2 = tomlFile;
                String libraryVar = VersionCatalogGoToDeclarationHandlerKt.access$getString((TomlLiteral)parent2);
                return this.findCatalogKey(file2, libraryVar);
            }
            if (grandParent instanceof TomlKeyValue && Intrinsics.areEqual((Object)((TomlKeyValue)grandParent).getKey().getText(), (Object)"version.ref")) {
                String versionVar = VersionCatalogGoToDeclarationHandlerKt.access$getString((TomlLiteral)parent2);
                PsiFile psiFile = ((TomlLiteral)parent2).getContainingFile();
                TomlFile tomlFile = psiFile instanceof TomlFile ? (TomlFile)psiFile : null;
                if (tomlFile == null) {
                    return null;
                }
                TomlFile file3 = tomlFile;
                return this.findCatalogKey(file3, "versions." + versionVar);
            }
        }
        return null;
    }

    @Nullable
    public final String getWholeKey(@NotNull PsiElement sourceElement) {
        Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"sourceElement");
        PsiElement currElement = sourceElement;
        while (currElement.getParent() != null) {
            if (currElement.getParent() instanceof GrArgumentList || currElement.getParent() instanceof GrCommandArgumentList) {
                return currElement.getText();
            }
            Intrinsics.checkNotNullExpressionValue((Object)currElement.getParent(), (String)"currElement.parent");
        }
        return null;
    }

    private final PsiElement findCatalogKey(TomlFile tomlFile, String path2) {
        String section = null;
        String target2 = null;
        if (StringsKt.startsWith$default((String)path2, (String)"versions.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)path2, (String)"bundles.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)path2, (String)"plugins.", (boolean)false, (int)2, null)) {
            section = StringsKt.substringBefore$default((String)path2, (char)'.', null, (int)2, null);
            target2 = StringsKt.substringAfter$default((String)path2, (char)'.', null, (int)2, null);
        } else {
            section = "libraries";
            target2 = path2;
        }
        for (PsiElement sectionElement = tomlFile.getFirstChild(); sectionElement != null; sectionElement = sectionElement.getNextSibling()) {
            String keyText;
            if (!(sectionElement instanceof TomlTable)) continue;
            TomlKey tomlKey = ((TomlTable)sectionElement).getHeader().getKey();
            String string = keyText = tomlKey != null ? tomlKey.getText() : null;
            if (this.keysMatch(keyText, section)) {
                for (TomlKeyValue entry : ((TomlTable)sectionElement).getEntries()) {
                    String entryKeyText = entry.getKey().getText();
                    if (!this.keysMatch(entryKeyText, target2)) continue;
                    return (PsiElement)entry;
                }
                continue;
            }
            if (!this.keysMatch(keyText, target2)) continue;
            return sectionElement;
        }
        return null;
    }

    private final boolean keysMatch(String s1, String s2) {
        if (s1 == null) {
            return false;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        int n = s1.length();
        for (int i = 0; i < n; ++i) {
            if (this.normalize(s1.charAt(i)) == this.normalize(s2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private final char normalize(char $this$normalize) {
        if ($this$normalize == '-' || $this$normalize == '_') {
            return '.';
        }
        return $this$normalize;
    }

    private final TomlFile findVersionCatalog(String reference, Project project) {
        GradleVersionCatalogView gradleVersionCatalogView = GradleModelProvider.getInstance().getVersionCatalogView(project);
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersionCatalogView, (String)"getInstance().getVersionCatalogView(project)");
        GradleVersionCatalogView view = gradleVersionCatalogView;
        VirtualFile virtualFile = view.getCatalogToFileMap().get(reference);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file2 = virtualFile;
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
        if (psiFile instanceof TomlFile) {
            return (TomlFile)psiFile;
        }
        return null;
    }

    private final TomlFile findVersionCatalog(PsiElement element2) {
        PsiElement psiElement = element2;
        if (psiElement == null || (psiElement = psiElement.getProject()) == null) {
            return null;
        }
        PsiElement project = psiElement;
        String string = element2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
        return this.findVersionCatalog(string, (Project)project);
    }
}

