/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.upgrade;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeComponentRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeRefactoringProcessorWithCompileRuntimeSpecialCaseDialog;
import com.android.tools.idea.gradle.project.upgrade.AssistantInvoker;
import com.android.tools.idea.gradle.project.upgrade.AssistantInvokerImpl;
import com.android.tools.idea.gradle.project.upgrade.AssistantInvokerImplKt;
import com.android.tools.idea.gradle.project.upgrade.CompileRuntimeConfigurationRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.GradlePluginUpgrade;
import com.android.tools.idea.gradle.project.upgrade.ProjectUpgradeNotification;
import com.android.tools.idea.gradle.project.upgrade.ProjectUpgradeNotificationKt;
import com.android.tools.idea.gradle.project.upgrade.Recommendation;
import com.android.tools.idea.gradle.project.upgrade.WrappedPsiElement;
import com.android.tools.idea.gradle.repositories.IdeGoogleMavenRepository;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0017J,\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00140\u0013H\u0007\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/gradle/project/upgrade/AssistantInvokerImpl;", "Lcom/android/tools/idea/gradle/project/upgrade/AssistantInvoker;", "()V", "displayForceUpdatesDisabledMessage", "", "project", "Lcom/intellij/openapi/project/Project;", "expireProjectUpgradeNotifications", "maybeRecommendPluginUpgrade", "info", "Lcom/android/tools/idea/gradle/plugin/AndroidPluginInfo;", "performDeprecatedConfigurationsUpgrade", "element", "Lcom/intellij/psi/PsiElement;", "showAndGetDeprecatedConfigurationsUpgradeDialog", "", "processor", "Lcom/android/tools/idea/gradle/project/upgrade/AgpUpgradeRefactoringProcessor;", "dialogFactory", "Lkotlin/Function1;", "Lcom/android/tools/idea/gradle/project/upgrade/AgpUpgradeRefactoringProcessorWithCompileRuntimeSpecialCaseDialog;", "intellij.android.projectSystem.gradle.upgrade"})
@SourceDebugExtension(value={"SMAP\nAssistantInvokerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssistantInvokerImpl.kt\ncom/android/tools/idea/gradle/project/upgrade/AssistantInvokerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,99:1\n1#2:100\n13543#3,2:101\n*S KotlinDebug\n*F\n+ 1 AssistantInvokerImpl.kt\ncom/android/tools/idea/gradle/project/upgrade/AssistantInvokerImpl\n*L\n88#1:101,2\n*E\n"})
public final class AssistantInvokerImpl
implements AssistantInvoker {
    @Override
    @Slow
    public void performDeprecatedConfigurationsUpgrade(@NotNull Project project, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        String string = LatestKnownPluginVersionProvider.INSTANCE.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"INSTANCE.get()");
        AgpVersion recommended = AgpVersion.Companion.parse(string);
        AndroidPluginInfo androidPluginInfo = AndroidPluginInfo.find(project);
        if (androidPluginInfo == null || (androidPluginInfo = androidPluginInfo.getPluginVersion()) == null) {
            androidPluginInfo = recommended;
        }
        Intrinsics.checkNotNullExpressionValue((Object)androidPluginInfo, (String)"AndroidPluginInfo.find(p\u2026ginVersion ?: recommended");
        AndroidPluginInfo current = androidPluginInfo;
        AgpUpgradeRefactoringProcessor processor = new AgpUpgradeRefactoringProcessor(project, (AgpVersion)current, recommended);
        boolean runProcessor2 = this.showAndGetDeprecatedConfigurationsUpgradeDialog(processor, element2, (Function1<? super AgpUpgradeRefactoringProcessor, ? extends AgpUpgradeRefactoringProcessorWithCompileRuntimeSpecialCaseDialog>)((Function1)performDeprecatedConfigurationsUpgrade.runProcessor.1.INSTANCE));
        if (runProcessor2) {
            DumbService.getInstance((Project)project).smartInvokeLater(new Runnable(processor){
                final /* synthetic */ AgpUpgradeRefactoringProcessor $processor;
                {
                    this.$processor = $processor;
                }

                public final void run() {
                    this.$processor.run();
                }
            });
        }
    }

    @Slow
    @VisibleForTesting
    public final boolean showAndGetDeprecatedConfigurationsUpgradeDialog(@NotNull AgpUpgradeRefactoringProcessor processor, @NotNull PsiElement element2, @NotNull Function1<? super AgpUpgradeRefactoringProcessor, ? extends AgpUpgradeRefactoringProcessorWithCompileRuntimeSpecialCaseDialog> dialogFactory) {
        CompileRuntimeConfigurationRefactoringProcessor compileRuntimeProcessor;
        block2: {
            CompileRuntimeConfigurationRefactoringProcessor compileRuntimeConfigurationRefactoringProcessor;
            Intrinsics.checkNotNullParameter((Object)((Object)processor), (String)"processor");
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter(dialogFactory, (String)"dialogFactory");
            for (AgpUpgradeComponentRefactoringProcessor it : (Iterable)processor.getComponentRefactoringProcessors()) {
                boolean bl = false;
                CompileRuntimeConfigurationRefactoringProcessor compileRuntimeConfigurationRefactoringProcessor2 = it instanceof CompileRuntimeConfigurationRefactoringProcessor ? (CompileRuntimeConfigurationRefactoringProcessor)it : null;
                if (compileRuntimeConfigurationRefactoringProcessor2 == null) continue;
                compileRuntimeConfigurationRefactoringProcessor = compileRuntimeConfigurationRefactoringProcessor2;
                break block2;
            }
            compileRuntimeConfigurationRefactoringProcessor = compileRuntimeProcessor = null;
        }
        if (compileRuntimeProcessor == null) {
            AssistantInvokerImplKt.access$getLOG$p().error("no CompileRuntimeConfiguration processor found in AGP Upgrade Processor");
        }
        processor.setCommandName("Replace Deprecated Configurations");
        CompileRuntimeConfigurationRefactoringProcessor compileRuntimeConfigurationRefactoringProcessor = compileRuntimeProcessor;
        Intrinsics.checkNotNull(compileRuntimeConfigurationRefactoringProcessor);
        WrappedPsiElement wrappedElement = new WrappedPsiElement(element2, compileRuntimeConfigurationRefactoringProcessor, null, "Upgrading deprecated configurations");
        processor.getTargets().add(wrappedElement);
        processor.ensureParsedModels();
        boolean runProcessor2 = (Boolean)ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.NON_MODAL, (Function0)((Function0)new Function0<Boolean>(dialogFactory, processor){
            final /* synthetic */ Function1<AgpUpgradeRefactoringProcessor, AgpUpgradeRefactoringProcessorWithCompileRuntimeSpecialCaseDialog> $dialogFactory;
            final /* synthetic */ AgpUpgradeRefactoringProcessor $processor;
            {
                this.$dialogFactory = $dialogFactory;
                this.$processor = $processor;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                AgpUpgradeRefactoringProcessorWithCompileRuntimeSpecialCaseDialog dialog2 = (AgpUpgradeRefactoringProcessorWithCompileRuntimeSpecialCaseDialog)((Object)this.$dialogFactory.invoke((Object)((Object)this.$processor)));
                return dialog2.showAndGet();
            }
        }));
        return runProcessor2;
    }

    @Override
    public void maybeRecommendPluginUpgrade(@NotNull Project project, @NotNull AndroidPluginInfo info2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
            AgpVersion agpVersion = info2.getPluginVersion();
            if (agpVersion == null) break block0;
            AgpVersion currentAgpVersion = agpVersion;
            boolean bl = false;
            String string = LatestKnownPluginVersionProvider.INSTANCE.get();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"INSTANCE.get()");
            AgpVersion latestKnown = AgpVersion.Companion.parse(string);
            FutureUtils.executeOnPooledThread((Function0)((Function0)new Function0<Unit>(project, currentAgpVersion, latestKnown){
                final /* synthetic */ Project $project;
                final /* synthetic */ AgpVersion $currentAgpVersion;
                final /* synthetic */ AgpVersion $latestKnown;
                {
                    this.$project = $project;
                    this.$currentAgpVersion = $currentAgpVersion;
                    this.$latestKnown = $latestKnown;
                    super(0);
                }

                public final void invoke() {
                    Set published = IdeGoogleMavenRepository.INSTANCE.getAgpVersions();
                    AgpVersion agpVersion = this.$currentAgpVersion;
                    Intrinsics.checkNotNullExpressionValue((Object)agpVersion, (String)"currentAgpVersion");
                    Recommendation recommendation = GradlePluginUpgrade.shouldRecommendPluginUpgrade(this.$project, agpVersion, this.$latestKnown, published);
                    if (recommendation.getUpgrade()) {
                        AgpVersion agpVersion2 = this.$currentAgpVersion;
                        Intrinsics.checkNotNullExpressionValue((Object)agpVersion2, (String)"currentAgpVersion");
                        GradlePluginUpgrade.recommendPluginUpgrade(this.$project, agpVersion2, recommendation.getStrongly());
                    }
                }
            }));
        }
    }

    @Override
    public void expireProjectUpgradeNotifications(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Notification[] notificationArray = NotificationsManager.getNotificationsManager().getNotificationsOfType(ProjectUpgradeNotification.class, project);
        Intrinsics.checkNotNullExpressionValue((Object)notificationArray, (String)"getNotificationsManager(\u2026ion::class.java, project)");
        Object[] $this$forEach$iv = notificationArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProjectUpgradeNotification it = (ProjectUpgradeNotification)((Object)element$iv);
            boolean bl = false;
            it.expire(false);
        }
    }

    @Override
    public void displayForceUpdatesDisabledMessage(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String msg = "Forced upgrades are disabled, errors seen may be due to incompatibilities between the Android Gradle Plugin and the version of Android Studio.\nTo re-enable forced updates please go to 'Tools > Internal Actions > Edit Studio Flags' and set '" + StudioFlags.DISABLE_FORCED_UPGRADES.getDisplayName() + "' to 'Off'.";
        NotificationGroup notificationGroup2 = ProjectUpgradeNotificationKt.getAGP_UPGRADE_NOTIFICATION_GROUP();
        MessageType messageType = MessageType.WARNING;
        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"WARNING");
        Notification notification = notificationGroup2.createNotification(msg, messageType);
        notification.notify(project);
    }
}

