/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.upgrade;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.project.sync.hyperlink.SearchInBuildFilesHyperlink;
import com.android.tools.idea.gradle.project.upgrade.AgpVersionRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.AndroidPluginVersionUpdater;
import com.android.tools.idea.gradle.project.upgrade.GMavenRepositoryRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.GradleVersionRefactoringProcessor;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serviceContainer.NonInjectable;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPluginVersionUpdaterImpl
implements AndroidPluginVersionUpdater {
    @NotNull
    private final Project myProject;
    @NotNull
    private final TextSearch myTextSearch;

    @NotNull
    public static AndroidPluginVersionUpdater getInstance(@NotNull Project project) {
        return (AndroidPluginVersionUpdater)project.getService(AndroidPluginVersionUpdater.class);
    }

    public AndroidPluginVersionUpdaterImpl(@NotNull Project project) {
        this(project, new TextSearch(project));
    }

    @NonInjectable
    @VisibleForTesting
    AndroidPluginVersionUpdaterImpl(@NotNull Project project, @NotNull TextSearch textSearch) {
        this.myProject = project;
        this.myTextSearch = textSearch;
    }

    @Override
    public boolean updatePluginVersion(AgpVersion pluginVersion, @Nullable GradleVersion gradleVersion2) {
        AndroidPluginVersionUpdater.UpdateResult result2 = this.updatePluginVersion(pluginVersion, gradleVersion2, null);
        return result2.isPluginVersionUpdated() || result2.isGradleVersionUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AndroidPluginVersionUpdater.UpdateResult updatePluginVersion(@NotNull AgpVersion pluginVersion, @Nullable GradleVersion gradleVersion2, @Nullable AgpVersion oldPluginVersion) {
        String msg;
        AndroidPluginVersionUpdater.UpdateResult result2 = new AndroidPluginVersionUpdater.UpdateResult();
        Runnable updaterRunnable = () -> {
            this.updatePluginVersionWithResult(pluginVersion, gradleVersion2, oldPluginVersion, result2);
            AndroidPluginVersionUpdater.UpdateResult updateResult = result2;
            synchronized (updateResult) {
                result2.complete = true;
                result2.notifyAll();
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            updaterRunnable.run();
        } else {
            DumbService.getInstance((Project)this.myProject).smartInvokeLater(updaterRunnable);
            try {
                AndroidPluginVersionUpdater.UpdateResult updateResult = result2;
                synchronized (updateResult) {
                    while (!result2.complete) {
                        result2.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        Throwable pluginVersionUpdateError = result2.getPluginVersionUpdateError();
        Throwable gradleVersionUpdateError = result2.getGradleVersionUpdateError();
        if (pluginVersionUpdateError != null) {
            msg = String.format("Failed to update Android plugin to version '%1$s'", pluginVersion);
            AndroidPluginVersionUpdaterImpl.logUpdateError(msg, pluginVersionUpdateError);
        }
        if (gradleVersionUpdateError != null) {
            msg = String.format("Failed to update Gradle to version '%1$s'", gradleVersion2);
            AndroidPluginVersionUpdaterImpl.logUpdateError(msg, gradleVersionUpdateError);
        }
        if (result2.getPluginVersionUpdateError() != null) {
            this.myTextSearch.execute();
        }
        return result2;
    }

    private void updatePluginVersionWithResult(@NotNull AgpVersion pluginVersion, @Nullable GradleVersion gradleVersion2, @Nullable AgpVersion oldPluginVersion, AndroidPluginVersionUpdater.UpdateResult result2) {
        if (oldPluginVersion == null) {
            oldPluginVersion = new AgpVersion(1, 0, 0);
        }
        AgpVersionRefactoringProcessor rp1 = new AgpVersionRefactoringProcessor(this.myProject, oldPluginVersion, pluginVersion);
        GMavenRepositoryRefactoringProcessor rp2 = new GMavenRepositoryRefactoringProcessor(this.myProject, oldPluginVersion, pluginVersion);
        try {
            rp1.run();
            if (!oldPluginVersion.isAtLeast(3, 0, 0)) {
                rp2.run();
            }
            if (rp1.getFoundUsages()) {
                result2.pluginVersionUpdated();
            }
        }
        catch (Throwable e) {
            result2.setPluginVersionUpdateError(e);
        }
        if (result2.isPluginVersionUpdated() && gradleVersion2 != null) {
            GradleVersionRefactoringProcessor rp3 = new GradleVersionRefactoringProcessor(this.myProject, oldPluginVersion, pluginVersion);
            try {
                rp3.run();
                result2.gradleVersionUpdated();
            }
            catch (Throwable e) {
                result2.setGradleVersionUpdateError(e);
            }
        }
    }

    private static void logUpdateError(@NotNull String msg, @NotNull Throwable error) {
        String cause = error.getMessage();
        if (StringUtil.isNotEmpty((String)cause)) {
            msg = (String)msg + ": " + cause;
        }
        Logger.getInstance(AndroidPluginVersionUpdater.class).warn((String)msg);
    }

    @VisibleForTesting
    static class TextSearch {
        @NotNull
        private final Project myProject;

        TextSearch(@NotNull Project project) {
            this.myProject = project;
        }

        void execute() {
            String msg = "Failed to update the version of the Android Gradle plugin.\n\nPlease click 'OK' to perform a textual search and then update the build files manually.";
            ApplicationManager.getApplication().invokeLater(() -> {
                Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)"Unexpected Error");
                String textToFind = "com.android.tools.build:gradle";
                SearchInBuildFilesHyperlink.searchInBuildFiles(textToFind, this.myProject);
            });
        }
    }
}

