/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.upgrade;

import com.android.tools.adtui.HtmlLabel;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeComponentRefactoringProcessor;
import com.android.tools.idea.gradle.project.upgrade.AgpUpgradeRefactoringProcessor;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBDimension;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AgpUpgradeRefactoringProcessorCannotUpgradeDialog
extends DialogWrapper {
    private JEditorPane myEditorPane;
    private JPanel myPanel;

    AgpUpgradeRefactoringProcessorCannotUpgradeDialog(@NotNull AgpUpgradeRefactoringProcessor processor) {
        super(processor.getProject());
        this.$$$setupUI$$$();
        this.setTitle("Android Gradle Plugin Upgrade Assistant");
        this.init();
        HtmlLabel.setUpAsHtmlLabel((JEditorPane)this.myEditorPane);
        this.myEditorPane.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                BrowserUtil.browse((URL)e.getURL());
            }
        });
        StringBuilder sb = new StringBuilder();
        sb.append("<p><b>Incompatibility between Android Studio and Android Gradle plugin</b></p>");
        sb.append("<p>This project is using Android Gradle plugin version ").append(processor.getCurrent()).append(", which is incompatible with this version of Android Studio.</p>");
        List<AgpUpgradeComponentRefactoringProcessor> blockedComponents = processor.getComponentRefactoringProcessors().stream().filter(c -> c.isEnabled() && c.isBlocked()).collect(Collectors.toList());
        sb.append("<br/><p>The Upgrade Assistant failed to upgrade this project, finding no way of performing the following command").append(blockedComponents.size() == 1 ? "" : "s").append(":</p>");
        sb.append("<ul>");
        blockedComponents.forEach(c -> {
            sb.append("<li>").append(c.getCommandName()).append("<ul>");
            c.blockProcessorReasons().forEach(r -> {
                sb.append("<li>").append(r.getShortDescription());
                String description2 = r.getDescription();
                if (description2 != null) {
                    sb.append("<br>").append(description2);
                }
            });
            sb.append("</ul>");
        });
        sb.append("</ul>");
        this.myEditorPane.setText(sb.toString());
        this.myPanel.setPreferredSize((Dimension)new JBDimension(500, -1));
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction()};
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JEditorPane jEditorPane;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myEditorPane = jEditorPane = new JEditorPane();
        jPanel.add((Component)jEditorPane, new GridConstraints(0, 0, 1, 1, 0, 3, 6, 6, null, new Dimension(150, 50), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

