/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.validation.android;

import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.project.sync.validation.android.AndroidProjectValidationStrategy;
import com.android.tools.idea.gradle.project.sync.validation.android.EncodingValidationStrategy;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public abstract class AndroidModuleValidator {
    public abstract void validate(@NotNull Module var1, @NotNull GradleAndroidModel var2);

    public abstract void fixAndReportFoundIssues();

    @VisibleForTesting
    static class AndroidModuleValidatorImpl
    extends AndroidModuleValidator {
        @NotNull
        private final AndroidProjectValidationStrategy[] myStrategies;

        AndroidModuleValidatorImpl(@NotNull Project project) {
            this(new EncodingValidationStrategy(project));
        }

        @VisibleForTesting
        AndroidModuleValidatorImpl(AndroidProjectValidationStrategy ... strategies) {
            this.myStrategies = strategies;
        }

        @Override
        public void validate(@NotNull Module module2, @NotNull GradleAndroidModel androidModel) {
            for (AndroidProjectValidationStrategy strategy : this.myStrategies) {
                strategy.validate(module2, androidModel);
            }
        }

        @Override
        public void fixAndReportFoundIssues() {
            for (AndroidProjectValidationStrategy strategy : this.myStrategies) {
                strategy.fixAndReportFoundIssues();
            }
        }

        @VisibleForTesting
        @NotNull
        AndroidProjectValidationStrategy[] getStrategies() {
            return this.myStrategies;
        }
    }

    public static class Factory {
        @NotNull
        public AndroidModuleValidator create(@NotNull Project project) {
            return new AndroidModuleValidatorImpl(project);
        }
    }
}

