/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.cleanup;

import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.startup.ExternalAnnotationsSupport;
import com.android.tools.sdk.AndroidSdkData;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdksCleanupUtil {
    public static void updateSdkIfNeeded(@NotNull Sdk sdk, @NotNull AndroidSdks androidSdks) {
        IAndroidTarget target2 = SdksCleanupUtil.getTarget(sdk);
        if (target2 != null) {
            SdksCleanupUtil.updateSdkIfNeeded(sdk, androidSdks, target2);
        }
    }

    @VisibleForTesting
    static void updateSdkIfNeeded(@NotNull Sdk sdk, @NotNull AndroidSdks androidSdks, @NotNull IAndroidTarget target2) {
        List<OrderRoot> expectedRoots = androidSdks.getLibraryRootsForTarget(target2, FilePaths.stringToFile((String)sdk.getHomePath()), true);
        HashMap urlsByRootType = new HashMap();
        for (OrderRoot root : expectedRoots) {
            urlsByRootType.computeIfAbsent(root.getType(), k -> new HashSet()).add(root.getFile().getUrl());
        }
        for (OrderRootType type : Arrays.asList(OrderRootType.CLASSES, OrderRootType.SOURCES, JavadocOrderRootType.getInstance())) {
            List<String> urlInSdk = Arrays.asList(sdk.getRootProvider().getUrls(type));
            Set expectedUrls = urlsByRootType.getOrDefault(type, Collections.emptySet());
            if (urlInSdk.size() == expectedUrls.size() && !urlInSdk.stream().anyMatch(url -> !expectedUrls.contains(url))) continue;
            SdksCleanupUtil.updateSdk(sdk, expectedRoots);
            return;
        }
    }

    @Nullable
    private static IAndroidTarget getTarget(@NotNull Sdk sdk) {
        AndroidSdkAdditionalData additionalData = AndroidSdkAdditionalData.from(sdk);
        AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdk);
        if (additionalData == null || sdkData == null) {
            return null;
        }
        IAndroidTarget target2 = additionalData.getBuildTarget(sdkData);
        if (target2 == null) {
            AndroidSdkHandler sdkHandler = sdkData.getSdkHandler();
            StudioLoggerProgressIndicator logger2 = new StudioLoggerProgressIndicator(SdksCleanupUtil.class);
            sdkHandler.getSdkManager((ProgressIndicator)logger2).loadSynchronously(0L, (ProgressIndicator)logger2, null, null);
            target2 = sdkHandler.getAndroidTargetManager((ProgressIndicator)logger2).getTargetFromHashString(additionalData.getBuildTargetHashString(), (ProgressIndicator)logger2);
        }
        return target2;
    }

    private static void updateSdk(@NotNull Sdk sdk, @NotNull List<OrderRoot> expectedRoots) {
        SdkModificator sdkModificator = sdk.getSdkModificator();
        sdkModificator.removeAllRoots();
        for (OrderRoot orderRoot : expectedRoots) {
            sdkModificator.addRoot(orderRoot.getFile(), orderRoot.getType());
        }
        ExternalAnnotationsSupport.attachJdkAnnotations(sdkModificator);
        ApplicationManager.getApplication().invokeAndWait(() -> ((SdkModificator)sdkModificator).commitChanges());
    }
}

