/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.cleanup;

import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallPlatformHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectCleanupStep;
import com.android.tools.idea.gradle.project.sync.setup.post.cleanup.SdksCleanupUtil;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.sdk.AndroidSdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdksCleanupStep
extends ProjectCleanupStep {
    @NotNull
    private final AndroidSdks myAndroidSdks;

    public SdksCleanupStep() {
        this.myAndroidSdks = AndroidSdks.getInstance();
    }

    public SdksCleanupStep(@NotNull AndroidSdks androidSdks) {
        this.myAndroidSdks = androidSdks;
    }

    @Override
    public void cleanUpProject(@NotNull Project project, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider, @Nullable ProgressIndicator indicator) {
        HashSet<Sdk> fixedSdks = new HashSet<Sdk>();
        HashSet<Sdk> invalidSdks = new HashSet<Sdk>();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module2 : moduleManager.getModules()) {
            this.cleanUpSdk(module2, fixedSdks, invalidSdks);
        }
        if (!invalidSdks.isEmpty()) {
            this.reinstallMissingPlatforms(invalidSdks, project);
        }
    }

    @VisibleForTesting
    void cleanUpSdk(@NotNull Module module2, @NotNull Set<Sdk> fixedSdks, @NotNull Set<Sdk> invalidSdks) {
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module2);
        if (androidFacet == null) {
            return;
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module2).getSdk();
        if (sdk == null || invalidSdks.contains(sdk) || fixedSdks.contains(sdk)) {
            return;
        }
        SdksCleanupUtil.updateSdkIfNeeded(sdk, this.myAndroidSdks);
        fixedSdks.add(sdk);
        if (this.isMissingAndroidLibrary(sdk)) {
            invalidSdks.add(sdk);
        }
    }

    private boolean isMissingAndroidLibrary(@NotNull Sdk sdk) {
        if (this.myAndroidSdks.isAndroidSdk(sdk)) {
            for (VirtualFile library : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                if (!library.getName().equals("android.jar") || !library.exists()) continue;
                return false;
            }
        }
        return true;
    }

    private void reinstallMissingPlatforms(@NotNull Set<Sdk> invalidSdks, @NotNull Project project) {
        ArrayList<AndroidVersion> versionsToInstall = new ArrayList<AndroidVersion>();
        ArrayList<CallSite> missingPlatforms = new ArrayList<CallSite>();
        for (Sdk sdk : invalidSdks) {
            String platform;
            AndroidSdkAdditionalData additionalData = AndroidSdkAdditionalData.from(sdk);
            if (additionalData == null || (platform = additionalData.getBuildTargetHashString()) == null) continue;
            missingPlatforms.add((CallSite)((Object)("'" + platform + "'")));
            AndroidVersion version2 = AndroidTargetHash.getPlatformVersion((String)platform);
            if (version2 == null) continue;
            versionsToInstall.add(version2);
        }
        if (!versionsToInstall.isEmpty()) {
            String text2 = "Missing Android platform(s) detected: " + Joiner.on((String)", ").join(missingPlatforms);
            SyncMessage msg = new SyncMessage("Gradle Sync Issues", MessageType.ERROR, text2);
            msg.add(new InstallPlatformHyperlink(versionsToInstall));
            GradleSyncMessages.getInstance(project).report(msg);
        }
    }
}

