/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gradle.model.IdeAndroidProject;
import com.android.tools.idea.gradle.model.IdeAndroidProjectType;
import com.android.tools.idea.gradle.model.IdeDependencies;
import com.android.tools.idea.gradle.model.IdeVariant;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncListenerWithRoot;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectStructureUsageTracker;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.android.tools.idea.model.AndroidManifestIndexQueryUtils;
import com.android.tools.idea.model.UsedFeatureRawText;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.gradle.GradleProjectPathKt;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleAndroidModule;
import com.google.wireless.android.sdk.stats.GradleBuildDetails;
import com.google.wireless.android.sdk.stats.GradleLibrary;
import com.google.wireless.android.sdk.stats.GradleModule;
import com.google.wireless.android.sdk.stats.GradleNativeAndroidModule;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManagerEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001d\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00032\u000b\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/gradle/project/sync/setup/post/ProjectStructureUsageTracker;", "Lcom/android/tools/idea/gradle/project/sync/GradleSyncListenerWithRoot;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "doTrackProjectStructure", "", "isWatchHardwareRequired", "", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "syncSucceeded", "project", "rootProjectPath", "", "Lorg/jetbrains/annotations/SystemIndependent;", "trackProjectStructure", "Companion", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nProjectStructureUsageTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectStructureUsageTracker.kt\ncom/android/tools/idea/gradle/project/sync/setup/post/ProjectStructureUsageTracker\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,263:1\n3792#2:264\n4307#2,2:265\n1291#3,2:267\n*S KotlinDebug\n*F\n+ 1 ProjectStructureUsageTracker.kt\ncom/android/tools/idea/gradle/project/sync/setup/post/ProjectStructureUsageTracker\n*L\n81#1:264\n81#1:265,2\n91#1:267,2\n*E\n"})
public final class ProjectStructureUsageTracker
implements GradleSyncListenerWithRoot {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private static final Logger LOG;

    public ProjectStructureUsageTracker(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
    }

    @Override
    public void syncSucceeded(@NotNull Project project, @NotNull String rootProjectPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)rootProjectPath, (String)"rootProjectPath");
        this.trackProjectStructure();
    }

    private final void trackProjectStructure() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.doTrackProjectStructure();
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this){
            final /* synthetic */ ProjectStructureUsageTracker this$0;
            {
                this.this$0 = $receiver;
            }

            public final void run() {
                try {
                    ProjectStructureUsageTracker.access$doTrackProjectStructure(this.this$0);
                }
                catch (Throwable e) {
                    ProjectStructureUsageTracker.access$getLOG$cp().warn("Failed to track project structure", e);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void doTrackProjectStructure() {
        void $this$filterTo$iv$iv;
        Module[] $this$filter$iv = ModuleManager.Companion.getInstance(this.myProject).getModules();
        boolean $i$f$filter = false;
        Module[] moduleArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!(GradleProjectPathKt.getGradleProjectPath((Module)it) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allModules = (List)destination$iv$iv;
        GradleAndroidModel appModel = null;
        GradleAndroidModel libModel = null;
        int appCount = 0;
        int libCount = 0;
        List gradleLibraries = new ArrayList();
        for (AndroidFacet facet2 : ProjectSystemUtil.getAndroidFacets(this.myProject)) {
            GradleAndroidModel androidModel = GradleAndroidModel.Companion.get(facet2);
            if (androidModel == null) continue;
            switch (WhenMappings.$EnumSwitchMapping$0[androidModel.getAndroidProject().getProjectType().ordinal()]) {
                case 1: {
                    libModel = androidModel;
                    ++libCount;
                    break;
                }
                case 2: {
                    appModel = androidModel;
                    ++appCount;
                    GradleLibrary gradleLibrary = ProjectStructureUsageTracker.Companion.trackExternalDependenciesInAndroidApp(androidModel);
                    gradleLibraries.add(gradleLibrary);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                }
            }
        }
        GradleAndroidModel gradleAndroidModel2 = appModel;
        if (gradleAndroidModel2 == null && (gradleAndroidModel2 = libModel) == null) {
            return;
        }
        GradleAndroidModel model2 = gradleAndroidModel2;
        List gradleAndroidModules = new ArrayList();
        List gradleNativeAndroidModules = new ArrayList();
        String string = AnonymizerUtil.anonymizeUtf8((String)model2.getApplicationId());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"anonymizeUtf8(model.applicationId)");
        String appId = string;
        IdeAndroidProject androidProject = model2.getAndroidProject();
        GradleVersion gradleVersion2 = GradleVersions.getInstance().getGradleVersion(this.myProject);
        Intrinsics.checkNotNull((Object)gradleVersion2);
        String gradleVersionString = gradleVersion2.getVersion();
        if (gradleVersionString == null) {
            gradleVersionString = "0.0.0";
        }
        GradleModule gradleModule = GradleModule.newBuilder().setTotalModuleCount(ProjectStructureUsageTracker.doTrackProjectStructure$countHolderModules(allModules)).setAppModuleCount((long)appCount).setLibModuleCount((long)libCount).build();
        for (AndroidFacet facet3 : ProjectSystemUtil.getAndroidFacets(this.myProject)) {
            GradleAndroidModel androidModel = GradleAndroidModel.Companion.get(facet3);
            if (androidModel != null) {
                IdeAndroidProject moduleAndroidProject = androidModel.getAndroidProject();
                GradleAndroidModule.Builder androidModule = GradleAndroidModule.newBuilder();
                androidModule.setModuleName(AnonymizerUtil.anonymizeUtf8((String)facet3.getHolderModule().getName())).setSigningConfigCount((long)moduleAndroidProject.getSigningConfigs().size()).setIsLibrary(moduleAndroidProject.getProjectType() == IdeAndroidProjectType.PROJECT_TYPE_LIBRARY).setBuildTypeCount((long)androidModel.getBuildTypeNames().size()).setFlavorCount((long)androidModel.getProductFlavorNames().size()).setFlavorDimension((long)moduleAndroidProject.getFlavorDimensions().size());
                if (!androidModule.getIsLibrary() && this.isWatchHardwareRequired(facet3)) {
                    androidModule.setRequiredHardware("android.hardware.type.watch");
                }
                GradleAndroidModule gradleAndroidModule = androidModule.build();
                Intrinsics.checkNotNullExpressionValue((Object)gradleAndroidModule, (String)"androidModule.build()");
                gradleAndroidModules.add(gradleAndroidModule);
            }
            boolean shouldReportNative = false;
            Module module2 = facet3.getHolderModule();
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.holderModule");
            NdkModuleModel ndkModel = NdkModuleModel.Companion.get(module2);
            GradleNativeAndroidModule.NativeBuildSystemType buildSystemType = GradleNativeAndroidModule.NativeBuildSystemType.UNKNOWN_NATIVE_BUILD_SYSTEM_TYPE;
            String moduleName2 = "";
            if (ndkModel != null) {
                shouldReportNative = true;
                if (ndkModel.getFeatures().isBuildSystemNameSupported()) {
                    for (String buildSystem : ndkModel.getBuildSystems()) {
                        buildSystemType = Companion.stringToBuildSystemType(buildSystem);
                    }
                } else {
                    buildSystemType = GradleNativeAndroidModule.NativeBuildSystemType.GRADLE_EXPERIMENTAL;
                }
                String string2 = AnonymizerUtil.anonymizeUtf8((String)ndkModel.getModuleName());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"anonymizeUtf8(ndkModel.moduleName)");
                moduleName2 = string2;
            }
            if (!shouldReportNative) continue;
            GradleNativeAndroidModule.Builder nativeModule = GradleNativeAndroidModule.newBuilder();
            nativeModule.setModuleName(moduleName2).setBuildSystemType(buildSystemType);
            GradleNativeAndroidModule gradleNativeAndroidModule = nativeModule.build();
            Intrinsics.checkNotNullExpressionValue((Object)gradleNativeAndroidModule, (String)"nativeModule.build()");
            gradleNativeAndroidModules.add(gradleNativeAndroidModule);
        }
        GradleBuildDetails.Builder gradleBuild = GradleBuildDetails.newBuilder().setAppId(appId).setAndroidPluginVersion(androidProject.getAgpVersion()).setGradleVersion(gradleVersionString).addAllLibraries((Iterable)gradleLibraries).addModules(gradleModule).addAllAndroidModules((Iterable)gradleAndroidModules).addAllNativeAndroidModules((Iterable)gradleNativeAndroidModules).setModuleCount(ProjectStructureUsageTracker.doTrackProjectStructure$countHolderModules(allModules)).setLibCount(ProjectStructureUsageTracker.doTrackProjectStructure$countExternalLibraries(allModules));
        AndroidStudioEvent.Builder event2 = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.GRADLE).setKind(AndroidStudioEvent.EventKind.GRADLE_BUILD_DETAILS).setGradleBuildDetails(gradleBuild);
        Intrinsics.checkNotNullExpressionValue((Object)event2, (String)"event");
        UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(event2, this.myProject));
    }

    private final boolean isWatchHardwareRequired(AndroidFacet facet2) {
        try {
            Object object = DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(new Computable(facet2){
                final /* synthetic */ AndroidFacet $facet;
                {
                    this.$facet = $facet;
                }

                public final Boolean compute() {
                    Set<UsedFeatureRawText> usedFeatures = AndroidManifestIndexQueryUtils.queryUsedFeaturesFromManifestIndex(this.$facet);
                    return usedFeatures.contains(new UsedFeatureRawText("android.hardware.type.watch", null)) || usedFeatures.contains(new UsedFeatureRawText("android.hardware.type.watch", "true"));
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"facet: AndroidFacet): Bo\u2026_WATCH, \"true\")))\n      }");
            return (Boolean)object;
        }
        catch (Throwable e) {
            LOG.warn("Manifest Index could not be queried", e);
            return false;
        }
    }

    private static final long doTrackProjectStructure$countHolderModules(List<? extends Module> allModules) {
        return SequencesKt.count((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)allModules), (Function1)doTrackProjectStructure.countHolderModules.1.INSTANCE));
    }

    private static final long doTrackProjectStructure$countExternalLibraries(List<? extends Module> allModules) {
        HashSet<Library> allLibraries = new HashSet<Library>();
        Sequence $this$forEach$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)allModules), (Function1)doTrackProjectStructure.countExternalLibraries.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleRootManagerEx it = (ModuleRootManagerEx)element$iv;
            boolean bl = false;
            it.orderEntries().withoutSdk().withoutModuleSourceEntries().withoutDepModules().librariesOnly().forEachLibrary(new Processor(allLibraries){
                final /* synthetic */ HashSet<Library> $allLibraries;
                {
                    this.$allLibraries = $allLibraries;
                }

                public final boolean process(Library it) {
                    this.$allLibraries.add(it);
                    return true;
                }
            });
        }
        return allLibraries.size();
    }

    @VisibleForTesting
    @JvmStatic
    @NotNull
    public static final GradleNativeAndroidModule.NativeBuildSystemType stringToBuildSystemType(@NotNull String buildSystem) {
        return Companion.stringToBuildSystemType(buildSystem);
    }

    public static final /* synthetic */ void access$doTrackProjectStructure(ProjectStructureUsageTracker $this) {
        $this.doTrackProjectStructure();
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Logger logger2 = Logger.getInstance(ProjectStructureUsageTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(\n      Proje\u2026Tracker::class.java\n    )");
        LOG = logger2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/gradle/project/sync/setup/post/ProjectStructureUsageTracker$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "stringToBuildSystemType", "Lcom/google/wireless/android/sdk/stats/GradleNativeAndroidModule$NativeBuildSystemType;", "buildSystem", "", "trackExternalDependenciesInAndroidApp", "Lcom/google/wireless/android/sdk/stats/GradleLibrary;", "model", "Lcom/android/tools/idea/gradle/project/model/GradleAndroidModel;", "intellij.android.projectSystem.gradle"})
    @SourceDebugExtension(value={"SMAP\nProjectStructureUsageTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectStructureUsageTracker.kt\ncom/android/tools/idea/gradle/project/sync/setup/post/ProjectStructureUsageTracker$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,263:1\n1851#2,2:264\n*S KotlinDebug\n*F\n+ 1 ProjectStructureUsageTracker.kt\ncom/android/tools/idea/gradle/project/sync/setup/post/ProjectStructureUsageTracker$Companion\n*L\n247#1:264,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @JvmStatic
        @NotNull
        public final GradleNativeAndroidModule.NativeBuildSystemType stringToBuildSystemType(@NotNull String buildSystem) {
            Intrinsics.checkNotNullParameter((Object)buildSystem, (String)"buildSystem");
            return switch (buildSystem) {
                case "ndkBuild" -> GradleNativeAndroidModule.NativeBuildSystemType.NDK_BUILD;
                case "cmake" -> GradleNativeAndroidModule.NativeBuildSystemType.CMAKE;
                case "ndkCompile" -> GradleNativeAndroidModule.NativeBuildSystemType.NDK_COMPILE;
                case "gradle" -> GradleNativeAndroidModule.NativeBuildSystemType.GRADLE_EXPERIMENTAL;
                default -> GradleNativeAndroidModule.NativeBuildSystemType.UNKNOWN_NATIVE_BUILD_SYSTEM_TYPE;
            };
        }

        private final GradleLibrary trackExternalDependenciesInAndroidApp(GradleAndroidModel model2) {
            Ref chosenVariant = new Ref();
            Iterable $this$forEach$iv = model2.getVariants();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IdeVariant variant = (IdeVariant)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)"release", (Object)variant.getBuildType())) continue;
                chosenVariant.set((Object)variant);
            }
            if (chosenVariant.get() == null) {
                chosenVariant.set((Object)model2.getSelectedVariant());
            }
            Object object = chosenVariant.get();
            Intrinsics.checkNotNull((Object)object);
            IdeDependencies dependencies2 = ((IdeVariant)object).getMainArtifact().getCompileClasspath();
            GradleLibrary gradleLibrary = GradleLibrary.newBuilder().setAarDependencyCount((long)dependencies2.getAndroidLibraries().size()).setJarDependencyCount((long)dependencies2.getJavaLibraries().size()).build();
            Intrinsics.checkNotNullExpressionValue((Object)gradleLibrary, (String)"newBuilder().setAarDepen\u2026oLong())\n        .build()");
            return gradleLibrary;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IdeAndroidProjectType.values().length];
            try {
                nArray[IdeAndroidProjectType.PROJECT_TYPE_LIBRARY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdeAndroidProjectType.PROJECT_TYPE_APP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdeAndroidProjectType.PROJECT_TYPE_ATOM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdeAndroidProjectType.PROJECT_TYPE_DYNAMIC_FEATURE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdeAndroidProjectType.PROJECT_TYPE_FEATURE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdeAndroidProjectType.PROJECT_TYPE_INSTANTAPP.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdeAndroidProjectType.PROJECT_TYPE_TEST.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

