/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues.processor;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.JCenterRepositoryModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvokerKt;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001d\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0013\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u001d\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/gradle/project/sync/issues/processor/RemoveJcenterProcessor;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "affectedModules", "", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "getAffectedModules", "()Ljava/util/List;", "getProject", "()Lcom/intellij/openapi/project/Project;", "createUsageViewDescriptor", "Lcom/intellij/usageView/UsageViewDescriptor;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/usageView/UsageViewDescriptor;", "extractJcenterModel", "Lcom/android/tools/idea/gradle/dsl/model/repositories/JCenterRepositoryModel;", "repositories", "Lcom/android/tools/idea/gradle/dsl/api/repositories/RepositoriesModel;", "findUsages", "()[Lcom/intellij/usageView/UsageInfo;", "getCommandName", "", "performRefactoring", "", "([Lcom/intellij/usageView/UsageInfo;)V", "usagesFromRepositories", "", "RepositoryUsageInfo", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nRemoveJcenterProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveJcenterProcessor.kt\ncom/android/tools/idea/gradle/project/sync/issues/processor/RemoveJcenterProcessor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,113:1\n37#2,2:114\n*S KotlinDebug\n*F\n+ 1 RemoveJcenterProcessor.kt\ncom/android/tools/idea/gradle/project/sync/issues/processor/RemoveJcenterProcessor\n*L\n74#1:114,2\n*E\n"})
public final class RemoveJcenterProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final Project project;
    @NotNull
    private final List<Module> affectedModules;

    public RemoveJcenterProcessor(@NotNull Project project, @NotNull List<? extends Module> affectedModules) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(affectedModules, (String)"affectedModules");
        super(project);
        this.project = project;
        this.affectedModules = affectedModules;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final List<Module> getAffectedModules() {
        return this.affectedModules;
    }

    @NotNull
    public UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        return new UsageViewDescriptor(){

            @NotNull
            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return "References to be removed: " + UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount);
            }

            @NotNull
            public PsiElement[] getElements() {
                Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiElement.EMPTY_ARRAY;
            }

            @NotNull
            public String getProcessedElementsHeader() {
                return "Remove JCenter from repositories.";
            }
        };
    }

    @NotNull
    public UsageInfo[] findUsages() {
        GradleSettingsModel settingsModel;
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        ProjectBuildModel projectBuildModel2 = ProjectBuildModel.get(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel2, (String)"get(myProject)");
        ProjectBuildModel projectBuildModel3 = projectBuildModel2;
        GradleBuildModel buildModel = projectBuildModel3.getProjectBuildModel();
        if (buildModel != null) {
            RepositoriesModel repositoriesModel = buildModel.buildscript().repositories();
            Intrinsics.checkNotNullExpressionValue((Object)repositoriesModel, (String)"buildModel.buildscript().repositories()");
            usages.addAll(this.usagesFromRepositories(repositoriesModel));
        }
        if ((settingsModel = projectBuildModel3.getProjectSettingsModel()) != null) {
            RepositoriesModel repositoriesModel = settingsModel.dependencyResolutionManagement().repositories();
            Intrinsics.checkNotNullExpressionValue((Object)repositoriesModel, (String)"settingsModel.dependency\u2026nagement().repositories()");
            usages.addAll(this.usagesFromRepositories(repositoriesModel));
        }
        for (Module module2 : this.affectedModules) {
            GradleBuildModel moduleModel;
            if (projectBuildModel3.getModuleBuildModel(module2) == null) continue;
            RepositoriesModel repositoriesModel = moduleModel.repositories();
            Intrinsics.checkNotNullExpressionValue((Object)repositoriesModel, (String)"moduleModel.repositories()");
            usages.addAll(this.usagesFromRepositories(repositoriesModel));
        }
        Collection $this$toTypedArray$iv = usages;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new UsageInfo[0]);
    }

    private final Collection<UsageInfo> usagesFromRepositories(RepositoriesModel repositories) {
        ArrayList<RepositoryUsageInfo> usages = new ArrayList<RepositoryUsageInfo>();
        List<JCenterRepositoryModel> jcenterModels = this.extractJcenterModel(repositories);
        for (JCenterRepositoryModel model2 : jcenterModels) {
            if (model2.getPsiElement() == null) continue;
            usages.add(new RepositoryUsageInfo(model2));
        }
        return usages;
    }

    private final List<JCenterRepositoryModel> extractJcenterModel(RepositoriesModel repositories) {
        List<RepositoryModel> list2 = repositories.repositories();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"repositories.repositories()");
        return CollectionsKt.filterIsInstance((Iterable)list2, JCenterRepositoryModel.class);
    }

    public void performRefactoring(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        ProjectBuildModel projectBuildModel2 = ProjectBuildModel.get(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel2, (String)"get(myProject)");
        ProjectBuildModel projectBuildModel3 = projectBuildModel2;
        for (UsageInfo usage : usages) {
            if (!(usage instanceof RepositoryUsageInfo)) continue;
            ((RepositoryUsageInfo)usage).removeUsage();
        }
        projectBuildModel3.applyChanges();
        GradleSyncStats.Trigger trigger = GradleSyncStats.Trigger.TRIGGER_QF_REMOVE_JCENTER_FROM_REPOSITORIES;
        GradleSyncInvoker gradleSyncInvoker = GradleSyncInvoker.Companion.getInstance();
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        GradleSyncInvokerKt.requestProjectSync$default(gradleSyncInvoker, project, trigger, null, 4, null);
    }

    @NotNull
    public String getCommandName() {
        return "Remove JCenter From Repositories";
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/gradle/project/sync/issues/processor/RemoveJcenterProcessor$RepositoryUsageInfo;", "Lcom/intellij/usageView/UsageInfo;", "model", "Lcom/android/tools/idea/gradle/dsl/model/repositories/JCenterRepositoryModel;", "(Lcom/android/tools/idea/gradle/dsl/model/repositories/JCenterRepositoryModel;)V", "getModel", "()Lcom/android/tools/idea/gradle/dsl/model/repositories/JCenterRepositoryModel;", "removeUsage", "", "intellij.android.projectSystem.gradle"})
    public static final class RepositoryUsageInfo
    extends UsageInfo {
        @NotNull
        private final JCenterRepositoryModel model;

        public RepositoryUsageInfo(@NotNull JCenterRepositoryModel model2) {
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            PsiElement psiElement = model2.getPsiElement();
            Intrinsics.checkNotNull((Object)psiElement);
            super(psiElement);
            this.model = model2;
        }

        @NotNull
        public final JCenterRepositoryModel getModel() {
            return this.model;
        }

        public final void removeUsage() {
            this.model.getDslElement().delete();
        }
    }
}

