/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues.processor;

import com.android.tools.idea.gradle.dsl.api.ExternalNativeBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvokerKt;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001b\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\bH\u0016J\u001b\u0010\u0013\u001a\u00020\u00142\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/gradle/project/sync/issues/processor/FixNdkVersionProcessor;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "buildFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "version", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;)V", "createUsageViewDescriptor", "Lcom/intellij/usageView/UsageViewDescriptor;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/usageView/UsageViewDescriptor;", "findUsages", "()[Lcom/intellij/usageView/UsageInfo;", "getCommandName", "performRefactoring", "", "([Lcom/intellij/usageView/UsageInfo;)V", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nFixNdkVersionProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixNdkVersionProcessor.kt\ncom/android/tools/idea/gradle/project/sync/issues/processor/FixNdkVersionProcessor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,132:1\n37#2,2:133\n*S KotlinDebug\n*F\n+ 1 FixNdkVersionProcessor.kt\ncom/android/tools/idea/gradle/project/sync/issues/processor/FixNdkVersionProcessor\n*L\n101#1:133,2\n*E\n"})
public final class FixNdkVersionProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final List<VirtualFile> buildFiles;
    @NotNull
    private final String version;

    public FixNdkVersionProcessor(@NotNull Project project, @NotNull List<? extends VirtualFile> buildFiles, @NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(buildFiles, (String)"buildFiles");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        super(project);
        this.buildFiles = buildFiles;
        this.version = version2;
    }

    @NotNull
    public UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        return new UsageViewDescriptor(){

            @NotNull
            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return "Values to update " + UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount);
            }

            @NotNull
            public PsiElement[] getElements() {
                Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiElement.EMPTY_ARRAY;
            }

            @NotNull
            public String getProcessedElementsHeader() {
                return "Update Android NDK Versions";
            }
        };
    }

    @NotNull
    public UsageInfo[] findUsages() {
        ProjectBuildModel projectBuildModel2 = ProjectBuildModel.get(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel2, (String)"get(myProject)");
        ProjectBuildModel projectBuildModel3 = projectBuildModel2;
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        for (VirtualFile file2 : this.buildFiles) {
            ResolvedPropertyModel ndkVersion2;
            AndroidModel android;
            if (!file2.isValid() || !file2.isWritable()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel3.getModuleBuildModel(file2).android(), (String)"projectBuildModel.getMod\u2026uildModel(file).android()");
            ExternalNativeBuildModel externalNativeBuildModel = android.externalNativeBuild();
            Intrinsics.checkNotNull((Object)externalNativeBuildModel, (String)"null cannot be cast to non-null type com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel");
            GradleDslBlockModel externalNativeBuild = (GradleDslBlockModel)((Object)externalNativeBuildModel);
            if (!externalNativeBuild.hasValidPsiElement()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)android.ndkVersion(), (String)"android.ndkVersion()");
            if (Intrinsics.areEqual((Object)this.version, (Object)ndkVersion2.toString())) continue;
            PsiElement element2 = ndkVersion2.getFullExpressionPsiElement();
            if (element2 != null) {
                usages.add(new UsageInfo(element2));
                continue;
            }
            PsiElement psiElement = ((GradleDslBlockModel)((Object)android)).getPsiElement();
            Intrinsics.checkNotNull((Object)psiElement);
            usages.add(new UsageInfo(psiElement));
        }
        Collection $this$toTypedArray$iv = usages;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new UsageInfo[0]);
    }

    public void performRefactoring(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        ProjectBuildModel projectBuildModel2 = ProjectBuildModel.get(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel2, (String)"get(myProject)");
        ProjectBuildModel projectBuildModel3 = projectBuildModel2;
        for (VirtualFile file2 : this.buildFiles) {
            ResolvedPropertyModel ndkVersion2;
            AndroidModel android;
            Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel3.getModuleBuildModel(file2).android(), (String)"projectBuildModel.getMod\u2026uildModel(file).android()");
            ExternalNativeBuildModel externalNativeBuildModel = android.externalNativeBuild();
            Intrinsics.checkNotNull((Object)externalNativeBuildModel, (String)"null cannot be cast to non-null type com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel");
            GradleDslBlockModel externalNativeBuild = (GradleDslBlockModel)((Object)externalNativeBuildModel);
            if (!externalNativeBuild.hasValidPsiElement()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)android.ndkVersion(), (String)"android.ndkVersion()");
            ndkVersion2.setValue(this.version);
        }
        projectBuildModel3.applyChanges();
        GradleSyncInvoker gradleSyncInvoker = GradleSyncInvoker.Companion.getInstance();
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        GradleSyncInvokerKt.requestProjectSync$default(gradleSyncInvoker, project, GradleSyncStats.Trigger.TRIGGER_QF_NDK_INSTALLED, null, 4, null);
    }

    @NotNull
    public String getCommandName() {
        return "Update Android NDK Version";
    }
}

