/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues.processor;

import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class FixBuildToolsProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final List<VirtualFile> myBuildFiles;
    @NotNull
    private final String myVersion;
    private final boolean myRequestSync;
    private final boolean myRemoveBuildTools;

    public FixBuildToolsProcessor(@NotNull Project project, @NotNull List<VirtualFile> buildFiles, @NotNull String version2, boolean requestSync2, boolean removeBuildTools) {
        super(project);
        this.myBuildFiles = buildFiles;
        this.myVersion = version2;
        this.myRequestSync = requestSync2;
        this.myRemoveBuildTools = removeBuildTools;
    }

    @NotNull
    public UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        return new UsageViewDescriptor(){

            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return "Values to " + (FixBuildToolsProcessor.this.myRemoveBuildTools ? "remove " : "update ") + UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount);
            }

            @NotNull
            public PsiElement[] getElements() {
                return PsiElement.EMPTY_ARRAY;
            }

            public String getProcessedElementsHeader() {
                return (FixBuildToolsProcessor.this.myRemoveBuildTools ? "Remove" : "Update") + " Android Build Tools Versions";
            }
        };
    }

    @NotNull
    public UsageInfo[] findUsages() {
        ProjectBuildModel projectBuildModel2 = ProjectBuildModel.get(this.myProject);
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        for (VirtualFile file2 : this.myBuildFiles) {
            PsiElement element2;
            AndroidModel android;
            ResolvedPropertyModel buildToolsVersion2;
            if (!file2.isValid() || !file2.isWritable() || this.myVersion.equals((buildToolsVersion2 = (android = projectBuildModel2.getModuleBuildModel(file2).android()).buildToolsVersion()).toString()) || (element2 = buildToolsVersion2.getFullExpressionPsiElement()) == null) continue;
            usages.add(new UsageInfo(element2));
        }
        return usages.toArray(UsageInfo.EMPTY_ARRAY);
    }

    public void performRefactoring(@NotNull UsageInfo[] usages) {
        ProjectBuildModel projectBuildModel2 = ProjectBuildModel.get(this.myProject);
        List elements = Arrays.stream(usages).map(usage -> usage.getElement()).collect(Collectors.toList());
        for (VirtualFile file2 : this.myBuildFiles) {
            AndroidModel android = projectBuildModel2.getModuleBuildModel(file2).android();
            ResolvedPropertyModel buildToolsVersion2 = android.buildToolsVersion();
            PsiElement element2 = buildToolsVersion2.getFullExpressionPsiElement();
            if (element2 == null || !elements.contains(element2)) continue;
            if (this.myRemoveBuildTools) {
                buildToolsVersion2.delete();
                continue;
            }
            buildToolsVersion2.setValue(this.myVersion);
        }
        projectBuildModel2.applyChanges();
        if (this.myRequestSync) {
            GradleSyncStats.Trigger trigger = this.myRemoveBuildTools ? GradleSyncStats.Trigger.TRIGGER_QF_BUILD_TOOLS_VERISON_REMOVED : GradleSyncStats.Trigger.TRIGGER_QF_BUILD_TOOLS_VERSION_CHANGED;
            GradleSyncInvoker.getInstance().requestProjectSync(this.myProject, new GradleSyncInvoker.Request(trigger), null);
        }
    }

    @NotNull
    public String getCommandName() {
        return (this.myRemoveBuildTools ? "Remove" : "Update") + " Android Build Tools Version";
    }
}

