/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.tools.idea.gradle.model.IdeSyncIssue;
import com.android.tools.idea.gradle.project.sync.hyperlink.CreateGradleWrapperHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixGradleVersionInWrapperHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileSyncMessageHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenGradleSettingsHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.SimpleDeduplicatingSyncIssueReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueNotificationHyperlink;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NonNavigatable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

class UnsupportedGradleReporter
extends SimpleDeduplicatingSyncIssueReporter {
    UnsupportedGradleReporter() {
    }

    @Override
    int getSupportedIssueType() {
        return 12;
    }

    @Override
    @NotNull
    protected SyncMessage setupSyncMessage(@NotNull Project project, @NotNull List<IdeSyncIssue> syncIssues2, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap, @NotNull MessageType type) {
        if (syncIssues2.size() != 1) {
            throw new IllegalStateException("Must not have been de-duplicated because of getDeduplicationKey()");
        }
        IdeSyncIssue syncIssue = syncIssues2.get(0);
        String text2 = syncIssue.getMessage();
        SyncMessage message2 = new SyncMessage("Gradle Sync Issues", type, NonNavigatable.INSTANCE, text2);
        String gradleVersion2 = syncIssue.getData();
        List<SyncIssueNotificationHyperlink> quickFixes = UnsupportedGradleReporter.getQuickFixHyperlinksWithGradleVersion(project, gradleVersion2);
        message2.add(quickFixes);
        return message2;
    }

    @Override
    @NotNull
    protected Object getDeduplicationKey(@NotNull IdeSyncIssue issue2) {
        return new Object();
    }

    @Override
    protected boolean shouldIncludeModuleLinks() {
        return false;
    }

    @NotNull
    private static List<SyncIssueNotificationHyperlink> getQuickFixHyperlinksWithGradleVersion(@NotNull Project project, @Nullable String gradleVersion2) {
        ArrayList<SyncIssueNotificationHyperlink> hyperlinks = new ArrayList<SyncIssueNotificationHyperlink>();
        GradleWrapper gradleWrapper = GradleWrapper.find(project);
        if (gradleWrapper != null) {
            File propertiesFile;
            SyncIssueNotificationHyperlink hyperlink2 = FixGradleVersionInWrapperHyperlink.createIfProjectUsesGradleWrapper(project, gradleVersion2);
            if (hyperlink2 != null) {
                hyperlinks.add(hyperlink2);
            }
            if ((propertiesFile = gradleWrapper.getPropertiesFilePath()).exists()) {
                hyperlinks.add(new OpenFileSyncMessageHyperlink(gradleWrapper.getPropertiesFilePath().getAbsolutePath(), "Open Gradle wrapper properties", -1, -1));
            }
        } else {
            GradleProjectSettings gradleProjectSettings = GradleProjectSettingsFinder.getInstance().findGradleProjectSettings(project);
            if (gradleProjectSettings != null && gradleProjectSettings.getDistributionType() == DistributionType.LOCAL) {
                hyperlinks.add(new CreateGradleWrapperHyperlink());
            }
        }
        hyperlinks.add(new OpenGradleSettingsHyperlink());
        return hyperlinks;
    }
}

