/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.issues;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.AndroidStudioGradleInstallationManager;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueUtilKt;
import com.android.tools.idea.gradle.project.sync.idea.issues.JdkImportCheckException;
import com.android.tools.idea.gradle.project.sync.idea.issues.SelectJdkFromFileSystemQuickFix;
import com.android.tools.idea.gradle.project.sync.idea.issues.UseEmbeddedJdkQuickFix;
import com.android.tools.idea.gradle.project.sync.idea.issues.UseJavaHomeAsJdkQuickFix;
import com.android.tools.idea.gradle.project.sync.quickFixes.DownloadAndroidStudioQuickFix;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.Jdks;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/gradle/project/sync/idea/issues/JdkImportIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "addUseJavaHomeQuickFix", "", "composer", "Lcom/android/tools/idea/gradle/project/sync/idea/issues/BuildIssueComposer;", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nJdkImportCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkImportCheck.kt\ncom/android/tools/idea/gradle/project/sync/idea/issues/JdkImportIssueChecker\n+ 2 actions.kt\ncom/intellij/openapi/application/ActionsKt\n*L\n1#1,233:1\n58#2,3:234\n*S KotlinDebug\n*F\n+ 1 JdkImportCheck.kt\ncom/android/tools/idea/gradle/project/sync/idea/issues/JdkImportIssueChecker\n*L\n90#1:234,3\n*E\n"})
public final class JdkImportIssueChecker
implements GradleIssueChecker {
    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        BuildIssueComposer buildIssueComposer;
        Object object;
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        if (issueData.getError() instanceof JdkImportCheckException) {
            String string = issueData.getError().getMessage();
            object = string;
            Intrinsics.checkNotNull((Object)string);
        } else {
            String string = issueData.getError().getMessage();
            boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Unsupported major.minor version 52.0", (boolean)false, (int)2, null) : false;
            if (bl) {
                Object modalityState$iv = null;
                boolean $i$f$invokeLater = false;
                ApplicationManager.getApplication().invokeLater(new Runnable(issueData){
                    final /* synthetic */ GradleIssueData $issueData$inlined;
                    {
                        this.$issueData$inlined = gradleIssueData;
                    }

                    public final void run() {
                        boolean bl = false;
                        BuildIssueUtilKt.updateUsageTracker(this.$issueData$inlined.getProjectPath(), AndroidStudioEvent.GradleSyncFailure.JDK8_REQUIRED);
                    }
                }, ModalityState.defaultModalityState());
                String string2 = issueData.getError().getMessage();
                Intrinsics.checkNotNull((Object)string2);
                object = string2 + "\nPlease use JDK 8 or newer.";
            } else {
                return null;
            }
        }
        String message2 = object;
        BuildIssueComposer $this$check_u24lambda_u241 = buildIssueComposer = new BuildIssueComposer(message2, null, 2, null);
        boolean bl = false;
        if (IdeInfo.getInstance().isAndroidStudio()) {
            Project ideaProject = BuildIssueUtilKt.fetchIdeaProjectForGradleProject(issueData.getProjectPath());
            if (ideaProject != null) {
                GradleInstallationManager gradleInstallationManager = GradleInstallationManager.getInstance();
                Intrinsics.checkNotNull((Object)gradleInstallationManager, (String)"null cannot be cast to non-null type com.android.tools.idea.gradle.project.AndroidStudioGradleInstallationManager");
                AndroidStudioGradleInstallationManager gradleInstallation = (AndroidStudioGradleInstallationManager)gradleInstallationManager;
                if (!gradleInstallation.isUsingJavaHomeJdk(ideaProject)) {
                    this.addUseJavaHomeQuickFix($this$check_u24lambda_u241);
                }
            }
            if ($this$check_u24lambda_u241.getIssueQuickFixes().isEmpty()) {
                Path path2 = IdeSdks.getInstance().getEmbeddedJdkPath();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getInstance().embeddedJdkPath");
                Path embeddedJdkPath = path2;
                if (Jdks.isJdkRunnableOnPlatform(((Object)embeddedJdkPath.toAbsolutePath()).toString())) {
                    $this$check_u24lambda_u241.addQuickFix(new UseEmbeddedJdkQuickFix());
                } else {
                    $this$check_u24lambda_u241.addQuickFix(new DownloadAndroidStudioQuickFix());
                }
            }
        }
        $this$check_u24lambda_u241.addQuickFix(new SelectJdkFromFileSystemQuickFix());
        return buildIssueComposer.composeBuildIssue();
    }

    private final void addUseJavaHomeQuickFix(BuildIssueComposer composer) {
        IdeSdks ideSdks = IdeSdks.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)ideSdks, (String)"getInstance()");
        IdeSdks ideSdks2 = ideSdks;
        String jdkFromHome = IdeSdks.getJdkFromJavaHome();
        if (jdkFromHome != null && ideSdks2.validateJdkPath(Paths.get(jdkFromHome, new String[0])) != null) {
            composer.addQuickFix(new UseJavaHomeAsJdkQuickFix());
        }
    }
}

