/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data.service;

import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacetType;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.idea.data.service.ModuleModelDataService;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.intellij.facet.Facet;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class NdkModuleModelDataService
extends ModuleModelDataService<NdkModuleModel> {
    @NotNull
    public Key<NdkModuleModel> getTargetDataKey() {
        return AndroidProjectKeys.NDK_MODEL;
    }

    @Override
    protected void importData(@NotNull Collection<? extends DataNode<NdkModuleModel>> toImport, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Map<String, DataNode<NdkModuleModel>> modelsByModuleName) {
        for (Module module2 : modelsProvider.getModules()) {
            DataNode<NdkModuleModel> ndkModuleModelNode = modelsByModuleName.get(module2.getName());
            if (ndkModuleModelNode == null) continue;
            NdkFacet facet2 = Facets.findFacet(module2, modelsProvider, NdkFacet.getFacetTypeId());
            if (facet2 == null) {
                ModifiableFacetModel model2 = modelsProvider.getModifiableFacetModel(module2);
                NdkFacetType facetType = NdkFacet.getFacetType();
                facet2 = facetType.createFacet(module2, NdkFacet.getFacetName(), facetType.createDefaultConfiguration(), (Facet)null);
                model2.addFacet((Facet)facet2, ExternalSystemApiUtil.toExternalSource((ProjectSystemId)GradleConstants.SYSTEM_ID));
            }
            facet2.setNdkModuleModel((NdkModuleModel)ndkModuleModelNode.getData());
        }
    }

    public void removeData(Computable<? extends Collection<? extends Module>> toRemoveComputable, @NotNull Collection<? extends DataNode<NdkModuleModel>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        for (Module module2 : (Collection)toRemoveComputable.get()) {
            ModifiableFacetModel facetModel = modelsProvider.getModifiableFacetModel(module2);
            Facets.removeAllFacets(facetModel, NdkFacet.getFacetTypeId());
        }
    }
}

