/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data.service;

import com.android.tools.idea.gradle.project.model.ModuleModel;
import com.android.tools.idea.projectsystem.ModuleSystemUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleModelDataService<T extends ModuleModel>
extends AbstractProjectDataService<T, Module> {
    public final void importData(@NotNull Collection<? extends DataNode<T>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            if (project.isDisposed()) {
                return;
            }
            Map<String, DataNode<T>> modelsByModuleName = this.indexByModuleName(toImport, modelsProvider);
            this.importData(toImport, project, modelsProvider, modelsByModuleName);
        });
    }

    protected abstract void importData(@NotNull Collection<? extends DataNode<T>> var1, @NotNull Project var2, @NotNull IdeModifiableModelsProvider var3, @NotNull Map<String, DataNode<T>> var4);

    @NotNull
    public Computable<Collection<Module>> computeOrphanData(@NotNull Collection<? extends DataNode<T>> toImport, @NotNull ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Map modelsByModuleName = this.indexByModuleName(toImport, modelsProvider);
        return () -> {
            SmartList orphanIdeModules = new SmartList();
            for (Module module2 : modelsProvider.getModules()) {
                if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)projectData.getOwner(), (Module)module2)) continue;
                String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module2);
                if (!projectData.getLinkedExternalProjectPath().equals(rootProjectPath) || modelsByModuleName.get(ModuleSystemUtil.getHolderModule(module2).getName()) != null) continue;
                orphanIdeModules.add(module2);
            }
            return orphanIdeModules;
        };
    }

    @NotNull
    private Map<String, DataNode<T>> indexByModuleName(@NotNull Collection<? extends DataNode<T>> dataNodes, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (dataNodes.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, DataNode<T>> index2 = new HashMap<String, DataNode<T>>();
        for (DataNode<T> dataNode : dataNodes) {
            ModuleData moduleData;
            Module module2;
            ModuleModel model2 = (ModuleModel)dataNode.getData();
            String moduleName2 = model2.getModuleName();
            if (dataNode.getParent() != null && (module2 = modelsProvider.findIdeModule(moduleData = (ModuleData)dataNode.getParent().getData())) != null && !module2.getName().equals(moduleName2)) {
                moduleName2 = module2.getName();
            }
            index2.put(moduleName2, dataNode);
        }
        return index2;
    }

    @NotNull
    protected Logger getLog() {
        return Logger.getInstance(((Object)((Object)this)).getClass());
    }
}

