/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data.service;

import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.idea.data.service.ModuleModelDataService;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.GradleModuleSetup;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GradleModuleModelDataService
extends ModuleModelDataService<GradleModuleModel> {
    @NotNull
    private final GradleModuleSetup myModuleSetup;

    public GradleModuleModelDataService() {
        this(new GradleModuleSetup());
    }

    @VisibleForTesting
    GradleModuleModelDataService(@NotNull GradleModuleSetup moduleSetup) {
        this.myModuleSetup = moduleSetup;
    }

    @NotNull
    public Key<GradleModuleModel> getTargetDataKey() {
        return AndroidProjectKeys.GRADLE_MODULE_MODEL;
    }

    @Override
    protected void importData(@NotNull Collection<? extends DataNode<GradleModuleModel>> toImport, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Map<String, DataNode<GradleModuleModel>> modelsByModuleName) {
        for (Module module2 : modelsProvider.getModules()) {
            DataNode<GradleModuleModel> gradleModuleModelDataNode = modelsByModuleName.get(module2.getName());
            if (gradleModuleModelDataNode == null) continue;
            this.myModuleSetup.setUpModule(module2, modelsProvider, (GradleModuleModel)gradleModuleModelDataNode.getData());
        }
    }

    public void removeData(Computable<? extends Collection<? extends Module>> toRemoveComputable, @NotNull Collection<? extends DataNode<GradleModuleModel>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        for (Module module2 : (Collection)toRemoveComputable.get()) {
            ModifiableFacetModel facetModel = modelsProvider.getModifiableFacetModel(module2);
            Facets.removeAllFacets(facetModel, GradleFacet.getFacetTypeId());
        }
    }
}

