/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.gradle.project.sync.hyperlink.SyncIssueDetailsDialog;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueNotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import java.awt.Window;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ShowSyncIssuesDetailsHyperlink
extends SyncIssueNotificationHyperlink {
    @NotNull
    private final String myMessage;
    @NotNull
    private final List<String> myDetails;
    private SyncIssueDetailsDialog myDetailsDialog;

    public ShowSyncIssuesDetailsHyperlink(@NotNull String message2, @NotNull List<String> details) {
        super(message2, "Show Details", AndroidStudioEvent.GradleSyncQuickFix.SHOW_SYNC_ISSUES_DETAILS_HYPERLINK);
        this.myMessage = message2;
        assert (!details.isEmpty());
        this.myDetails = details;
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (this.myDetailsDialog == null) {
            Window parentWindow = WindowManager.getInstance().suggestParentWindow(project);
            this.myDetailsDialog = new SyncIssueDetailsDialog(this.myMessage, this.myDetails, parentWindow);
        }
        this.myDetailsDialog.pack();
        this.myDetailsDialog.setModal(false);
        this.myDetailsDialog.setVisible(true);
    }

    @VisibleForTesting
    @NotNull
    public String getMessage() {
        return this.myMessage;
    }

    @VisibleForTesting
    @NotNull
    public List<String> getDetails() {
        return ImmutableList.copyOf(this.myDetails);
    }
}

