/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.project.sync.issues.SdkInManifestIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueNotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.processor.RemoveSdkFromManifestProcessor;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class RemoveSdkFromManifestHyperlink
extends SyncIssueNotificationHyperlink {
    @NotNull
    private final Collection<Module> myModules;
    @NotNull
    private final SdkInManifestIssuesReporter.SdkProperty mySdkProperty;

    public RemoveSdkFromManifestHyperlink(@NotNull Collection<Module> modules, @NotNull SdkInManifestIssuesReporter.SdkProperty property2) {
        super("remove.sdk.from.manifest", RemoveSdkFromManifestHyperlink.getMessage(modules, property2), AndroidStudioEvent.GradleSyncQuickFix.REMOVE_SDK_FROM_MANIFEST_HYPERLINK);
        this.myModules = modules;
        this.mySdkProperty = property2;
    }

    @NotNull
    private static String getMessage(@NotNull Collection<Module> modules, @NotNull SdkInManifestIssuesReporter.SdkProperty property2) {
        assert (!modules.isEmpty());
        ProjectBuildModel projectBuildModel2 = ProjectBuildModel.get(modules.iterator().next().getProject());
        for (Module module2 : modules) {
            ResolvedPropertyModel propertyInBuildFile;
            GradleBuildModel buildModel = projectBuildModel2.getModuleBuildModel(module2);
            if (buildModel == null || (propertyInBuildFile = property2.getBuildFileFunction().apply(buildModel.android().defaultConfig())).getValueType() != GradlePropertyModel.ValueType.NONE) continue;
            return String.format("Move %s to build file%s and sync project", property2.getPropertyName(), modules.size() > 1 ? "s" : "");
        }
        return String.format("Remove %s and sync project", property2.getPropertyName());
    }

    @Override
    protected void execute(@NotNull Project project) {
        RemoveSdkFromManifestProcessor processor = new RemoveSdkFromManifestProcessor(project, this.myModules, this.mySdkProperty);
        processor.setPreviewUsages(true);
        processor.run();
    }
}

