/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueNotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.processor.RemoveJcenterProcessor;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/gradle/project/sync/hyperlink/RemoveJcenterHyperlink;", "Lcom/android/tools/idea/gradle/project/sync/issues/SyncIssueNotificationHyperlink;", "project", "Lcom/intellij/openapi/project/Project;", "affectedModules", "", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "getAffectedModules", "()Ljava/util/List;", "getProject", "()Lcom/intellij/openapi/project/Project;", "applyFix", "", "processor", "Lcom/android/tools/idea/gradle/project/sync/issues/processor/RemoveJcenterProcessor;", "execute", "Companion", "intellij.android.projectSystem.gradle"})
public final class RemoveJcenterHyperlink
extends SyncIssueNotificationHyperlink {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final List<Module> affectedModules;

    public RemoveJcenterHyperlink(@NotNull Project project, @NotNull List<? extends Module> affectedModules) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(affectedModules, (String)"affectedModules");
        super("remove.jcenter.hyperlink", "Remove JCenter from repositories", AndroidStudioEvent.GradleSyncQuickFix.REMOVE_JCENTER_HYPERLINK);
        this.project = project;
        this.affectedModules = affectedModules;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final List<Module> getAffectedModules() {
        return this.affectedModules;
    }

    @Override
    protected void execute(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.applyFix(project, new RemoveJcenterProcessor(project, this.affectedModules));
    }

    @VisibleForTesting
    public final void applyFix(@NotNull Project project, @NotNull RemoveJcenterProcessor processor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)processor), (String)"processor");
        if (!Companion.canBeApplied(project, this.affectedModules)) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                Messages.showWarningDialog((Project)project, (String)"Could not identify where to apply this fix", (String)"Remove JCenter Quickfix");
            }
            return;
        }
        processor.setPreviewUsages(true);
        processor.run();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/gradle/project/sync/hyperlink/RemoveJcenterHyperlink$Companion;", "", "()V", "canBeApplied", "", "project", "Lcom/intellij/openapi/project/Project;", "affectedModules", "", "Lcom/intellij/openapi/module/Module;", "intellij.android.projectSystem.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean canBeApplied(@NotNull Project project, @NotNull List<? extends Module> affectedModules) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(affectedModules, (String)"affectedModules");
            ProjectBuildModel projectBuildModel2 = ProjectBuildModel.getOrLog(project);
            if (projectBuildModel2 == null) {
                return false;
            }
            ProjectBuildModel projectBuildModel3 = projectBuildModel2;
            GradleBuildModel buildModel = projectBuildModel3.getProjectBuildModel();
            if (buildModel != null && buildModel.buildscript().repositories().containsMethodCall("jcenter")) {
                return true;
            }
            GradleSettingsModel settingsModel = projectBuildModel3.getProjectSettingsModel();
            if (settingsModel != null && settingsModel.dependencyResolutionManagement().repositories().containsMethodCall("jcenter")) {
                return true;
            }
            for (Module module2 : affectedModules) {
                GradleBuildModel moduleModel;
                if (projectBuildModel3.getModuleBuildModel(module2) == null || !moduleModel.repositories().containsMethodCall("jcenter")) continue;
                return true;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

