/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.gradle.project.sync.hyperlink.HyperlinkUtil;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueNotificationHyperlink;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InstallSdkPackageHyperlink
extends SyncIssueNotificationHyperlink {
    private final List<String> myPackageIds;

    public InstallSdkPackageHyperlink(@NotNull List<String> packageIds) {
        super("install.sdk.package", "Install missing SDK package(s)", AndroidStudioEvent.GradleSyncQuickFix.INSTALL_SDK_PACKAGE_HYPERLINK);
        this.myPackageIds = packageIds;
    }

    @Override
    protected void execute(@NotNull Project project) {
        ModelWizardDialog dialog2 = SdkQuickfixUtils.createDialogForPaths(project, this.myPackageIds, true);
        if (dialog2 != null && dialog2.showAndGet()) {
            HyperlinkUtil.requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_QF_REPOSITORY_INSTALLED);
        }
    }
}

