/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.sync.errors.ApplyGradlePluginQuickFix;
import com.android.tools.idea.gradle.project.sync.errors.GetGradleSettingsQuickFix;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueUtilKt;
import com.android.tools.idea.gradle.project.sync.quickFixes.FixAndroidGradlePluginVersionQuickFix;
import com.android.tools.idea.gradle.project.sync.quickFixes.OpenFileAtLocationQuickFix;
import com.android.utils.BuildScriptUtil;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import java.io.File;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016JD\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00170\u0016H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/GradleDslMethodNotFoundIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "GRADLE_DSL_METHOD_NOT_FOUND_ERROR_PREFIX", "", "MISSING_METHOD_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "updateNotificationWithBuildFile", "", "filePosition", "buildIssueComposer", "Lcom/android/tools/idea/gradle/project/sync/idea/issues/BuildIssueComposer;", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleDslMethodNotFoundIssueChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleDslMethodNotFoundIssueChecker.kt\ncom/android/tools/idea/gradle/project/sync/errors/GradleDslMethodNotFoundIssueChecker\n+ 2 actions.kt\ncom/intellij/openapi/application/ActionsKt\n*L\n1#1,148:1\n58#2,3:149\n*S KotlinDebug\n*F\n+ 1 GradleDslMethodNotFoundIssueChecker.kt\ncom/android/tools/idea/gradle/project/sync/errors/GradleDslMethodNotFoundIssueChecker\n*L\n61#1:149,3\n*E\n"})
public final class GradleDslMethodNotFoundIssueChecker
implements GradleIssueChecker {
    @NotNull
    private final String GRADLE_DSL_METHOD_NOT_FOUND_ERROR_PREFIX;
    private final Pattern MISSING_METHOD_PATTERN = Pattern.compile("Could not find method (.*?) .*");

    public GradleDslMethodNotFoundIssueChecker() {
        this.GRADLE_DSL_METHOD_NOT_FOUND_ERROR_PREFIX = "Gradle DSL method not found";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        String string = ((Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first).getMessage();
        if (string == null) {
            return null;
        }
        String message2 = string;
        if (!StringsKt.startsWith$default((String)message2, (String)this.GRADLE_DSL_METHOD_NOT_FOUND_ERROR_PREFIX, (boolean)false, (int)2, null)) {
            return null;
        }
        Object modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        ApplicationManager.getApplication().invokeLater(new Runnable(issueData){
            final /* synthetic */ GradleIssueData $issueData$inlined;
            {
                this.$issueData$inlined = gradleIssueData;
            }

            public final void run() {
                boolean bl = false;
                BuildIssueUtilKt.updateUsageTracker(this.$issueData$inlined.getProjectPath(), AndroidStudioEvent.GradleSyncFailure.DSL_METHOD_NOT_FOUND);
            }
        }, ModalityState.defaultModalityState());
        Matcher matcher = this.MISSING_METHOD_PATTERN.matcher(message2);
        BuildIssueComposer buildIssueComposer = new BuildIssueComposer(this.GRADLE_DSL_METHOD_NOT_FOUND_ERROR_PREFIX + ": '" + (matcher.find() ? matcher.group(1) : "") + "'", null, 2, null);
        if (issueData.getFilePosition() != null) {
            FilePosition filePosition = issueData.getFilePosition();
            Intrinsics.checkNotNull((Object)filePosition);
            File file2 = filePosition.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"issueData.filePosition!!.file");
            if (BuildScriptUtil.isDefaultGradleBuildFile((File)file2)) {
                FilePosition filePosition2 = issueData.getFilePosition();
                Intrinsics.checkNotNull((Object)filePosition2);
                this.updateNotificationWithBuildFile(filePosition2, buildIssueComposer);
                return buildIssueComposer.composeBuildIssue();
            }
        }
        if (issueData.getFilePosition() == null) return buildIssueComposer.composeBuildIssue();
        FilePosition filePosition = issueData.getFilePosition();
        Intrinsics.checkNotNull((Object)filePosition);
        buildIssueComposer.addQuickFix("Open file", new OpenFileAtLocationQuickFix(filePosition));
        return buildIssueComposer.composeBuildIssue();
    }

    private final void updateNotificationWithBuildFile(FilePosition filePosition, BuildIssueComposer buildIssueComposer) {
        buildIssueComposer.addDescription("\nPossible causes:");
        buildIssueComposer.addDescription("Your project may be using a version of the Android Gradle plug-in that does not contain the method (e.g. 'testCompile' was added in 1.1.0).");
        String string = LatestKnownPluginVersionProvider.INSTANCE.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"INSTANCE.get()");
        AgpVersion pluginVersion = AgpVersion.Companion.parse(string);
        buildIssueComposer.addQuickFix("Upgrade plugin to version " + pluginVersion + " and sync project", new FixAndroidGradlePluginVersionQuickFix(pluginVersion, GradleVersion.version((String)"8.0")));
        buildIssueComposer.addQuickFix("Open Gradle wrapper file", new GetGradleSettingsQuickFix());
        buildIssueComposer.addQuickFix("Apply Gradle plugin", new ApplyGradlePluginQuickFix(filePosition));
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message2, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return StringsKt.startsWith$default((String)failureCause, (String)this.GRADLE_DSL_METHOD_NOT_FOUND_ERROR_PREFIX, (boolean)false, (int)2, null);
    }
}

