/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.project.sync.AgpVersionIncompatible;
import com.android.tools.idea.gradle.project.sync.AgpVersionTooNew;
import com.android.tools.idea.gradle.project.sync.AgpVersionTooOld;
import com.android.tools.idea.gradle.project.sync.errors.AgpUpgradeQuickFix;
import com.android.tools.idea.gradle.project.sync.errors.AgpVersionNotSupportedIssueCheckerKt;
import com.android.tools.idea.gradle.project.sync.idea.AndroidGradleProjectResolver;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueUtilKt;
import com.android.tools.idea.gradle.project.sync.quickFixes.OpenLinkQuickFix;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016JD\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00130\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/AgpVersionNotSupportedIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "logMetrics", "", "issueDataProjectPath", "Companion", "intellij.android.projectSystem.gradle.upgrade"})
@SourceDebugExtension(value={"SMAP\nAgpVersionNotSupportedIssueChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgpVersionNotSupportedIssueChecker.kt\ncom/android/tools/idea/gradle/project/sync/errors/AgpVersionNotSupportedIssueChecker\n+ 2 actions.kt\ncom/intellij/openapi/application/ActionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n58#2,3:141\n1722#3,3:144\n1722#3,3:147\n1722#3,3:150\n*S KotlinDebug\n*F\n+ 1 AgpVersionNotSupportedIssueChecker.kt\ncom/android/tools/idea/gradle/project/sync/errors/AgpVersionNotSupportedIssueChecker\n*L\n92#1:141,3\n105#1:144,3\n106#1:147,3\n107#1:150,3\n*E\n"})
public final class AgpVersionNotSupportedIssueChecker
implements GradleIssueChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TOO_OLD_URL = "https://developer.android.com/studio/releases#android_gradle_plugin_and_android_studio_compatibility";
    @NotNull
    private static final String PREVIEW_URL = "https://developer.android.com/studio/preview/features#agp-previews";
    @NotNull
    private static final String TOO_NEW_URL = "https://developer.android.com/studio/releases#android_gradle_plugin_and_android_studio_compatibility";

    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        BuildIssueComposer buildIssueComposer;
        Triple triple;
        String message2;
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        Throwable rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        String string = rootCause.getMessage();
        if (string == null) {
            string = "";
        }
        if (StringsKt.isBlank((CharSequence)(message2 = string))) {
            return null;
        }
        Matcher tooOldMatcher = AgpVersionTooOld.Companion.getPATTERN().matcher(message2);
        Matcher incompatiblePreviewMatcher = AgpVersionIncompatible.Companion.getPATTERN().matcher(message2);
        Matcher tooNewMatcher = AgpVersionTooNew.Companion.getPATTERN().matcher(message2);
        if (tooOldMatcher.find()) {
            triple = new Triple((Object)tooOldMatcher, (Object)tooOldMatcher.group(0), (Object)"https://developer.android.com/studio/releases#android_gradle_plugin_and_android_studio_compatibility");
        } else if (incompatiblePreviewMatcher.find()) {
            triple = new Triple((Object)incompatiblePreviewMatcher, (Object)incompatiblePreviewMatcher.group(0), (Object)PREVIEW_URL);
        } else if (tooNewMatcher.find()) {
            triple = new Triple((Object)tooNewMatcher, (Object)tooNewMatcher.group(0), (Object)"https://developer.android.com/studio/releases#android_gradle_plugin_and_android_studio_compatibility");
        } else {
            return null;
        }
        Triple triple2 = triple;
        Matcher matcher = (Matcher)triple2.component1();
        String userMessage = (String)triple2.component2();
        String url = (String)triple2.component3();
        String string2 = matcher.group(1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"matcher.group(1)");
        AgpVersion agpVersion = AgpVersion.Companion.tryParse(string2);
        if (agpVersion == null) {
            return null;
        }
        AgpVersion version2 = agpVersion;
        this.logMetrics(issueData.getProjectPath());
        Intrinsics.checkNotNullExpressionValue((Object)userMessage, (String)"userMessage");
        BuildIssueComposer buildIssueComposer2 = new BuildIssueComposer(userMessage, null, 2, null);
        if (Intrinsics.areEqual((Object)matcher, (Object)tooNewMatcher)) {
            BuildIssueComposer buildIssueComposer3;
            BuildIssueComposer $this$check_u24lambda_u240 = buildIssueComposer3 = buildIssueComposer2;
            boolean bl = false;
            $this$check_u24lambda_u240.addQuickFix("See Android Studio & AGP compatibility options.", new OpenLinkQuickFix(url));
            return buildIssueComposer3.composeBuildIssue();
        }
        if (!AndroidGradleProjectResolver.Companion.shouldDisableForceUpgrades()) {
            Project project = BuildIssueUtilKt.fetchIdeaProjectForGradleProject(issueData.getProjectPath());
            if (project != null) {
                Project project2 = project;
                boolean bl = false;
                AgpVersionNotSupportedIssueCheckerKt.updateAndRequestSync$default(project2, version2, null, 4, null);
            }
            buildIssueComposer2.addQuickFix(new AgpUpgradeQuickFix(version2));
        }
        BuildIssueComposer $this$check_u24lambda_u242 = buildIssueComposer = buildIssueComposer2;
        boolean bl = false;
        $this$check_u24lambda_u242.addQuickFix("See Android Studio & AGP compatibility options.", new OpenLinkQuickFix(url));
        return buildIssueComposer.composeBuildIssue();
    }

    private final void logMetrics(String issueDataProjectPath) {
        Object modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        ApplicationManager.getApplication().invokeLater(new Runnable(issueDataProjectPath){
            final /* synthetic */ String $issueDataProjectPath$inlined;
            {
                this.$issueDataProjectPath$inlined = string;
            }

            public final void run() {
                boolean bl = false;
                BuildIssueUtilKt.updateUsageTracker(this.$issueDataProjectPath$inlined, AndroidStudioEvent.GradleSyncFailure.OLD_ANDROID_PLUGIN);
            }
        }, ModalityState.defaultModalityState());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean consumeBuildOutputFailureMessage(@NotNull String message2, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Object element$iv;
        String it;
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        Iterable $this$all$iv = AgpVersionTooOld.Companion.getALWAYS_PRESENT_STRINGS();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            element$iv = iterator2.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (StringsKt.contains$default((CharSequence)failureCause, (CharSequence)it, (boolean)false, (int)2, null));
        boolean bl = false;
        if (bl) return true;
        $this$all$iv = AgpVersionIncompatible.Companion.getALWAYS_PRESENT_STRINGS();
        $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            element$iv = iterator2.next();
            it = (String)element$iv;
            boolean bl2 = false;
        } while (StringsKt.contains$default((CharSequence)failureCause, (CharSequence)it, (boolean)false, (int)2, null));
        boolean bl3 = false;
        if (bl3) return true;
        $this$all$iv = AgpVersionTooNew.Companion.getALWAYS_PRESENT_STRINGS();
        $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            element$iv = iterator2.next();
            it = (String)element$iv;
            boolean bl4 = false;
        } while (StringsKt.contains$default((CharSequence)failureCause, (CharSequence)it, (boolean)false, (int)2, null));
        return false;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/AgpVersionNotSupportedIssueChecker$Companion;", "", "()V", "PREVIEW_URL", "", "TOO_NEW_URL", "TOO_OLD_URL", "intellij.android.projectSystem.gradle.upgrade"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

