/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.project.sync.errors.AgpVersionNotSupportedIssueCheckerKt;
import com.android.tools.idea.gradle.project.sync.idea.issues.DescribedBuildIssueQuickFix;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/AgpUpgradeQuickFix;", "Lcom/android/tools/idea/gradle/project/sync/idea/issues/DescribedBuildIssueQuickFix;", "currentAgpVersion", "Lcom/android/ide/common/repository/AgpVersion;", "(Lcom/android/ide/common/repository/AgpVersion;)V", "getCurrentAgpVersion", "()Lcom/android/ide/common/repository/AgpVersion;", "description", "", "getDescription", "()Ljava/lang/String;", "id", "getId", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.android.projectSystem.gradle.upgrade"})
public final class AgpUpgradeQuickFix
implements DescribedBuildIssueQuickFix {
    @NotNull
    private final AgpVersion currentAgpVersion;
    @NotNull
    private final String id;
    @NotNull
    private final String description;

    public AgpUpgradeQuickFix(@NotNull AgpVersion currentAgpVersion) {
        Intrinsics.checkNotNullParameter((Object)currentAgpVersion, (String)"currentAgpVersion");
        this.currentAgpVersion = currentAgpVersion;
        this.id = "android.gradle.plugin.forced.update";
        this.description = "Upgrade to a supported version";
    }

    @NotNull
    public final AgpVersion getCurrentAgpVersion() {
        return this.currentAgpVersion;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        CompletableFuture future2 = new CompletableFuture();
        AgpVersionNotSupportedIssueCheckerKt.access$updateAndRequestSync(project, this.currentAgpVersion, future2);
        return future2;
    }
}

