/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.annotations.concurrency.UiThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.importing.OpenMigrationToGradleUrlHyperlink;
import com.android.tools.idea.gradle.project.sync.GradleProjectModels;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.idea.GradleSyncExecutor;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0017J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\"\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/gradle/project/sync/GradleSyncInvokerImpl;", "Lcom/android/tools/idea/gradle/project/sync/GradleSyncInvoker;", "()V", "fetchAndMergeNativeVariants", "", "project", "Lcom/intellij/openapi/project/Project;", "requestedAbis", "", "", "fetchGradleModels", "Lcom/android/tools/idea/gradle/project/sync/GradleProjectModels;", "requestProjectSync", "request", "Lcom/android/tools/idea/gradle/project/sync/GradleSyncInvoker$Request;", "listener", "Lcom/android/tools/idea/gradle/project/sync/GradleSyncListener;", "Companion", "intellij.android.projectSystem.gradle"})
public final class GradleSyncInvokerImpl
implements GradleSyncInvoker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @Override
    public void requestProjectSync(@NotNull Project project, @NotNull GradleSyncInvoker.Request request2, @Nullable GradleSyncListener listener2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        if (GradleSyncState.Companion.getInstance(project).isSyncInProgress()) {
            GradleSyncListener gradleSyncListener = listener2;
            if (gradleSyncListener != null) {
                gradleSyncListener.syncSkipped(project);
            }
            return;
        }
        if (GradleBuildInvoker.Companion.getInstance(project).getInternalIsBuildRunning()) {
            GradleSyncListener gradleSyncListener = listener2;
            if (gradleSyncListener != null) {
                gradleSyncListener.syncSkipped(project);
            }
            return;
        }
        Runnable syncTask2 = new Runnable(project, listener2, request2){
            final /* synthetic */ Project $project;
            final /* synthetic */ GradleSyncListener $listener;
            final /* synthetic */ GradleSyncInvoker.Request $request;
            {
                this.$project = $project;
                this.$listener = $listener;
                this.$request = $request;
            }

            public final void run() {
                ExternalSystemUtil.ensureToolWindowContentInitialized((Project)this.$project, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID);
                if (com.android.tools.idea.gradle.project.sync.GradleSyncInvokerImpl$Companion.access$prepareProject(GradleSyncInvokerImpl.Companion, this.$project, this.$listener)) {
                    com.android.tools.idea.gradle.project.sync.GradleSyncInvokerImpl$Companion.access$sync(GradleSyncInvokerImpl.Companion, this.$project, this.$request, this.$listener);
                }
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            application.invokeAndWait(syncTask2);
        } else {
            ApplicationManager.getApplication().invokeLater(syncTask2);
        }
    }

    @Override
    @WorkerThread
    public void fetchAndMergeNativeVariants(@NotNull Project project, @NotNull Set<String> requestedAbis) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(requestedAbis, (String)"requestedAbis");
        new GradleSyncExecutor(project).fetchAndMergeNativeVariants(requestedAbis);
    }

    @Override
    @WorkerThread
    @NotNull
    public GradleProjectModels fetchGradleModels(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GradleProjectModels gradleProjectModels = new GradleSyncExecutor(project).fetchGradleModels();
        Intrinsics.checkNotNullExpressionValue((Object)gradleProjectModels, (String)"GradleSyncExecutor(project).fetchGradleModels()");
        return gradleProjectModels;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Logger logger2 = Logger.getInstance(GradleSyncInvoker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(GradleSyncInvoker::class.java)");
        LOG = logger2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\"\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0003R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/gradle/project/sync/GradleSyncInvokerImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "prepareProject", "", "project", "Lcom/intellij/openapi/project/Project;", "listener", "Lcom/android/tools/idea/gradle/project/sync/GradleSyncListener;", "sync", "", "request", "Lcom/android/tools/idea/gradle/project/sync/GradleSyncInvoker$Request;", "intellij.android.projectSystem.gradle"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean prepareProject(Project project, GradleSyncListener listener2) {
            GradleProjectInfo gradleProjectInfo = GradleProjectInfo.getInstance(project);
            Intrinsics.checkNotNullExpressionValue((Object)gradleProjectInfo, (String)"getInstance(project)");
            GradleProjectInfo projectInfo = gradleProjectInfo;
            if (projectInfo.isBuildWithGradle()) {
                FileDocumentManager.getInstance().saveAllDocuments();
                return true;
            }
            AppUIUtil.invokeLaterIfProjectAlive((Project)project, (Runnable)new Runnable(project, listener2){
                final /* synthetic */ Project $project;
                final /* synthetic */ GradleSyncListener $listener;
                {
                    this.$project = $project;
                    this.$listener = $listener;
                }

                public final void run() {
                    block0: {
                        String string = "The project '%s' is not a Gradle-based project";
                        Object[] objectArray = new Object[]{this.$project.getName()};
                        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                        String msg = string2;
                        GradleSyncInvokerImpl.access$getLOG$cp().error(msg);
                        NotificationHyperlink[] notificationHyperlinkArray = new NotificationHyperlink[]{new OpenMigrationToGradleUrlHyperlink()};
                        AndroidNotification.getInstance(this.$project).showBalloon("Project Sync", msg, NotificationType.ERROR, notificationHyperlinkArray);
                        GradleSyncListener gradleSyncListener = this.$listener;
                        if (gradleSyncListener == null) break block0;
                        gradleSyncListener.syncFailed(this.$project, msg);
                    }
                }
            });
            return false;
        }

        @UiThread
        private final void sync(Project project, GradleSyncInvoker.Request request2, GradleSyncListener listener2) {
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                }

                public final void run() {
                    GradleSyncMessages.getInstance(this.$project).removeAllMessages();
                }
            });
            new GradleSyncExecutor(project).sync(request2, listener2);
        }

        public static final /* synthetic */ boolean access$prepareProject(Companion $this, Project project, GradleSyncListener listener2) {
            return $this.prepareProject(project, listener2);
        }

        public static final /* synthetic */ void access$sync(Companion $this, Project project, GradleSyncInvoker.Request request2, GradleSyncListener listener2) {
            $this.sync(project, request2, listener2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

