/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.importing;

import com.android.utils.BuildScriptUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class ProjectFolder {
    public abstract void createTopLevelBuildFile() throws IOException;

    public abstract void createIdeaProjectFolder() throws IOException;

    public static void deleteLibrariesFolder(@NotNull File projectFolder) {
        File librariesFolderPath;
        File ideaFolderPath = new File(projectFolder, ".idea");
        if (ideaFolderPath.isDirectory() && (librariesFolderPath = new File(ideaFolderPath, "libraries")).exists() && !FileUtil.delete((File)librariesFolderPath)) {
            Logger.getInstance(ProjectFolder.class).info(String.format("Failed to delete %1$s'", librariesFolderPath.getPath()));
        }
    }

    @VisibleForTesting
    static class ProjectFolderImpl
    extends ProjectFolder {
        @NotNull
        private final File myPath;

        ProjectFolderImpl(@NotNull File path2) {
            this.myPath = path2;
        }

        @Override
        public void createTopLevelBuildFile() throws IOException {
            File buildFile = BuildScriptUtil.findGradleBuildFile((File)this.myPath);
            if (buildFile.isFile()) {
                return;
            }
            FileUtilRt.createIfNotExists((File)buildFile);
            String contents = "// Top-level build file where you can add configuration options common to all sub-projects/modules." + System.lineSeparator();
            FileUtil.writeToFile((File)buildFile, (String)contents);
        }

        @Override
        public void createIdeaProjectFolder() throws IOException {
            ProjectFolderImpl.deleteLibrariesFolder(this.myPath);
            File ideaFolderPath = new File(this.myPath, ".idea");
            FileUtil.ensureExists((File)ideaFolderPath);
        }
    }

    public static class Factory {
        @NotNull
        public ProjectFolder create(@NotNull File projectFolderPath) {
            return new ProjectFolderImpl(projectFolderPath);
        }
    }
}

