/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.importing;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.importing.GradleProjectImporterKt;
import com.android.tools.idea.gradle.project.importing.ProjectFolder;
import com.android.tools.idea.gradle.project.importing.TopLevelModuleFactory;
import com.android.tools.idea.gradle.project.sync.SdkSync;
import com.android.tools.idea.gradle.project.sync.jdk.JdkUtils;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.project.AndroidProjectTypesProviderKt;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.util.ToolWindows;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.impl.OpenProjectTaskBuilder;
import com.intellij.ide.impl.OpenProjectTaskKt;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypeService;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableRunnable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.open.GradleProjectImportUtil;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0002 !B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u001f\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007J\"\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/gradle/project/importing/GradleProjectImporter;", "", "()V", "mySdkSync", "Lcom/android/tools/idea/gradle/project/sync/SdkSync;", "myTopLevelModuleFactory", "Lcom/android/tools/idea/gradle/project/importing/TopLevelModuleFactory;", "myProjectFolderFactory", "Lcom/android/tools/idea/gradle/project/importing/ProjectFolder$Factory;", "(Lcom/android/tools/idea/gradle/project/sync/SdkSync;Lcom/android/tools/idea/gradle/project/importing/TopLevelModuleFactory;Lcom/android/tools/idea/gradle/project/importing/ProjectFolder$Factory;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "createProject", "Lcom/intellij/openapi/project/Project;", "projectName", "", "projectFolderPath", "Ljava/io/File;", "useDefaultProjectAsTemplate", "", "importAndOpenProjectCore", "projectToClose", "forceOpenInNewFrame", "projectFolder", "Lcom/intellij/openapi/vfs/VirtualFile;", "importProjectNoSync", "", "request", "Lcom/android/tools/idea/gradle/project/importing/GradleProjectImporter$Request;", "setUpLocalProperties", "Companion", "Request", "intellij.android.projectSystem.gradle"})
public final class GradleProjectImporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SdkSync mySdkSync;
    @NotNull
    private final TopLevelModuleFactory myTopLevelModuleFactory;
    @NotNull
    private final ProjectFolder.Factory myProjectFolderFactory;
    @NonNls
    @NotNull
    private static final String SHOW_UNLINKED_GRADLE_POPUP = "show.inlinked.gradle.project.popup";

    @NonInjectable
    @VisibleForTesting
    public GradleProjectImporter(@NotNull SdkSync mySdkSync, @NotNull TopLevelModuleFactory myTopLevelModuleFactory, @NotNull ProjectFolder.Factory myProjectFolderFactory) {
        Intrinsics.checkNotNullParameter((Object)mySdkSync, (String)"mySdkSync");
        Intrinsics.checkNotNullParameter((Object)myTopLevelModuleFactory, (String)"myTopLevelModuleFactory");
        Intrinsics.checkNotNullParameter((Object)myProjectFolderFactory, (String)"myProjectFolderFactory");
        this.mySdkSync = mySdkSync;
        this.myTopLevelModuleFactory = myTopLevelModuleFactory;
        this.myProjectFolderFactory = myProjectFolderFactory;
    }

    public GradleProjectImporter() {
        SdkSync sdkSync = SdkSync.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)sdkSync, (String)"getInstance()");
        this(sdkSync, new TopLevelModuleFactory(), new ProjectFolder.Factory());
    }

    @Nullable
    public final Project importAndOpenProjectCore(@Nullable Project projectToClose, boolean forceOpenInNewFrame, @NotNull VirtualFile projectFolder) {
        Intrinsics.checkNotNullParameter((Object)projectFolder, (String)"projectFolder");
        File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)projectFolder);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"virtualToIoFile(projectFolder)");
        File projectFolderPath = file2;
        try {
            this.setUpLocalProperties(projectFolderPath);
            String string = projectFolder.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectFolder.name");
            String projectName = string;
            Project newProject2 = GradleProjectImporter.createProject$default(this, projectName, projectFolderPath, false, 4, null);
            this.importProjectNoSync(new Request(newProject2));
            ProjectManagerEx projectManagerEx = ProjectManagerEx.Companion.getInstanceEx();
            Path path2 = projectFolderPath.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"projectFolderPath.toPath()");
            return projectManagerEx.openProject(path2, OpenProjectTaskKt.OpenProjectTask((Function1)((Function1)new Function1<OpenProjectTaskBuilder, Unit>(forceOpenInNewFrame, projectToClose, newProject2){
                final /* synthetic */ boolean $forceOpenInNewFrame;
                final /* synthetic */ Project $projectToClose;
                final /* synthetic */ Project $newProject;
                {
                    this.$forceOpenInNewFrame = $forceOpenInNewFrame;
                    this.$projectToClose = $projectToClose;
                    this.$newProject = $newProject;
                    super(1);
                }

                public final void invoke(@NotNull OpenProjectTaskBuilder $this$OpenProjectTask) {
                    Intrinsics.checkNotNullParameter((Object)$this$OpenProjectTask, (String)"$this$OpenProjectTask");
                    $this$OpenProjectTask.setForceOpenInNewFrame(this.$forceOpenInNewFrame);
                    $this$OpenProjectTask.setProjectToClose(this.$projectToClose);
                    $this$OpenProjectTask.setNewProject(false);
                    $this$OpenProjectTask.setUseDefaultProjectAsTemplate(Boolean.valueOf(false));
                    $this$OpenProjectTask.setProject(this.$newProject);
                }
            })));
        }
        catch (Throwable e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                ExceptionUtil.rethrowUnchecked((Throwable)e);
            }
            Messages.showErrorDialog((String)e.getMessage(), (String)"Project Import");
            this.getLogger().error(e);
            return null;
        }
    }

    private final void setUpLocalProperties(File projectFolderPath) throws IOException {
        try {
            LocalProperties localProperties = new LocalProperties(projectFolderPath);
            if (IdeInfo.getInstance().isAndroidStudio()) {
                this.mySdkSync.syncIdeAndProjectAndroidSdks(localProperties);
            }
        }
        catch (IOException e) {
            this.getLogger().info("Failed to sync SDKs", (Throwable)e);
            Messages.showErrorDialog((String)e.getMessage(), (String)"Project Import");
            throw e;
        }
    }

    private final Logger getLogger() {
        Logger logger2 = Logger.getInstance(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(javaClass)");
        return logger2;
    }

    public final void importProjectNoSync(@NotNull Request request2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        File projectFolderPath = Projects.getBaseDirPath((Project)request2.project).getAbsoluteFile();
        ProjectFolder projectFolder = this.myProjectFolderFactory.create(projectFolderPath);
        Intrinsics.checkNotNullExpressionValue((Object)projectFolder, (String)"myProjectFolderFactory.create(projectFolderPath)");
        ProjectFolder projectFolder2 = projectFolder;
        projectFolder2.createTopLevelBuildFile();
        projectFolder2.createIdeaProjectFolder();
        Project newProject2 = request2.project;
        GradleProjectInfo gradleProjectInfo = GradleProjectInfo.getInstance(newProject2);
        Intrinsics.checkNotNullExpressionValue((Object)gradleProjectInfo, (String)"getInstance(newProject)");
        GradleProjectInfo projectInfo = gradleProjectInfo;
        projectInfo.setNewProject(request2.isNewProject);
        GradleProjectImporter.Companion.silenceUnlinkedGradleProjectNotificationIfNecessary(newProject2);
        WriteAction.runAndWait((ThrowableRunnable)new ThrowableRunnable(request2, newProject2, this){
            final /* synthetic */ Request $request;
            final /* synthetic */ Project $newProject;
            final /* synthetic */ GradleProjectImporter this$0;
            {
                this.$request = $request;
                this.$newProject = $newProject;
                this.this$0 = $receiver;
            }

            public final void run() {
                LanguageLevelProjectExtension extension;
                if (this.$request.javaLanguageLevel != null && (extension = LanguageLevelProjectExtension.getInstance((Project)this.$newProject)) != null) {
                    LanguageLevel languageLevel = this.$request.javaLanguageLevel;
                    Intrinsics.checkNotNull((Object)languageLevel);
                    extension.setLanguageLevel(languageLevel);
                }
                String[] stringArray = new String[]{"build", "classes"};
                File compilerOutputFolderPath = new File(Projects.getBaseDirPath((Project)this.$newProject), FileUtil.join((String[])stringArray));
                String string = FilePaths.pathToIdeaUrl((File)compilerOutputFolderPath);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathToIdeaUrl(compilerOutputFolderPath)");
                String compilerOutputFolderUrl = string;
                CompilerProjectExtension compilerProjectExtension = CompilerProjectExtension.getInstance((Project)this.$newProject);
                Intrinsics.checkNotNull((Object)compilerProjectExtension);
                CompilerProjectExtension compilerProjectExt = compilerProjectExtension;
                compilerProjectExt.setCompilerOutputUrl(compilerOutputFolderUrl);
                ProjectTypeService.setProjectType((Project)this.$newProject, (ProjectType)AndroidProjectTypesProviderKt.getANDROID_PROJECT_TYPE());
                GradleProjectImporter.access$getMyTopLevelModuleFactory$p(this.this$0).createOrConfigureTopLevelModule(this.$newProject);
            }
        });
        ExternalSystemUtil.invokeLater((Project)newProject2, (Runnable)new Runnable(newProject2){
            final /* synthetic */ Project $newProject;
            {
                this.$newProject = $newProject;
            }

            public final void run() {
                ToolWindows.activateProjectView(this.$newProject);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @NotNull
    public final Project createProject(@NotNull String projectName, @NotNull File projectFolderPath, boolean useDefaultProjectAsTemplate) {
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)projectFolderPath, (String)"projectFolderPath");
        AutoCloseable autoCloseable = (AutoCloseable)GradleProjectInfo.beginInitializingGradleProjectAt(projectFolderPath);
        Throwable throwable = null;
        try {
            AccessToken ignored = (AccessToken)autoCloseable;
            boolean bl = false;
            ProjectManagerEx projectManagerEx = ProjectManagerEx.Companion.getInstanceEx();
            Path path2 = Path.of(projectFolderPath.getPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(projectFolderPath.path)");
            Project project = projectManagerEx.newProject(path2, OpenProjectTaskKt.OpenProjectTask((Function1)((Function1)new Function1<OpenProjectTaskBuilder, Unit>(projectName, useDefaultProjectAsTemplate){
                final /* synthetic */ String $projectName;
                final /* synthetic */ boolean $useDefaultProjectAsTemplate;
                {
                    this.$projectName = $projectName;
                    this.$useDefaultProjectAsTemplate = $useDefaultProjectAsTemplate;
                    super(1);
                }

                public final void invoke(@NotNull OpenProjectTaskBuilder $this$OpenProjectTask) {
                    Intrinsics.checkNotNullParameter((Object)$this$OpenProjectTask, (String)"$this$OpenProjectTask");
                    $this$OpenProjectTask.setProjectName(this.$projectName);
                    $this$OpenProjectTask.setUseDefaultProjectAsTemplate(Boolean.valueOf(this.$useDefaultProjectAsTemplate));
                }
            })));
            if (project == null) {
                throw new NullPointerException("Failed to create a new project");
            }
            Project newProject2 = project;
            Companion.configureNewProject(newProject2);
            Project project2 = newProject2;
            return project2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ Project createProject$default(GradleProjectImporter gradleProjectImporter, String string, File file2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return gradleProjectImporter.createProject(string, file2, bl);
    }

    @JvmOverloads
    @NotNull
    public final Project createProject(@NotNull String projectName, @NotNull File projectFolderPath) {
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)projectFolderPath, (String)"projectFolderPath");
        return GradleProjectImporter.createProject$default(this, projectName, projectFolderPath, false, 4, null);
    }

    @JvmStatic
    @NotNull
    public static final GradleProjectImporter getInstance() {
        return Companion.getInstance();
    }

    @VisibleForTesting
    @JvmStatic
    public static final void configureNewProject(@NotNull Project newProject2) {
        Companion.configureNewProject(newProject2);
    }

    public static final /* synthetic */ TopLevelModuleFactory access$getMyTopLevelModuleFactory$p(GradleProjectImporter $this) {
        return $this.myTopLevelModuleFactory;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bH\u0007J\b\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/gradle/project/importing/GradleProjectImporter$Companion;", "", "()V", "SHOW_UNLINKED_GRADLE_POPUP", "", "beforeOpen", "", "project", "Lcom/intellij/openapi/project/Project;", "beforeOpen$intellij_android_projectSystem_gradle", "configureNewProject", "newProject", "getInstance", "Lcom/android/tools/idea/gradle/project/importing/GradleProjectImporter;", "silenceUnlinkedGradleProjectNotificationIfNecessary", "intellij.android.projectSystem.gradle"})
    @SourceDebugExtension(value={"SMAP\nGradleProjectImporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleProjectImporter.kt\ncom/android/tools/idea/gradle/project/importing/GradleProjectImporter$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,247:1\n1#2:248\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GradleProjectImporter getInstance() {
            Object object = ApplicationManager.getApplication().getService(GradleProjectImporter.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getApplication().getServ\u2026jectImporter::class.java)");
            return (GradleProjectImporter)object;
        }

        public final void beforeOpen$intellij_android_projectSystem_gradle(@NotNull Project project) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Function1 function1 = (Function1)ApplicationManager.getApplication().getUserData(GradleProjectImporterKt.access$getAFTER_CREATE$p());
                if (function1 == null) break block0;
                function1.invoke((Object)project);
            }
        }

        @VisibleForTesting
        @JvmStatic
        public final void configureNewProject(@NotNull Project newProject2) {
            Intrinsics.checkNotNullParameter((Object)newProject2, (String)"newProject");
            GradleSettings gradleSettings = GradleSettings.getInstance((Project)newProject2);
            GradleSettings it = gradleSettings;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            GradleProjectImportUtil.setupGradleSettings((GradleSettings)it);
            GradleSettings gradleSettings2 = gradleSettings;
            Intrinsics.checkNotNullExpressionValue((Object)gradleSettings2, (String)"getInstance(newProject).\u2026t.setupGradleSettings() }");
            GradleSettings gradleSettings3 = gradleSettings2;
            String string = newProject2.getBasePath();
            Intrinsics.checkNotNull((Object)string);
            String string2 = ExternalSystemApiUtil.toCanonicalPath((String)new File(string).getCanonicalPath());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toCanonicalPath(File(new\u2026asePath!!).canonicalPath)");
            String externalProjectPath = string2;
            if (!gradleSettings3.getLinkedProjectsSettings().isEmpty()) {
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    boolean $i$a$-check-GradleProjectImporter$Companion$configureNewProject$22 = false;
                    String $i$a$-check-GradleProjectImporter$Companion$configureNewProject$22 = "configureNewProject should be used with new projects only";
                    throw new IllegalStateException($i$a$-check-GradleProjectImporter$Companion$configureNewProject$22.toString());
                }
                for (GradleProjectSettings setting : gradleSettings3.getLinkedProjectsSettings()) {
                    gradleSettings3.unlinkExternalProject(setting.getExternalProjectPath());
                }
            }
            GradleProjectSettings projectSettings = new GradleProjectSettings();
            Path path2 = new File(externalProjectPath).toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"File(externalProjectPath).toPath()");
            GradleProjectImportUtil.setupGradleProjectSettings((GradleProjectSettings)projectSettings, (Project)newProject2, (Path)path2);
            projectSettings.setGradleJvm("#USE_PROJECT_JDK");
            ExternalSystemApiUtil.getSettings((Project)newProject2, (ProjectSystemId)GradleConstants.SYSTEM_ID).linkProject((ExternalProjectSettings)projectSettings);
            WriteAction.runAndWait((ThrowableRunnable)new ThrowableRunnable(newProject2){
                final /* synthetic */ Project $newProject;
                {
                    this.$newProject = $newProject;
                }

                public final void run() {
                    block0: {
                        Path path2 = IdeSdks.getInstance().getEmbeddedJdkPath();
                        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getInstance().embeddedJdkPath");
                        Path embeddedJdkPath = path2;
                        String jdkTableEntry = JdkUtils.INSTANCE.addOrRecreateDedicatedJdkTableEntry(((Object)embeddedJdkPath).toString());
                        Sdk sdk = ProjectJdkTable.getInstance().findJdk(jdkTableEntry);
                        if (sdk == null) break block0;
                        Sdk sdk2 = sdk;
                        Project project = this.$newProject;
                        Sdk it = sdk2;
                        boolean bl = false;
                        ProjectRootManager.getInstance((Project)project).setProjectSdk(it);
                    }
                }
            });
            this.beforeOpen$intellij_android_projectSystem_gradle(newProject2);
        }

        private final void silenceUnlinkedGradleProjectNotificationIfNecessary(Project newProject2) {
            GradleSettings gradleSettings = GradleSettings.getInstance((Project)newProject2);
            Intrinsics.checkNotNullExpressionValue((Object)gradleSettings, (String)"getInstance(newProject)");
            GradleSettings gradleSettings2 = gradleSettings;
            if (gradleSettings2.getLinkedProjectsSettings().isEmpty()) {
                PropertiesComponent.getInstance((Project)newProject2).setValue(SHOW_UNLINKED_GRADLE_POPUP, false, true);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/gradle/project/importing/GradleProjectImporter$Request;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "isNewProject", "", "javaLanguageLevel", "Lcom/intellij/pom/java/LanguageLevel;", "intellij.android.projectSystem.gradle"})
    public static final class Request {
        @JvmField
        @NotNull
        public final Project project;
        @JvmField
        @Nullable
        public LanguageLevel javaLanguageLevel;
        @JvmField
        public boolean isNewProject;

        public Request(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }
    }
}

