/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.common;

import com.android.ide.common.repository.GoogleMavenRepositoryKt;
import com.android.ide.gradle.model.GradlePluginModel;
import com.android.ide.gradle.model.builder.AndroidStudioToolingPlugin;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.gradle.util.ImportUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.serviceContainer.NonInjectable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleInitScripts {
    @NotNull
    private final EmbeddedDistributionPaths myEmbeddedDistributionPaths;
    @NotNull
    private final ContentCreator myContentCreator;

    @NotNull
    public static GradleInitScripts getInstance() {
        return (GradleInitScripts)ApplicationManager.getApplication().getService(GradleInitScripts.class);
    }

    public GradleInitScripts() {
        this(EmbeddedDistributionPaths.getInstance(), new ContentCreator());
    }

    @NonInjectable
    @VisibleForTesting
    GradleInitScripts(@NotNull EmbeddedDistributionPaths embeddedDistributionPaths, @NotNull ContentCreator contentCreator) {
        this.myEmbeddedDistributionPaths = embeddedDistributionPaths;
        this.myContentCreator = contentCreator;
    }

    public void addLocalMavenRepoInitScriptCommandLineArg(@NotNull List<String> allArgs) {
        File initScriptFile = this.createLocalMavenRepoInitScriptFile();
        if (initScriptFile != null) {
            GradleInitScripts.addInitScriptCommandLineArg(initScriptFile, allArgs);
        }
    }

    @Nullable
    private File createLocalMavenRepoInitScriptFile() {
        String content2;
        List repoPaths = this.myEmbeddedDistributionPaths.findAndroidStudioLocalMavenRepoPaths().stream().map(File::getPath).collect(Collectors.toCollection(ArrayList::new));
        if (!"https://maven.google.com/".equals(GoogleMavenRepositoryKt.GMAVEN_BASE_URL)) {
            repoPaths.add(GoogleMavenRepositoryKt.GMAVEN_BASE_URL);
        }
        if ((content2 = this.myContentCreator.createLocalMavenRepoInitScriptContent(repoPaths)) != null) {
            String fileName = "sync.local.repo";
            try {
                return GradleInitScripts.createInitScriptFile(fileName, content2);
            }
            catch (Throwable e) {
                String message2 = String.format("Failed to set up Gradle init script: '%1$s'", fileName);
                GradleInitScripts.getLogger().warn(message2, e);
            }
        }
        return null;
    }

    public void addAndroidStudioToolingPluginInitScriptCommandLineArg(@NotNull List<String> allArgs) {
        try {
            File initScriptFile = this.createAndroidStudioToolingPluginInitScriptFile();
            GradleInitScripts.addInitScriptCommandLineArg(initScriptFile, allArgs);
        }
        catch (IOException e) {
            GradleInitScripts.getLogger().warn("Failed to create init script that applies the Android Studio Tooling plugin.", (Throwable)e);
        }
    }

    @NotNull
    private File createAndroidStudioToolingPluginInitScriptFile() throws IOException {
        String content2 = this.myContentCreator.createAndroidStudioToolingPluginInitScriptContent();
        return GradleInitScripts.createInitScriptFile("sync.studio.tooling", content2);
    }

    @NotNull
    private static File createInitScriptFile(@NotNull String fileName, @NotNull String content2) throws IOException {
        File file2 = FileUtil.createTempFile((String)fileName, (String)".gradle");
        try {
            file2.deleteOnExit();
            FileUtil.writeToFile((File)file2, (String)content2);
            GradleInitScripts.getLogger().info(String.format("init script file %s contents %s", fileName, GradleInitScripts.escapeAsStringLiteral(content2)));
        }
        catch (Exception ex) {
            GradleInitScripts.getLogger().error("Failed to create init script: " + fileName, (Throwable)ex);
            throw ex;
        }
        return file2;
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(GradleInitScripts.class);
    }

    @NotNull
    private static String escapeAsStringLiteral(@NotNull String s) {
        Escaper escaper = Escapers.builder().addEscape('\b', "\\b").addEscape('\t', "\\t").addEscape('\n', "\\n").addEscape('\f', "\\f").addEscape('\r', "\\r").addEscape('\"', "\\\"").addEscape('\\', "\\\\").build();
        return "\"" + escaper.escape(s) + "\"";
    }

    private static void addInitScriptCommandLineArg(@NotNull File initScriptFile, @NotNull List<String> allArgs) {
        allArgs.add("--init-script");
        allArgs.add(initScriptFile.getAbsolutePath());
    }

    @VisibleForTesting
    static class ContentCreator {
        @NotNull
        private final AndroidStudioToolingPluginJars myAndroidStudioToolingPluginJars;

        ContentCreator() {
            this(new AndroidStudioToolingPluginJars());
        }

        ContentCreator(@NotNull AndroidStudioToolingPluginJars androidStudioToolingPluginJars) {
            this.myAndroidStudioToolingPluginJars = androidStudioToolingPluginJars;
        }

        @Nullable
        String createLocalMavenRepoInitScriptContent(@NotNull List<String> repoPaths) {
            if (repoPaths.isEmpty()) {
                return null;
            }
            StringBuilder paths = new StringBuilder();
            for (String path2 : repoPaths) {
                path2 = ImportUtil.escapeGroovyStringLiteral(path2);
                paths.append("      maven { url '").append(path2).append("'}\n");
            }
            return "import org.gradle.util.GradleVersion\n\nallprojects {\n  buildscript {\n    repositories {\n" + paths + "    }\n  }\n  repositories {\n" + paths + "  }\n}\nif (GradleVersion.current().baseVersion >= GradleVersion.version('7.0')) {\n  beforeSettings {\n    it.pluginManagement {\n      repositories {\n" + paths + "      }\n    }\n  }\n}\nif (GradleVersion.current().baseVersion >= GradleVersion.version('6.8')) {\n  beforeSettings {\n    it.dependencyResolutionManagement {\n      repositories {\n" + paths + "      }\n    }\n  }\n}\n";
        }

        @NotNull
        String createAndroidStudioToolingPluginInitScriptContent() {
            List<String> paths = this.myAndroidStudioToolingPluginJars.getJarPaths();
            return "initscript {\n    dependencies {\n        " + this.createClassPathString(paths) + "\n    }\n}\nallprojects {\n    apply plugin: " + AndroidStudioToolingPlugin.class.getName() + "\n}\n";
        }

        @NotNull
        String createClassPathString(@NotNull List<String> paths) {
            StringBuilder classpath = new StringBuilder();
            classpath.append("classpath files([");
            int pathCount = paths.size();
            for (int i = 0; i < pathCount; ++i) {
                String jarPath = ImportUtil.escapeGroovyStringLiteral(paths.get(i));
                classpath.append("mapPath('").append(jarPath).append("')");
                if (i >= pathCount - 1) continue;
                classpath.append(", ");
            }
            classpath.append("])");
            return classpath.toString();
        }
    }

    @VisibleForTesting
    static class AndroidStudioToolingPluginJars {
        AndroidStudioToolingPluginJars() {
        }

        @NotNull
        List<String> getJarPaths() {
            return Stream.of(AndroidStudioToolingPluginJars.getJarPathForClass(GradlePluginModel.class), AndroidStudioToolingPluginJars.getJarPathForClass(AndroidStudioToolingPlugin.class), AndroidStudioToolingPluginJars.getJarPathForClass(KType.class)).filter(Objects::nonNull).collect(Collectors.toList());
        }

        private static String getJarPathForClass(@NotNull Class<?> aClass) {
            return FileUtil.toCanonicalPath((String)PathManager.getJarPathForClass(aClass));
        }
    }
}

