/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.output;

import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import java.io.File;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXParseException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0010\u0010\t\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u000b\u0018\u00010\nH\u0016J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/XmlErrorOutputParser;", "Lcom/intellij/build/output/BuildOutputParser;", "()V", "parse", "", "line", "", "reader", "Lcom/intellij/build/output/BuildOutputInstantReader;", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "parseNumber", "", "numberAsString", "Companion", "intellij.android.projectSystem.gradle"})
public final class XmlErrorOutputParser
implements BuildOutputParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String XML_PARSING_GROUP = "Xml parsing";
    private static final Pattern pattern = Pattern.compile("^(?:publicId: .*?)?(?:; systemId: (.*?))?(?:; lineNumber: (.*?))?(?:; columnNumber: (.*?))?(?:; (.*))?$");

    public boolean parse(@Nullable String line2, @Nullable BuildOutputInstantReader reader2, @Nullable Consumer<? super BuildEvent> messageConsumer) {
        if (line2 == null || reader2 == null || messageConsumer == null) {
            return false;
        }
        CharSequence charSequence = line2;
        String string = SAXParseException.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SAXParseException::class.java.name");
        int matchIndex = StringsKt.indexOf$default((CharSequence)charSequence, (String)string, (int)0, (boolean)false, (int)6, null);
        if (matchIndex == -1) {
            return false;
        }
        String string2 = line2.substring(matchIndex + SAXParseException.class.getName().length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        String messageLine = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        Matcher matcher = pattern.matcher(messageLine);
        if (matcher.matches()) {
            String systemId = matcher.group(1);
            int lineNumber = this.parseNumber(matcher.group(2));
            int columnNumber = this.parseNumber(matcher.group(3));
            String string3 = matcher.group(4);
            if (string3 == null) {
                string3 = "";
            }
            String message2 = string3;
            File file2 = null;
            if (systemId != null) {
                if (StringsKt.startsWith$default((String)systemId, (String)"file:", (boolean)false, (int)2, null)) {
                    String string4 = systemId.substring(5);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                    v5 = new File(string4);
                } else {
                    v5 = file2 = new File(systemId);
                }
            }
            if (file2 != null && file2.isFile()) {
                messageConsumer.accept((BuildEvent)new FileMessageEventImpl(reader2.getParentEventId(), MessageEvent.Kind.ERROR, "Xml parsing errors", message2, message2, new FilePosition(file2, lineNumber, columnNumber)));
            } else {
                messageConsumer.accept((BuildEvent)new MessageEventImpl(reader2.getParentEventId(), MessageEvent.Kind.ERROR, "Xml parsing errors", message2, message2));
            }
            return true;
        }
        return false;
    }

    private final int parseNumber(String numberAsString) {
        int n;
        if (numberAsString == null) {
            return -1;
        }
        try {
            n = Integer.valueOf(numberAsString) - 1;
        }
        catch (Exception e) {
            n = -1;
        }
        return n;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/XmlErrorOutputParser$Companion;", "", "()V", "XML_PARSING_GROUP", "", "pattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "intellij.android.projectSystem.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

