/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.output;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.BuildIssueEventImpl;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\nH\u0016\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/TomlErrorParser;", "Lcom/intellij/build/output/BuildOutputParser;", "()V", "parse", "", "line", "", "reader", "Lcom/intellij/build/output/BuildOutputInstantReader;", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "Companion", "intellij.android.projectSystem.gradle"})
public final class TomlErrorParser
implements BuildOutputParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Pattern PROBLEM_LINE_PATTERN;
    @NotNull
    private static final Pattern REASON_POSITION_PATTERN;
    @NotNull
    private static final Pattern REASON_FILE_AND_POSITION_PATTERN;

    public boolean parse(@NotNull String line2, @NotNull BuildOutputInstantReader reader2, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)line2, (String)"line");
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        if (!StringsKt.startsWith$default((String)line2, (String)"FAILURE: Build failed with an exception.", (boolean)false, (int)2, null)) {
            return false;
        }
        CharSequence charSequence = reader2.readLine();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            return false;
        }
        String whereOrWhatLine = reader2.readLine();
        if (Intrinsics.areEqual((Object)whereOrWhatLine, (Object)"* Where:")) {
            CharSequence charSequence2 = reader2.readLine();
            if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
                return false;
            }
            charSequence2 = reader2.readLine();
            if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2))) {
                return false;
            }
            whereOrWhatLine = reader2.readLine();
        }
        if (!Intrinsics.areEqual((Object)whereOrWhatLine, (Object)"* What went wrong:")) {
            return false;
        }
        String string = reader2.readLine();
        if (string == null) {
            return false;
        }
        String firstDescriptionLine = string;
        if (!StringsKt.endsWith$default((String)firstDescriptionLine, (String)"Invalid TOML catalog definition:", (boolean)false, (int)2, null)) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Invalid TOML catalog definition.");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        StringBuilder description2 = StringsKt.appendln((StringBuilder)stringBuilder);
        String string2 = reader2.readLine();
        if (string2 == null) {
            return false;
        }
        String problemLine = string2;
        Matcher problemLineMatcher = PROBLEM_LINE_PATTERN.matcher(problemLine);
        if (!problemLineMatcher.matches()) {
            return false;
        }
        String catalog = problemLineMatcher.group(1);
        StringBuilder stringBuilder2 = description2.append(problemLine);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        Ref.ObjectRef reasonPosition = new Ref.ObjectRef();
        Ref.ObjectRef absolutePath = new Ref.ObjectRef();
        while (true) {
            String descriptionLine;
            if (reader2.readLine() == null) {
                return false;
            }
            if (StringsKt.startsWith$default((String)descriptionLine, (String)"> Invalid TOML catalog definition", (boolean)false, (int)2, null)) break;
            if (reasonPosition.element == null) {
                Matcher reasonFileAndPositionLineMatcher;
                Matcher reasonPositionLineMatcher = REASON_POSITION_PATTERN.matcher(descriptionLine);
                if (reasonPositionLineMatcher.matches()) {
                    String string3 = reasonPositionLineMatcher.group(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"reasonPositionLineMatcher.group(1)");
                    Integer n = StringsKt.toIntOrNull((String)string3);
                    String string4 = reasonPositionLineMatcher.group(2);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"reasonPositionLineMatcher.group(2)");
                    reasonPosition.element = TuplesKt.to((Object)n, (Object)StringsKt.toIntOrNull((String)string4));
                }
                if ((reasonFileAndPositionLineMatcher = REASON_FILE_AND_POSITION_PATTERN.matcher(descriptionLine)).matches()) {
                    String string5 = reasonFileAndPositionLineMatcher.group(2);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"reasonFileAndPositionLineMatcher.group(2)");
                    Integer n = StringsKt.toIntOrNull((String)string5);
                    String string6 = reasonFileAndPositionLineMatcher.group(3);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"reasonFileAndPositionLineMatcher.group(3)");
                    reasonPosition.element = TuplesKt.to((Object)n, (Object)StringsKt.toIntOrNull((String)string6));
                    absolutePath.element = reasonFileAndPositionLineMatcher.group(1);
                }
            }
            StringBuilder stringBuilder3 = description2.append(descriptionLine);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder3);
        }
        BuildIssue buildIssue2 = new BuildIssue(description2, (Ref.ObjectRef<String>)absolutePath, catalog, (Ref.ObjectRef<Pair<Integer, Integer>>)reasonPosition){
            @NotNull
            private final String description;
            @NotNull
            private final List<BuildIssueQuickFix> quickFixes;
            @NotNull
            private final String title;
            final /* synthetic */ Ref.ObjectRef<String> $absolutePath;
            final /* synthetic */ String $catalog;
            final /* synthetic */ Ref.ObjectRef<Pair<Integer, Integer>> $reasonPosition;
            {
                this.$absolutePath = $absolutePath;
                this.$catalog = $catalog;
                this.$reasonPosition = $reasonPosition;
                String string = $description.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"description.toString()");
                this.description = ((Object)StringsKt.trimEnd((CharSequence)string)).toString();
                this.quickFixes = CollectionsKt.emptyList();
                this.title = "Invalid TOML catalog definition.";
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @NotNull
            public String getTitle() {
                return this.title;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project) {
                Object object;
                VirtualFile virtualFile;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Object object2 = this.$absolutePath.element != null ? VfsUtil.findFile((Path)Paths.get((String)this.$absolutePath.element, new String[0]), (boolean)false) : (this.$catalog != null ? ((virtualFile = project.getBaseDir()) != null && (virtualFile = virtualFile.findChild("gradle")) != null ? virtualFile.findChild(this.$catalog + ".versions.toml") : null) : null);
                if (object2 == null) {
                    return null;
                }
                VirtualFile tomlFile = object2;
                Object object3 = (Pair)this.$reasonPosition.element;
                return (Navigatable)new OpenFileDescriptor(project, tomlFile, object3 != null && (object3 = (Integer)object3.getFirst()) != null ? (Integer)object3 - 1 : 0, (object = (Pair)this.$reasonPosition.element) != null && (object = (Integer)object.getSecond()) != null ? (Integer)object - 1 : 0);
            }
        };
        messageConsumer.accept((BuildEvent)new BuildIssueEventImpl(reader2.getParentEventId(), buildIssue2, MessageEvent.Kind.ERROR));
        return true;
    }

    static {
        Pattern pattern = Pattern.compile("  - Problem: In version catalog ([^ ]+), parsing failed with [0-9]+ error(?:s)?.");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"  - Problem: In\u2026ith [0-9]+ error(?:s)?.\")");
        PROBLEM_LINE_PATTERN = pattern;
        Pattern pattern2 = Pattern.compile("\\s+Reason: At line ([0-9]+), column ([0-9]+):.*");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(\"\\\\s+Reason: At \u2026]+), column ([0-9]+):.*\")");
        REASON_POSITION_PATTERN = pattern2;
        Pattern pattern3 = Pattern.compile("\\s+Reason: In file '([^']+)' at line ([0-9]+), column ([0-9]+):.*");
        Intrinsics.checkNotNullExpressionValue((Object)pattern3, (String)"compile(\"\\\\s+Reason: In \u2026]+), column ([0-9]+):.*\")");
        REASON_FILE_AND_POSITION_PATTERN = pattern3;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/gradle/project/build/output/TomlErrorParser$Companion;", "", "()V", "PROBLEM_LINE_PATTERN", "Ljava/util/regex/Pattern;", "getPROBLEM_LINE_PATTERN", "()Ljava/util/regex/Pattern;", "REASON_FILE_AND_POSITION_PATTERN", "getREASON_FILE_AND_POSITION_PATTERN", "REASON_POSITION_PATTERN", "getREASON_POSITION_PATTERN", "intellij.android.projectSystem.gradle"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pattern getPROBLEM_LINE_PATTERN() {
            return PROBLEM_LINE_PATTERN;
        }

        @NotNull
        public final Pattern getREASON_POSITION_PATTERN() {
            return REASON_POSITION_PATTERN;
        }

        @NotNull
        public final Pattern getREASON_FILE_AND_POSITION_PATTERN() {
            return REASON_FILE_AND_POSITION_PATTERN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

